/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudwatch.options;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Set;
import org.jclouds.cloudwatch.domain.Dimension;
import org.jclouds.cloudwatch.domain.Statistics;
import org.jclouds.cloudwatch.domain.Unit;
import org.jclouds.cloudwatch.options.ListAlarmsForMetric;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class ListAlarmsForMetricTest {
    public void testEmptyOptions() throws Exception {
        Multimap formParameters = new ListAlarmsForMetric().buildFormParameters();
        Assert.assertFalse((boolean)formParameters.containsKey((Object)"Dimensions.member.1.Name"));
        Assert.assertFalse((boolean)formParameters.containsKey((Object)"Dimensions.member.1.Value"));
        Assert.assertFalse((boolean)formParameters.containsKey((Object)"MetricName"));
        Assert.assertFalse((boolean)formParameters.containsKey((Object)"Namespace"));
        Assert.assertFalse((boolean)formParameters.containsKey((Object)"Period"));
        Assert.assertFalse((boolean)formParameters.containsKey((Object)"Statistic"));
        Assert.assertFalse((boolean)formParameters.containsKey((Object)"Unit"));
    }

    public void testPopulatedOptions() throws Exception {
        ImmutableSet dimensions = ImmutableSet.of((Object)new Dimension("TestDimension1", "TestValue1"), (Object)new Dimension("TestDimension2", "TestValue2"));
        String metricName = "TestMetricName";
        String namespace = "AWS/EC2";
        int period = 60;
        Statistics statistic = Statistics.AVERAGE;
        Unit unit = Unit.COUNT;
        Multimap formParameters = new ListAlarmsForMetric().dimensions((Set)dimensions).metricName(metricName).namespace(namespace).period(period).statistic(statistic).unit(unit).buildFormParameters();
        int dimensionIndex = 1;
        for (Dimension dimension : dimensions) {
            Assert.assertEquals((Collection)formParameters.get((Object)("Dimensions.member." + dimensionIndex + ".Name")), (Collection)ImmutableSet.of((Object)dimension.getName()));
            Assert.assertEquals((Collection)formParameters.get((Object)("Dimensions.member." + dimensionIndex + ".Value")), (Collection)ImmutableSet.of((Object)dimension.getValue()));
            ++dimensionIndex;
        }
        Assert.assertEquals((Collection)formParameters.get((Object)"MetricName"), (Collection)ImmutableSet.of((Object)metricName));
        Assert.assertEquals((Collection)formParameters.get((Object)"Namespace"), (Collection)ImmutableSet.of((Object)namespace));
        Assert.assertEquals((Collection)formParameters.get((Object)"Period"), (Collection)ImmutableSet.of((Object)Integer.toString(period)));
        Assert.assertEquals((Collection)formParameters.get((Object)"Statistic"), (Collection)ImmutableSet.of((Object)statistic.toString()));
        Assert.assertEquals((Collection)formParameters.get((Object)"Unit"), (Collection)ImmutableSet.of((Object)unit.toString()));
    }
}

