/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudwatch.xml;

import com.google.common.annotations.Beta;
import java.util.Date;
import javax.inject.Inject;
import org.jclouds.cloudwatch.domain.AlarmHistoryItem;
import org.jclouds.cloudwatch.domain.HistoryItemType;
import org.jclouds.date.DateService;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.util.SaxUtils;
import org.xml.sax.SAXException;

@Beta
public class AlarmHistoryItemHandler
extends ParseSax.HandlerForGeneratedRequestWithResult<AlarmHistoryItem> {
    protected final DateService dateService;
    private StringBuilder currentText = new StringBuilder();
    private String alarmName;
    private String historyData;
    private HistoryItemType historyItemType;
    private String historySummary;
    private Date timestamp;

    @Inject
    public AlarmHistoryItemHandler(DateService dateService) {
        this.dateService = dateService;
    }

    public void endElement(String uri, String name, String qName) throws SAXException {
        if (qName.equals("AlarmName")) {
            this.alarmName = SaxUtils.currentOrNull((StringBuilder)this.currentText);
        } else if (qName.equals("HistoryData")) {
            String rawJson = SaxUtils.currentOrNull((StringBuilder)this.currentText);
            if (rawJson != null) {
                this.historyData = rawJson.trim();
            }
        } else if (qName.equals("HistoryItemType")) {
            this.historyItemType = HistoryItemType.fromValue(SaxUtils.currentOrNull((StringBuilder)this.currentText));
        } else if (qName.equals("HistorySummary")) {
            this.historySummary = SaxUtils.currentOrNull((StringBuilder)this.currentText);
        } else if (qName.equals("Timestamp")) {
            this.timestamp = this.dateService.iso8601DateParse(this.currentText.toString().trim());
        }
        this.currentText = new StringBuilder();
    }

    public void characters(char[] ch, int start, int length) {
        this.currentText.append(ch, start, length);
    }

    public AlarmHistoryItem getResult() {
        AlarmHistoryItem result = new AlarmHistoryItem(this.alarmName, this.historyData, this.historyItemType, this.historySummary, this.timestamp);
        this.alarmName = null;
        this.historyData = null;
        this.historyItemType = null;
        this.historySummary = null;
        this.timestamp = null;
        return result;
    }
}

