/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudwatch.xml;

import com.beust.jcommander.internal.Sets;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.jclouds.cloudwatch.domain.Alarm;
import org.jclouds.cloudwatch.domain.ComparisonOperator;
import org.jclouds.cloudwatch.domain.Dimension;
import org.jclouds.cloudwatch.domain.Statistics;
import org.jclouds.cloudwatch.domain.Unit;
import org.jclouds.cloudwatch.xml.ListAlarmsResponseHandler;
import org.jclouds.collect.IterableWithMarker;
import org.jclouds.collect.IterableWithMarkers;
import org.jclouds.date.DateService;
import org.jclouds.date.internal.SimpleDateFormatDateService;
import org.jclouds.http.functions.BaseHandlerTest;
import org.jclouds.http.functions.ParseSax;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="ListAlarmsResponseHandlerTest")
public class ListAlarmsResponseHandlerTest
extends BaseHandlerTest {
    private final DateService dateService = new SimpleDateFormatDateService();

    public void testParseFullResponse() throws Exception {
        IterableWithMarker metricAlarms = (IterableWithMarker)this.factory.create((ParseSax.HandlerWithResult)this.injector.getInstance(ListAlarmsResponseHandler.class)).parse(((Object)((Object)this)).getClass().getResourceAsStream("/DescribeAlarmsResponse.xml"));
        Assert.assertEquals((String)metricAlarms.toString(), (String)this.expected().toString());
        Assert.assertFalse((boolean)metricAlarms.nextMarker().isPresent());
    }

    public IterableWithMarker<Alarm> expected() {
        Set alarms = Sets.newLinkedHashSet();
        for (int i = 1; i <= 2; ++i) {
            alarms.add(new Alarm(i == 1, (Set)ImmutableSet.of((Object)"TestAction1", (Object)"TestAction2"), "TestAlarmARN" + i, this.dateService.iso8601SecondsDateParse("2013-01-0" + i + "T00:00:00Z"), "This is test alarm " + i + ".", "TestAlarmName" + i, i == 1 ? ComparisonOperator.GREATER_THAN_THRESHOLD : ComparisonOperator.LESS_THAN_THRESHOLD, (Set)ImmutableSet.of((Object)new Dimension("TestDimensionName1", "TestDimensionValue1"), (Object)new Dimension("TestDimensionName2", "TestDimensionValue2")), 60 * i, (Set)ImmutableSet.of((Object)"TestAction1", (Object)"TestAction2"), "TestMetricName" + i, i == 1 ? "AWS/EC2" : "AWS/EBS", (Set)ImmutableSet.of((Object)"TestAction1", (Object)"TestAction2"), 60 * i, "This is state reason " + i + ".", Optional.of((Object)("{\"reason\": \"" + i + "\"}")), this.dateService.iso8601SecondsDateParse("2013-01-0" + i + "T00:00:00Z"), i == 1 ? Alarm.State.OK : Alarm.State.ALARM, i == 1 ? Statistics.SAMPLE_COUNT : Statistics.AVERAGE, Double.valueOf(Integer.toString(i)).doubleValue(), i == 1 ? Optional.of((Object)Unit.SECONDS) : Optional.of((Object)Unit.COUNT_PER_SECOND)));
        }
        return IterableWithMarkers.from((Iterable)alarms);
    }
}

