/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudwatch;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.LinkedHashSet;
import java.util.List;
import org.easymock.EasyMock;
import org.jclouds.cloudwatch.CloudWatch;
import org.jclouds.cloudwatch.CloudWatchApi;
import org.jclouds.cloudwatch.domain.Metric;
import org.jclouds.cloudwatch.domain.MetricDatum;
import org.jclouds.cloudwatch.features.MetricApi;
import org.jclouds.cloudwatch.options.ListMetricsOptions;
import org.jclouds.collect.IterableWithMarker;
import org.jclouds.collect.IterableWithMarkers;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(testName="CloudWatchTest")
public class CloudWatchTest {
    @Test
    public void testSinglePageResult() throws Exception {
        CloudWatchApi api = (CloudWatchApi)EasyMock.createMock(CloudWatchApi.class);
        MetricApi metricApi = (MetricApi)EasyMock.createMock(MetricApi.class);
        ListMetricsOptions options = new ListMetricsOptions();
        IterableWithMarker response = IterableWithMarkers.from((Iterable)ImmutableSet.of((Object)EasyMock.createMock(Metric.class)), null);
        EasyMock.expect((Object)api.getMetricApiForRegion(null)).andReturn((Object)metricApi).atLeastOnce();
        EasyMock.expect((Object)metricApi.list(options)).andReturn((Object)response).once();
        EasyMock.replay((Object[])new Object[]{api, metricApi});
        Assert.assertEquals((int)1, (int)Iterables.size((Iterable)CloudWatch.listMetrics((CloudWatchApi)api, null, (ListMetricsOptions)options)));
    }

    @Test
    public void testMultiPageResult() throws Exception {
        CloudWatchApi api = (CloudWatchApi)EasyMock.createMock(CloudWatchApi.class);
        MetricApi metricApi = (MetricApi)EasyMock.createMock(MetricApi.class);
        ListMetricsOptions options = new ListMetricsOptions();
        IterableWithMarker response1 = IterableWithMarkers.from((Iterable)ImmutableSet.of((Object)EasyMock.createMock(Metric.class)), (Object)"NEXTTOKEN");
        IterableWithMarker response2 = IterableWithMarkers.from((Iterable)ImmutableSet.of((Object)EasyMock.createMock(Metric.class)), null);
        EasyMock.expect((Object)api.getMetricApiForRegion((String)EasyMock.eq((Object)""))).andReturn((Object)metricApi).atLeastOnce();
        EasyMock.expect((Object)metricApi.list((ListMetricsOptions)EasyMock.anyObject(ListMetricsOptions.class))).andReturn((Object)response1).once();
        EasyMock.expect((Object)metricApi.list((ListMetricsOptions)EasyMock.anyObject(ListMetricsOptions.class))).andReturn((Object)response2).once();
        EasyMock.replay((Object[])new Object[]{api, metricApi});
        Assert.assertEquals((int)2, (int)Iterables.size((Iterable)CloudWatch.listMetrics((CloudWatchApi)api, (String)"", (ListMetricsOptions)options)));
    }

    @Test
    public void testPutMetricData() throws Exception {
        CloudWatchApi api = (CloudWatchApi)EasyMock.createMock(CloudWatchApi.class);
        MetricApi metricApi = (MetricApi)EasyMock.createMock(MetricApi.class);
        LinkedHashSet metrics = Sets.newLinkedHashSet();
        String namespace = "JCLOUDS/Test";
        for (int i = 0; i < 11; ++i) {
            metrics.add(MetricDatum.builder().metricName("foo").build());
        }
        EasyMock.expect((Object)api.getMetricApiForRegion((String)EasyMock.eq((Object)""))).andReturn((Object)metricApi).atLeastOnce();
        for (List slice : Iterables.partition((Iterable)metrics, (int)10)) {
            metricApi.putMetricsInNamespace((Iterable)slice, namespace);
        }
        EasyMock.replay((Object[])new Object[]{api, metricApi});
        CloudWatch.putMetricData((CloudWatchApi)api, (String)"", (Iterable)metrics, (String)namespace);
        EasyMock.verify((Object[])new Object[]{metricApi});
    }
}

