/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.chef.functions;

import com.google.common.base.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.functions.ReturnStringIf2xx;

@Singleton
public class ParseErrorFromJsonOrReturnBody
implements Function<HttpResponse, String> {
    Pattern pattern = Pattern.compile(".*\\[\"([^\"]+)\"\\].*");
    private final ReturnStringIf2xx returnStringIf200;

    @Inject
    ParseErrorFromJsonOrReturnBody(ReturnStringIf2xx returnStringIf200) {
        this.returnStringIf200 = returnStringIf200;
    }

    public String apply(HttpResponse response) {
        String content = this.returnStringIf200.apply(response);
        if (content == null) {
            return null;
        }
        return this.parse(content);
    }

    public String parse(String in) {
        Matcher matcher = this.pattern.matcher(in);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return in;
    }
}

