/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.chef.domain;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.gson.annotations.SerializedName;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Set;
import org.jclouds.chef.util.CollectionUtils;
import org.jclouds.domain.JsonBall;
import org.jclouds.javax.annotation.Nullable;

public class Attribute {
    private final String required;
    private final boolean calculated;
    private final Set<String> choice;
    @SerializedName(value="default")
    private final JsonBall defaultValue;
    private final String type;
    private final List<String> recipes;
    @SerializedName(value="display_name")
    private final String displayName;
    private final String description;

    public static Builder builder() {
        return new Builder();
    }

    @ConstructorProperties(value={"required", "calculated", "choice", "default", "type", "recipes", "display_name", "description"})
    protected Attribute(String required, boolean calculated, @Nullable Set<String> choice, JsonBall defaultValue, String type, @Nullable List<String> recipes, String displayName, String description) {
        this.required = required;
        this.calculated = calculated;
        this.choice = CollectionUtils.copyOfOrEmpty(choice);
        this.defaultValue = defaultValue;
        this.type = type;
        this.recipes = CollectionUtils.copyOfOrEmpty(recipes);
        this.displayName = displayName;
        this.description = description;
    }

    public String getRequired() {
        return this.required;
    }

    public boolean isCalculated() {
        return this.calculated;
    }

    public Set<String> getChoice() {
        return this.choice;
    }

    public JsonBall getDefaultValue() {
        return this.defaultValue;
    }

    public String getType() {
        return this.type;
    }

    public List<String> getRecipes() {
        return this.recipes;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getDescription() {
        return this.description;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.calculated ? 1231 : 1237);
        result = 31 * result + (this.choice == null ? 0 : this.choice.hashCode());
        result = 31 * result + (this.defaultValue == null ? 0 : this.defaultValue.hashCode());
        result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
        result = 31 * result + (this.displayName == null ? 0 : this.displayName.hashCode());
        result = 31 * result + (this.recipes == null ? 0 : this.recipes.hashCode());
        result = 31 * result + (this.required == null ? 0 : this.required.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Attribute other = (Attribute)obj;
        if (this.calculated != other.calculated) {
            return false;
        }
        if (this.choice == null ? other.choice != null : !this.choice.equals(other.choice)) {
            return false;
        }
        if (this.defaultValue == null ? other.defaultValue != null : !this.defaultValue.equals((Object)other.defaultValue)) {
            return false;
        }
        if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
            return false;
        }
        if (this.displayName == null ? other.displayName != null : !this.displayName.equals(other.displayName)) {
            return false;
        }
        if (this.recipes == null ? other.recipes != null : !this.recipes.equals(other.recipes)) {
            return false;
        }
        if (this.required == null ? other.required != null : !this.required.equals(other.required)) {
            return false;
        }
        return !(this.type == null ? other.type != null : !this.type.equals(other.type));
    }

    public String toString() {
        return "Attribute [calculated=" + this.calculated + ", choice=" + this.choice + ", defaultValue=" + this.defaultValue + ", description=" + this.description + ", displayName=" + this.displayName + ", recipes=" + this.recipes + ", required=" + this.required + ", type=" + this.type + "]";
    }

    public static class Builder {
        private String required;
        private boolean calculated;
        private ImmutableSet.Builder<String> choice = ImmutableSet.builder();
        private JsonBall defaultValue;
        private String type;
        private ImmutableList.Builder<String> recipes = ImmutableList.builder();
        private String displayName;
        private String description;

        public Builder required(String required) {
            this.required = (String)Preconditions.checkNotNull((Object)required, (Object)"required");
            return this;
        }

        public Builder calculated(boolean calculated) {
            this.calculated = calculated;
            return this;
        }

        public Builder choice(String choice) {
            this.choice.add(Preconditions.checkNotNull((Object)choice, (Object)"choice"));
            return this;
        }

        public Builder choices(Iterable<String> choices) {
            this.choice.addAll((Iterable)Preconditions.checkNotNull(choices, (Object)"choices"));
            return this;
        }

        public Builder defaultValue(JsonBall defaultValue) {
            this.defaultValue = (JsonBall)Preconditions.checkNotNull((Object)defaultValue, (Object)"defaultValue");
            return this;
        }

        public Builder type(String type) {
            this.type = (String)Preconditions.checkNotNull((Object)type, (Object)"type");
            return this;
        }

        public Builder recipe(String recipe) {
            this.recipes.add(Preconditions.checkNotNull((Object)recipe, (Object)"recipe"));
            return this;
        }

        public Builder recipes(Iterable<String> recipes) {
            this.recipes.addAll((Iterable)Preconditions.checkNotNull(recipes, (Object)"recipes"));
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = (String)Preconditions.checkNotNull((Object)displayName, (Object)"displayName");
            return this;
        }

        public Builder description(String description) {
            this.description = (String)Preconditions.checkNotNull((Object)description, (Object)"description");
            return this;
        }

        public Attribute build() {
            return new Attribute(this.required, this.calculated, (Set<String>)this.choice.build(), this.defaultValue, this.type, (List<String>)this.recipes.build(), this.displayName, this.description);
        }
    }
}

