/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.atmos.blobstore.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Multimap;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import org.jclouds.atmos.blobstore.functions.BlobMetadataToObject;
import org.jclouds.atmos.domain.AtmosObject;
import org.jclouds.blobstore.domain.Blob;
import org.jclouds.blobstore.domain.BlobMetadata;
import org.jclouds.io.Payload;

@Singleton
public class BlobToObject
implements Function<Blob, AtmosObject> {
    private final BlobMetadataToObject blobMd2Object;

    @Inject
    BlobToObject(BlobMetadataToObject blobMd2Object) {
        this.blobMd2Object = blobMd2Object;
    }

    public AtmosObject apply(Blob from) {
        if (from == null) {
            return null;
        }
        AtmosObject object = this.blobMd2Object.apply((BlobMetadata)from.getMetadata());
        object.setPayload((Payload)Preconditions.checkNotNull((Object)from.getPayload(), (Object)("payload: " + from)));
        object.setAllHeaders((Multimap<String, String>)from.getAllHeaders());
        return object;
    }
}

