/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jspf.tester;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import org.apache.james.jspf.tester.ResponseGenerator;

public final class UDPListener
implements Runnable {
    private final InetAddress addr;
    private final int port;
    private ResponseGenerator responseGenerator;

    UDPListener(InetAddress addr, int port, ResponseGenerator rg) {
        this.addr = addr;
        this.port = port;
        this.responseGenerator = rg;
    }

    public void run() {
        try {
            DatagramSocket sock = new DatagramSocket(this.port, this.addr);
            int udpLength = 512;
            byte[] in = new byte[512];
            DatagramPacket indp = new DatagramPacket(in, in.length);
            while (true) {
                indp.setLength(in.length);
                try {
                    sock.receive(indp);
                }
                catch (InterruptedIOException e) {
                    continue;
                }
                byte[] local = new byte[indp.getLength()];
                System.arraycopy(in, 0, local, 0, indp.getLength());
                UDPResponder runnable = new UDPResponder(sock, indp.getAddress(), indp.getPort(), local, this.responseGenerator);
                new Thread(runnable).start();
            }
        }
        catch (IOException e) {
            System.out.println("UDPListener(" + this.addr.getHostAddress() + "#" + this.port + "): " + e);
            return;
        }
    }

    private static final class UDPResponder
    implements Runnable {
        private ResponseGenerator responseGenerator;
        private DatagramSocket sock;
        private InetAddress addr;
        private int port;
        private byte[] in;

        private UDPResponder(DatagramSocket sock, InetAddress addr, int port, byte[] in, ResponseGenerator rg) {
            this.sock = sock;
            this.addr = addr;
            this.port = port;
            this.in = in;
            this.responseGenerator = rg;
        }

        public void run() {
            try {
                DatagramPacket outdp = null;
                byte[] response = this.responseGenerator.generateReply(this.in, this.in.length);
                if (response == null) {
                    return;
                }
                if (outdp == null) {
                    outdp = new DatagramPacket(response, response.length, this.addr, this.port);
                } else {
                    outdp.setData(response);
                    outdp.setLength(response.length);
                    outdp.setAddress(this.addr);
                    outdp.setPort(this.port);
                }
                this.sock.send(outdp);
            }
            catch (IOException e) {
                System.out.println("UDPResponder(" + this.addr.getHostAddress() + "#" + this.port + "): " + e);
            }
        }
    }
}

