/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailrepository.file;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.DefaultConfigurationBuilder;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.james.core.MimeMessageCopyOnWriteProxy;
import org.apache.james.core.MimeMessageSource;
import org.apache.james.core.MimeMessageWrapper;
import org.apache.james.mailrepository.file.MimeMessageStreamRepositorySource;
import org.apache.james.mailrepository.lib.AbstractMailRepository;
import org.apache.james.mailstore.api.MailStore;
import org.apache.james.repository.ObjectRepository;
import org.apache.james.repository.StreamRepository;
import org.apache.mailet.Mail;

public class FileMailRepository
extends AbstractMailRepository {
    private StreamRepository streamRepository;
    private ObjectRepository objectRepository;
    private String destination;
    private Set keys;
    private boolean fifo;
    private boolean cacheKeys;

    protected void doConfigure(HierarchicalConfiguration config) throws ConfigurationException {
        String checkType;
        super.doConfigure(config);
        this.destination = config.getString("[@destinationURL]");
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)("AvalonMailRepository.destinationURL: " + this.destination));
        }
        if (!(checkType = config.getString("[@type]")).equals("MAIL") && !checkType.equals("SPOOL")) {
            String exceptionString = "Attempt to configure AvalonMailRepository as " + checkType;
            if (this.getLogger().isWarnEnabled()) {
                this.getLogger().warn((Object)exceptionString);
            }
            throw new ConfigurationException(exceptionString);
        }
        this.fifo = config.getBoolean("[@FIFO]", false);
        this.cacheKeys = config.getBoolean("[@CACHEKEYS]", true);
    }

    @PostConstruct
    public void init() throws Exception {
        try {
            this.objectRepository = (ObjectRepository)this.selectRepository(this.store, "OBJECT");
            this.streamRepository = (StreamRepository)this.selectRepository(this.store, "STREAM");
            if (this.cacheKeys) {
                this.keys = Collections.synchronizedSet(new HashSet());
            }
            HashSet streamKeys = new HashSet();
            Iterator i = this.streamRepository.list();
            while (i.hasNext()) {
                streamKeys.add(i.next());
            }
            HashSet objectKeys = new HashSet();
            Iterator i2 = this.objectRepository.list();
            while (i2.hasNext()) {
                objectKeys.add(i2.next());
            }
            Collection strandedStreams = (Collection)streamKeys.clone();
            strandedStreams.removeAll(objectKeys);
            for (String key : strandedStreams) {
                this.remove(key);
            }
            Collection strandedObjects = (Collection)objectKeys.clone();
            strandedObjects.removeAll(streamKeys);
            for (String key : strandedObjects) {
                this.remove(key);
            }
            if (this.keys != null) {
                this.keys.clear();
                Iterator i3 = this.objectRepository.list();
                while (i3.hasNext()) {
                    this.keys.add(i3.next());
                }
            }
            if (this.getLogger().isDebugEnabled()) {
                StringBuffer logBuffer = new StringBuffer(128).append(((Object)((Object)this)).getClass().getName()).append(" created in ").append(this.destination);
                this.getLogger().debug((Object)logBuffer.toString());
            }
        }
        catch (Exception e) {
            String message = "Failed to retrieve Store component:" + e.getMessage();
            this.getLogger().error((Object)message, (Throwable)e);
            throw e;
        }
    }

    private Object selectRepository(MailStore store, String type) throws Exception {
        DefaultConfigurationBuilder objectConfiguration = new DefaultConfigurationBuilder();
        objectConfiguration.addProperty("[@destinationURL]", (Object)this.destination);
        objectConfiguration.addProperty("[@type]", (Object)type);
        objectConfiguration.addProperty("[@model]", (Object)"SYNCHRONOUS");
        return store.select((HierarchicalConfiguration)objectConfiguration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void internalStore(Mail mc) throws MessagingException, IOException {
        String key = mc.getName();
        if (this.keys != null && !this.keys.contains(key)) {
            this.keys.add(key);
        }
        boolean saveStream = true;
        MimeMessage message = mc.getMessage();
        if (message instanceof MimeMessageCopyOnWriteProxy) {
            MimeMessageCopyOnWriteProxy messageCow = (MimeMessageCopyOnWriteProxy)message;
            message = messageCow.getWrappedMessage();
        }
        if (message instanceof MimeMessageWrapper) {
            MimeMessageWrapper wrapper = (MimeMessageWrapper)message;
            StringBuffer destinationBuffer = new StringBuffer(128).append(this.destination).append("/").append(mc.getName());
            if (destinationBuffer.toString().equals(wrapper.getSourceId()) && !wrapper.isModified()) {
                saveStream = false;
            }
        }
        if (saveStream) {
            OutputStream out = null;
            try {
                out = this.streamRepository.put(key);
                mc.getMessage().writeTo(out);
            }
            finally {
                if (out != null) {
                    out.close();
                }
            }
        }
        this.objectRepository.put(key, (Object)mc);
    }

    public Mail retrieve(String key) throws MessagingException {
        try {
            Mail mc = null;
            try {
                mc = (Mail)this.objectRepository.get(key);
            }
            catch (RuntimeException re) {
                StringBuffer exceptionBuffer = new StringBuffer(128);
                if (re.getCause() instanceof Error) {
                    exceptionBuffer.append("Error when retrieving mail, not deleting: ").append(re.toString());
                } else {
                    exceptionBuffer.append("Exception retrieving mail: ").append(re.toString()).append(", so we're deleting it.");
                    this.remove(key);
                }
                String errorMessage = exceptionBuffer.toString();
                this.getLogger().warn((Object)errorMessage);
                this.getLogger().debug((Object)errorMessage, (Throwable)re);
                return null;
            }
            MimeMessageStreamRepositorySource source = new MimeMessageStreamRepositorySource(this.streamRepository, this.destination, key);
            mc.setMessage((MimeMessage)new MimeMessageCopyOnWriteProxy((MimeMessageSource)source));
            return mc;
        }
        catch (Exception me) {
            this.getLogger().error((Object)("Exception retrieving mail: " + me));
            throw new MessagingException("Exception while retrieving mail: " + me.getMessage(), me);
        }
    }

    protected void internalRemove(String key) throws MessagingException {
        if (this.keys != null) {
            this.keys.remove(key);
        }
        this.streamRepository.remove(key);
        this.objectRepository.remove(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator list() {
        ArrayList clone;
        if (this.keys != null) {
            Set set = this.keys;
            synchronized (set) {
                clone = new ArrayList(this.keys);
            }
        } else {
            clone = new ArrayList();
            Iterator i = this.objectRepository.list();
            while (i.hasNext()) {
                clone.add(i.next());
            }
        }
        if (this.fifo) {
            Collections.sort(clone);
        }
        return clone.iterator();
    }
}

