/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.domainlist.jdbc;

import java.io.InputStream;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.james.domainlist.lib.AbstractDomainList;
import org.apache.james.lifecycle.Configurable;
import org.apache.james.services.FileSystem;
import org.apache.james.util.sql.JDBCUtil;
import org.apache.james.util.sql.SqlResources;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public class JDBCDomainList
extends AbstractDomainList
implements Configurable {
    private DataSource dataSource;
    private FileSystem fileSystem;
    private String tableName = null;
    protected SqlResources sqlQueries;
    private String sqlFileName;
    protected String datasourceName;
    private HierarchicalConfiguration configuration;
    private final JDBCUtil theJDBCUtil = new JDBCUtil(){

        protected void delegatedLog(String logString) {
            JDBCDomainList.this.getLogger().debug((Object)("JDBCVirtualUserTable: " + logString));
        }
    };

    public void configure(HierarchicalConfiguration configuration) throws ConfigurationException {
        this.configuration = configuration;
    }

    @Resource(name="datasource")
    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    @Resource(name="filesystem")
    public void setFileSystem(FileSystem fileSystem) {
        this.fileSystem = fileSystem;
    }

    protected void configure() throws ConfigurationException {
        String destination = this.configuration.getString("repositoryPath", null);
        if (destination == null) {
            throw new ConfigurationException("RepositoryPath must configured");
        }
        if (!destination.endsWith("/")) {
            destination = destination + "/";
        }
        ArrayList<String> urlParams = new ArrayList<String>();
        int start = 5;
        int end = destination.indexOf(47, start);
        while (end > -1) {
            urlParams.add(destination.substring(start, end));
            start = end + 1;
            end = destination.indexOf(47, start);
        }
        if (urlParams.size() != 2) {
            StringBuffer exceptionBuffer = new StringBuffer(256).append("Malformed destinationURL - Must be of the format '").append("db://<data-source>/<table>'.  Was passed ").append(this.configuration.getString("repositoryPath"));
            throw new ConfigurationException(exceptionBuffer.toString());
        }
        this.tableName = (String)urlParams.get(1);
        if (this.getLogger().isDebugEnabled()) {
            StringBuffer logBuffer = new StringBuffer(128).append("Parsed URL: table = '").append(this.tableName).append("'");
            this.getLogger().debug((Object)logBuffer.toString());
        }
        this.sqlFileName = this.configuration.getString("sqlFile", "file://conf/sqlResources.xml");
        this.setAutoDetect(this.configuration.getBoolean("autodetect", true));
        this.setAutoDetectIP(this.configuration.getBoolean("autodetectIP", true));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostConstruct
    public void init() throws Exception {
        this.configure();
        StringBuffer logBuffer = null;
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)(((Object)((Object)this)).getClass().getName() + ".initialize()"));
        }
        Connection conn = this.dataSource.getConnection();
        PreparedStatement createStatement = null;
        try {
            InputStream sqlFile = null;
            try {
                sqlFile = this.fileSystem.getResource(this.sqlFileName);
                this.sqlFileName = null;
            }
            catch (Exception e) {
                this.getLogger().error((Object)e.getMessage(), (Throwable)e);
                throw e;
            }
            if (this.getLogger().isDebugEnabled()) {
                logBuffer = new StringBuffer(128).append("Reading SQL resources from file: ").append(this.sqlFileName).append(", section ").append(((Object)((Object)this)).getClass().getName()).append(".");
                this.getLogger().debug((Object)logBuffer.toString());
            }
            HashMap<String, String> sqlParameters = new HashMap<String, String>();
            if (this.tableName != null) {
                sqlParameters.put("table", this.tableName);
            }
            this.sqlQueries = new SqlResources();
            this.sqlQueries.init(sqlFile, ((Object)((Object)this)).getClass().getName(), conn, sqlParameters);
            DatabaseMetaData dbMetaData = conn.getMetaData();
            if (!this.theJDBCUtil.tableExists(dbMetaData, this.tableName)) {
                createStatement = conn.prepareStatement(this.sqlQueries.getSqlString("createTable", true));
                createStatement.execute();
                if (this.getLogger().isInfoEnabled()) {
                    logBuffer = new StringBuffer(64).append("JdbcVirtalUserTable: Created table '").append(this.tableName).append("'.");
                    this.getLogger().info((Object)logBuffer.toString());
                }
            }
        }
        finally {
            this.theJDBCUtil.closeJDBCStatement(createStatement);
            this.theJDBCUtil.closeJDBCConnection(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<String> getDomainListInternal() {
        ArrayList<String> domains = new ArrayList<String>();
        Connection conn = null;
        PreparedStatement mappingStmt = null;
        try {
            conn = this.dataSource.getConnection();
            mappingStmt = conn.prepareStatement(this.sqlQueries.getSqlString("selectDomains", true));
            ResultSet mappingRS = null;
            try {
                mappingRS = mappingStmt.executeQuery();
                while (mappingRS.next()) {
                    String domain = mappingRS.getString(1).toLowerCase();
                    if (domains.contains(domains)) continue;
                    domains.add(domain);
                }
            }
            finally {
                this.theJDBCUtil.closeJDBCResultSet(mappingRS);
            }
        }
        catch (SQLException sqle) {
            try {
                this.getLogger().error((Object)"Error accessing database", (Throwable)sqle);
            }
            catch (Throwable throwable) {
                this.theJDBCUtil.closeJDBCStatement(mappingStmt);
                this.theJDBCUtil.closeJDBCConnection(conn);
                throw throwable;
            }
            this.theJDBCUtil.closeJDBCStatement((Statement)mappingStmt);
            this.theJDBCUtil.closeJDBCConnection(conn);
        }
        this.theJDBCUtil.closeJDBCStatement((Statement)mappingStmt);
        this.theJDBCUtil.closeJDBCConnection(conn);
        if (domains.size() == 0) {
            return null;
        }
        return domains;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public boolean containsDomain(String domain) {
        PreparedStatement mappingStmt;
        Connection conn;
        block8: {
            ResultSet mappingRS;
            block7: {
                conn = null;
                mappingStmt = null;
                conn = this.dataSource.getConnection();
                mappingStmt = conn.prepareStatement(this.sqlQueries.getSqlString("selectDomain", true));
                mappingRS = null;
                mappingStmt.setString(1, domain);
                mappingRS = mappingStmt.executeQuery();
                if (!mappingRS.next()) break block7;
                boolean bl = true;
                this.theJDBCUtil.closeJDBCResultSet(mappingRS);
                this.theJDBCUtil.closeJDBCStatement((Statement)mappingStmt);
                this.theJDBCUtil.closeJDBCConnection(conn);
                return bl;
            }
            try {
                this.theJDBCUtil.closeJDBCResultSet(mappingRS);
                break block8;
                {
                    catch (Throwable throwable) {
                        this.theJDBCUtil.closeJDBCResultSet(mappingRS);
                        throw throwable;
                    }
                }
            }
            catch (SQLException sqle) {
                try {
                    this.getLogger().error((Object)"Error accessing database", (Throwable)sqle);
                }
                catch (Throwable throwable) {
                    this.theJDBCUtil.closeJDBCStatement(mappingStmt);
                    this.theJDBCUtil.closeJDBCConnection(conn);
                    throw throwable;
                }
                this.theJDBCUtil.closeJDBCStatement((Statement)mappingStmt);
                this.theJDBCUtil.closeJDBCConnection(conn);
            }
        }
        this.theJDBCUtil.closeJDBCStatement((Statement)mappingStmt);
        this.theJDBCUtil.closeJDBCConnection(conn);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected boolean addDomainInternal(String domain) {
        Connection conn = null;
        PreparedStatement mappingStmt = null;
        conn = this.dataSource.getConnection();
        mappingStmt = conn.prepareStatement(this.sqlQueries.getSqlString("addDomain", true));
        ResultSet mappingRS = null;
        mappingStmt.setString(1, domain);
        mappingStmt.execute();
        boolean bl = true;
        this.theJDBCUtil.closeJDBCResultSet(mappingRS);
        this.theJDBCUtil.closeJDBCStatement((Statement)mappingStmt);
        this.theJDBCUtil.closeJDBCConnection(conn);
        return bl;
        {
            catch (Throwable throwable) {
                try {
                    try {
                        this.theJDBCUtil.closeJDBCResultSet(mappingRS);
                        throw throwable;
                    }
                    catch (SQLException sqle) {
                        this.getLogger().error((Object)"Error accessing database", (Throwable)sqle);
                        this.theJDBCUtil.closeJDBCStatement(mappingStmt);
                        this.theJDBCUtil.closeJDBCConnection(conn);
                    }
                }
                catch (Throwable throwable2) {
                    this.theJDBCUtil.closeJDBCStatement(mappingStmt);
                    this.theJDBCUtil.closeJDBCConnection(conn);
                    throw throwable2;
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected boolean removeDomainInternal(String domain) {
        PreparedStatement mappingStmt;
        Connection conn;
        block8: {
            ResultSet mappingRS;
            block7: {
                conn = null;
                mappingStmt = null;
                conn = this.dataSource.getConnection();
                mappingStmt = conn.prepareStatement(this.sqlQueries.getSqlString("removeDomain", true));
                mappingRS = null;
                mappingStmt.setString(1, domain);
                if (mappingStmt.executeUpdate() <= 0) break block7;
                boolean bl = true;
                this.theJDBCUtil.closeJDBCResultSet(mappingRS);
                this.theJDBCUtil.closeJDBCStatement((Statement)mappingStmt);
                this.theJDBCUtil.closeJDBCConnection(conn);
                return bl;
            }
            try {
                this.theJDBCUtil.closeJDBCResultSet(mappingRS);
                break block8;
                {
                    catch (Throwable throwable) {
                        this.theJDBCUtil.closeJDBCResultSet(mappingRS);
                        throw throwable;
                    }
                }
            }
            catch (SQLException sqle) {
                try {
                    this.getLogger().error((Object)"Error accessing database", (Throwable)sqle);
                }
                catch (Throwable throwable) {
                    this.theJDBCUtil.closeJDBCStatement(mappingStmt);
                    this.theJDBCUtil.closeJDBCConnection(conn);
                    throw throwable;
                }
                this.theJDBCUtil.closeJDBCStatement((Statement)mappingStmt);
                this.theJDBCUtil.closeJDBCConnection(conn);
            }
        }
        this.theJDBCUtil.closeJDBCStatement((Statement)mappingStmt);
        this.theJDBCUtil.closeJDBCConnection(conn);
        return false;
    }
}

