/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.domainlist.jdbc;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.DataSource;
import junit.framework.TestCase;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.DefaultConfigurationBuilder;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.impl.SimpleLog;
import org.apache.james.dnsservice.api.DNSService;
import org.apache.james.dnsservice.api.MockDNSService;
import org.apache.james.domainlist.jdbc.JDBCDomainList;
import org.apache.james.services.FileSystem;
import org.apache.james.services.MockFileSystem;
import org.apache.james.util.TestUtil;
import org.apache.james.util.sql.JDBCUtil;

public class JDBCDomainListTest
extends TestCase {
    private String repos = "db://maildb/";
    private String table = "costumTable";
    private DataSource data;
    private final JDBCUtil theJDBCUtil = new JDBCUtil(){

        protected void delegatedLog(String logString) {
        }
    };

    public void setUp() throws Exception {
        this.data = TestUtil.getDataSource();
        this.sqlQuery("create table " + this.table + " (domain VARCHAR (255))");
    }

    public void tearDown() throws Exception {
        this.sqlQuery("drop table " + this.table);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private boolean sqlQuery(String query) {
        PreparedStatement mappingStmt;
        Connection conn;
        block8: {
            ResultSet mappingRS;
            block7: {
                conn = null;
                mappingStmt = null;
                conn = this.data.getConnection();
                mappingStmt = conn.prepareStatement(query);
                mappingRS = null;
                if (mappingStmt.executeUpdate() <= 0) break block7;
                boolean bl = true;
                this.theJDBCUtil.closeJDBCResultSet(mappingRS);
                this.theJDBCUtil.closeJDBCStatement((Statement)mappingStmt);
                this.theJDBCUtil.closeJDBCConnection(conn);
                return bl;
            }
            try {
                this.theJDBCUtil.closeJDBCResultSet(mappingRS);
                break block8;
                {
                    catch (Throwable throwable) {
                        this.theJDBCUtil.closeJDBCResultSet(mappingRS);
                        throw throwable;
                    }
                }
            }
            catch (SQLException e) {
                try {
                    System.err.println(e.getMessage());
                }
                catch (Throwable throwable) {
                    this.theJDBCUtil.closeJDBCStatement(mappingStmt);
                    this.theJDBCUtil.closeJDBCConnection(conn);
                    throw throwable;
                }
                this.theJDBCUtil.closeJDBCStatement((Statement)mappingStmt);
                this.theJDBCUtil.closeJDBCConnection(conn);
            }
        }
        this.theJDBCUtil.closeJDBCStatement((Statement)mappingStmt);
        this.theJDBCUtil.closeJDBCConnection(conn);
        return false;
    }

    private HierarchicalConfiguration setUpConfiguration(String url) {
        DefaultConfigurationBuilder configuration = new DefaultConfigurationBuilder();
        configuration.addProperty("repositoryPath", (Object)url);
        configuration.addProperty("sqlFile", (Object)"file://conf/sqlResources.xml");
        return configuration;
    }

    private DNSService setUpDNSServer(final String hostName) {
        MockDNSService dns = new MockDNSService(){

            public String getHostName(InetAddress inet) {
                return hostName;
            }

            public InetAddress[] getAllByName(String name) throws UnknownHostException {
                return new InetAddress[]{InetAddress.getByName("127.0.0.1")};
            }

            public InetAddress getLocalHost() throws UnknownHostException {
                return InetAddress.getLocalHost();
            }
        };
        return dns;
    }

    public void testAddRemoveGetDomains() throws Exception {
        JDBCDomainList dom = new JDBCDomainList();
        dom.setDNSService(this.setUpDNSServer("localhost"));
        dom.setFileSystem((FileSystem)new MockFileSystem());
        dom.setDataSource(this.data);
        dom.setLog((Log)new SimpleLog("MockLog"));
        dom.configure(this.setUpConfiguration(this.repos + this.table));
        dom.init();
        dom.addDomain("domain1.");
        JDBCDomainListTest.assertEquals((String)"two domain found", (int)dom.getDomains().length, (int)2);
        dom.removeDomain("domain1.");
        JDBCDomainListTest.assertNull((String)"two domain found", (Object)dom.getDomains());
    }

    public void testThrowConfigurationException() throws Exception {
        boolean exception = false;
        JDBCDomainList dom = new JDBCDomainList();
        dom.setDNSService(this.setUpDNSServer("localhost"));
        dom.setFileSystem((FileSystem)new MockFileSystem());
        dom.setDataSource(this.data);
        dom.setLog((Log)new SimpleLog("MockLog"));
        dom.configure((HierarchicalConfiguration)new DefaultConfigurationBuilder());
        try {
            dom.init();
        }
        catch (ConfigurationException e) {
            exception = true;
        }
        JDBCDomainListTest.assertTrue((String)"Exception thrown", (boolean)exception);
    }
}

