/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.user.ldap;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.naming.Context;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapContext;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.configuration.SubnodeConfiguration;
import org.apache.james.lifecycle.api.Configurable;
import org.apache.james.lifecycle.api.LogEnabled;
import org.apache.james.user.api.UsersRepository;
import org.apache.james.user.api.UsersRepositoryException;
import org.apache.james.user.api.model.User;
import org.apache.james.user.ldap.ReadOnlyLDAPGroupRestriction;
import org.apache.james.user.ldap.ReadOnlyLDAPUser;
import org.apache.james.util.retry.DoublingRetrySchedule;
import org.apache.james.util.retry.api.RetrySchedule;
import org.apache.james.util.retry.naming.ldap.RetryingLdapContext;
import org.slf4j.Logger;

public class ReadOnlyUsersLDAPRepository
implements UsersRepository,
Configurable,
LogEnabled {
    private static final String INITIAL_CONTEXT_FACTORY = "com.sun.jndi.ldap.LdapCtxFactory";
    private static final String PROPERTY_NAME_CONNECTION_POOL = "com.sun.jndi.ldap.connect.pool";
    private static final String PROPERTY_NAME_CONNECT_TIMEOUT = "com.sun.jndi.ldap.connect.timeout";
    private static final String PROPERTY_NAME_READ_TIMEOUT = "com.sun.jndi.ldap.read.timeout";
    private String ldapHost;
    private String userIdAttribute;
    private String userObjectClass;
    private String userBase;
    private String principal;
    private String credentials;
    private ReadOnlyLDAPGroupRestriction restriction;
    private LdapContext ldapContext;
    private boolean useConnectionPool = true;
    private int connectionTimeout = -1;
    private int readTimeout = -1;
    private RetrySchedule schedule = null;
    private int maxRetries = 0;
    private Logger log;

    public void configure(HierarchicalConfiguration configuration) throws ConfigurationException {
        this.ldapHost = configuration.getString("[@ldapHost]", "");
        this.principal = configuration.getString("[@principal]", "");
        this.credentials = configuration.getString("[@credentials]", "");
        this.userBase = configuration.getString("[@userBase]");
        this.userIdAttribute = configuration.getString("[@userIdAttribute]");
        this.userObjectClass = configuration.getString("[@userObjectClass]");
        this.useConnectionPool = configuration.getBoolean("[@useConnectionPool]", true);
        this.connectionTimeout = configuration.getInt("[@connectionTimeout]", -1);
        this.readTimeout = configuration.getInt("[@readTimeout]", -1);
        this.maxRetries = configuration.getInt("[@maxRetries]", 1);
        long retryStartInterval = configuration.getLong("[@retryStartInterval]", 0L);
        long retryMaxInterval = configuration.getLong("[@retryMaxInterval]", 60L);
        int scale = configuration.getInt("[@retryIntervalScale]", 1000);
        this.schedule = new DoublingRetrySchedule(retryStartInterval, retryMaxInterval, scale);
        SubnodeConfiguration restrictionConfig = null;
        if (configuration.containsKey("restriction[@memberAttribute]")) {
            restrictionConfig = configuration.configurationAt("restriction");
        }
        this.restriction = new ReadOnlyLDAPGroupRestriction((HierarchicalConfiguration)restrictionConfig);
    }

    @PostConstruct
    public void init() throws Exception {
        if (this.log.isDebugEnabled()) {
            this.log.debug(new StringBuilder(128).append(this.getClass().getName()).append(".init()").append('\n').append("LDAP host: ").append(this.ldapHost).append('\n').append("User baseDN: ").append(this.userBase).append('\n').append("userIdAttribute: ").append(this.userIdAttribute).append('\n').append("Group restriction: ").append(this.restriction).append('\n').append("UseConnectionPool: ").append(this.useConnectionPool).append('\n').append("connectionTimeout: ").append(this.connectionTimeout).append('\n').append("readTimeout: ").append(this.readTimeout).append('\n').append("retrySchedule: ").append(this.schedule).append('\n').append("maxRetries: ").append(this.maxRetries).append('\n').toString());
        }
        this.updateLdapContext();
    }

    protected LdapContext getLdapContext() throws NamingException {
        if (null == this.ldapContext) {
            this.updateLdapContext();
        }
        return this.ldapContext;
    }

    protected void updateLdapContext() throws NamingException {
        this.ldapContext = this.computeLdapContext();
    }

    protected LdapContext computeLdapContext() throws NamingException {
        return new RetryingLdapContext(this.schedule, this.maxRetries, this.log){

            public Context newDelegate() throws NamingException {
                return new InitialLdapContext(ReadOnlyUsersLDAPRepository.this.getContextEnvironment(), null);
            }
        };
    }

    protected Properties getContextEnvironment() {
        Properties props = new Properties();
        props.put("java.naming.factory.initial", INITIAL_CONTEXT_FACTORY);
        props.put("java.naming.provider.url", null == this.ldapHost ? "" : this.ldapHost);
        if (null == this.credentials || this.credentials.isEmpty()) {
            props.put("java.naming.security.authentication", "none");
        } else {
            props.put("java.naming.security.authentication", "simple");
            props.put("java.naming.security.principal", null == this.principal ? "" : this.principal);
            props.put("java.naming.security.credentials", this.credentials);
        }
        props.put(PROPERTY_NAME_CONNECTION_POOL, Boolean.toString(this.useConnectionPool));
        if (this.connectionTimeout > -1) {
            props.put(PROPERTY_NAME_CONNECT_TIMEOUT, Integer.toString(this.connectionTimeout));
        }
        if (this.readTimeout > -1) {
            props.put(PROPERTY_NAME_READ_TIMEOUT, Integer.toString(this.readTimeout));
        }
        return props;
    }

    private boolean userInGroupsMembershipList(String userDN, Map<String, Collection<String>> groupMembershipList) {
        boolean result = false;
        Collection<Collection<String>> memberLists = groupMembershipList.values();
        Iterator<Collection<String>> memberListsIterator = memberLists.iterator();
        while (memberListsIterator.hasNext() && !result) {
            Collection<String> groupMembers = memberListsIterator.next();
            result = groupMembers.contains(userDN);
        }
        return result;
    }

    private Set<String> getAllUsersFromLDAP() throws NamingException {
        HashSet<String> result = new HashSet<String>();
        SearchControls sc = new SearchControls();
        sc.setSearchScope(2);
        sc.setReturningAttributes(new String[]{"distinguishedName"});
        NamingEnumeration<SearchResult> sr = this.ldapContext.search(this.userBase, "(objectClass=" + this.userObjectClass + ")", sc);
        while (sr.hasMore()) {
            SearchResult r = sr.next();
            result.add(r.getNameInNamespace());
        }
        return result;
    }

    private Collection<ReadOnlyLDAPUser> buildUserCollection(Collection<String> userDNs) throws NamingException {
        ArrayList<ReadOnlyLDAPUser> results = new ArrayList<ReadOnlyLDAPUser>();
        Iterator<String> userDNIterator = userDNs.iterator();
        while (userDNIterator.hasNext()) {
            ReadOnlyLDAPUser user = this.buildUser(userDNIterator.next());
            results.add(user);
        }
        return results;
    }

    private ReadOnlyLDAPUser buildUser(String userDN) throws NamingException {
        SearchControls sc = new SearchControls();
        sc.setSearchScope(0);
        sc.setReturningAttributes(new String[]{this.userIdAttribute});
        sc.setCountLimit(1L);
        StringBuilder builderFilter = new StringBuilder("(objectClass=");
        builderFilter.append(this.userObjectClass);
        builderFilter.append(")");
        NamingEnumeration<SearchResult> sr = this.ldapContext.search(userDN, builderFilter.toString(), sc);
        if (!sr.hasMore()) {
            return null;
        }
        Attributes userAttributes = sr.next().getAttributes();
        Attribute userName = userAttributes.get(this.userIdAttribute);
        if (!this.restriction.isActivated() || this.userInGroupsMembershipList(userDN, this.restriction.getGroupMembershipLists(this.ldapContext))) {
            return new ReadOnlyLDAPUser(userName.get().toString(), userDN, this.ldapContext);
        }
        return null;
    }

    public boolean contains(String name) throws UsersRepositoryException {
        return this.getUserByName(name) != null;
    }

    public boolean containsCaseInsensitive(String name) throws UsersRepositoryException {
        return this.getUserByNameCaseInsensitive(name) != null;
    }

    public int countUsers() throws UsersRepositoryException {
        try {
            return this.getValidUsers().size();
        }
        catch (NamingException e) {
            this.log.error("Unable to retrieve user count from ldap", (Throwable)e);
            throw new UsersRepositoryException("Unable to retrieve user count from ldap", (Throwable)e);
        }
    }

    public String getRealName(String name) throws UsersRepositoryException {
        User u = this.getUserByNameCaseInsensitive(name);
        if (u != null) {
            return u.getUserName();
        }
        return null;
    }

    public User getUserByName(String name) throws UsersRepositoryException {
        try {
            return this.buildUser(this.userIdAttribute + "=" + name + "," + this.userBase);
        }
        catch (NamingException e) {
            this.log.error("Unable to retrieve user from ldap", (Throwable)e);
            throw new UsersRepositoryException("Unable to retrieve user from ldap", (Throwable)e);
        }
    }

    public User getUserByNameCaseInsensitive(String name) throws UsersRepositoryException {
        try {
            for (ReadOnlyLDAPUser u : this.buildUserCollection(this.getValidUsers())) {
                if (!u.getUserName().equalsIgnoreCase(name)) continue;
                return u;
            }
        }
        catch (NamingException e) {
            this.log.error("Unable to retrieve user from ldap", (Throwable)e);
            throw new UsersRepositoryException("Unable to retrieve user from ldap", (Throwable)e);
        }
        return null;
    }

    public Iterator<String> list() throws UsersRepositoryException {
        ArrayList<String> result = new ArrayList<String>();
        try {
            Iterator<ReadOnlyLDAPUser> userIt = this.buildUserCollection(this.getValidUsers()).iterator();
            while (userIt.hasNext()) {
                result.add(userIt.next().getUserName());
            }
        }
        catch (NamingException namingException) {
            throw new UsersRepositoryException("Unable to retrieve users list from LDAP due to unknown naming error.", (Throwable)namingException);
        }
        return result.iterator();
    }

    private Collection<String> getValidUsers() throws NamingException {
        Collection<String> validUserDNs;
        Set<String> userDNs = this.getAllUsersFromLDAP();
        if (this.restriction.isActivated()) {
            Map<String, Collection<String>> groupMembershipList = this.restriction.getGroupMembershipLists(this.ldapContext);
            validUserDNs = new ArrayList();
            for (String userDN : userDNs) {
                if (!this.userInGroupsMembershipList(userDN, groupMembershipList)) continue;
                validUserDNs.add(userDN);
            }
        } else {
            validUserDNs = userDNs;
        }
        return validUserDNs;
    }

    public void removeUser(String name) throws UsersRepositoryException {
        this.log.warn("This user-repository is read-only. Modifications are not permitted.");
        throw new UsersRepositoryException("This user-repository is read-only. Modifications are not permitted.");
    }

    public boolean test(String name, String password) throws UsersRepositoryException {
        User u = this.getUserByName(name);
        if (u != null) {
            return u.verifyPassword(password);
        }
        return false;
    }

    public void addUser(String username, String password) throws UsersRepositoryException {
        this.log.error("This user-repository is read-only. Modifications are not permitted.");
        throw new UsersRepositoryException("This user-repository is read-only. Modifications are not permitted.");
    }

    public void updateUser(User user) throws UsersRepositoryException {
        this.log.error("This user-repository is read-only. Modifications are not permitted.");
        throw new UsersRepositoryException("This user-repository is read-only. Modifications are not permitted.");
    }

    public void setLog(Logger log) {
        this.log = log;
    }

    public boolean supportVirtualHosting() throws UsersRepositoryException {
        return false;
    }
}

