/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.managesieve.jsieve;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.apache.james.managesieve.api.SieveParser;
import org.apache.james.managesieve.api.SyntaxException;
import org.apache.jsieve.ConfigurationManager;
import org.apache.jsieve.SieveFactory;
import org.apache.jsieve.parser.generated.ParseException;

public class Parser
implements SieveParser {
    private static final List<String> EMPTY_WARNINGS = new ArrayList<String>(0);
    private SieveFactory _sieveFactory = null;

    public Parser() {
    }

    public Parser(ConfigurationManager manager) {
        this();
        this.setConfigurationManager(manager);
    }

    @Resource(name="jsieveconfigurationmanager")
    public void setConfigurationManager(ConfigurationManager manager) {
        this._sieveFactory = manager.build();
    }

    public List<String> getExtensions() {
        return this._sieveFactory.getExtensions();
    }

    public List<String> parse(String content) throws SyntaxException {
        try {
            this._sieveFactory.parse((InputStream)new ByteArrayInputStream(content.getBytes()));
        }
        catch (ParseException ex) {
            throw new SyntaxException((Throwable)ex);
        }
        return EMPTY_WARNINGS;
    }
}

