/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jsieve;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import org.apache.jsieve.CommandManager;
import org.apache.jsieve.ExecutableCommand;
import org.apache.jsieve.exception.LookupException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandManagerImpl
implements CommandManager {
    private static List<String> IMPLICITLY_DECLARED = Arrays.asList("if", "else", "elsif", "require", "stop", "keep", "discard", "redirect");
    private final ConcurrentMap<String, String> classNameMap;

    private static boolean isImplicitlyDeclared(String name) {
        return IMPLICITLY_DECLARED.contains(name);
    }

    public CommandManagerImpl(ConcurrentMap<String, String> classNameMap) {
        this.classNameMap = classNameMap;
    }

    private Class lookup(String name) throws LookupException {
        Class<?> cmdClass = null;
        try {
            cmdClass = this.getClass().getClassLoader().loadClass(this.getClassName(name));
        }
        catch (ClassNotFoundException e) {
            throw new LookupException("Command named '" + name + "' not found.");
        }
        if (!ExecutableCommand.class.isAssignableFrom(cmdClass)) {
            throw new LookupException("Class " + cmdClass.getName() + " must implement " + ExecutableCommand.class.getName());
        }
        return cmdClass;
    }

    @Override
    public ExecutableCommand getCommand(String name) throws LookupException {
        try {
            return (ExecutableCommand)this.lookup(name).newInstance();
        }
        catch (InstantiationException e) {
            throw new LookupException(e.getMessage());
        }
        catch (IllegalAccessException e) {
            throw new LookupException(e.getMessage());
        }
    }

    @Override
    public boolean isCommandSupported(String name) {
        boolean isSupported = false;
        try {
            this.lookup(name);
            isSupported = true;
        }
        catch (LookupException lookupException) {
            // empty catch block
        }
        return isSupported;
    }

    protected String getClassName(String name) throws LookupException {
        String className = (String)this.classNameMap.get(name.toLowerCase());
        if (null == className) {
            throw new LookupException("Command named '" + name + "' not mapped.");
        }
        return className;
    }

    @Override
    public List<String> getExtensions() {
        ArrayList<String> extensions = new ArrayList<String>(this.classNameMap.size());
        for (String key : this.classNameMap.keySet()) {
            if (CommandManagerImpl.isImplicitlyDeclared(key)) continue;
            extensions.add(key);
        }
        return extensions;
    }
}

