/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.managesieve.util;

import java.util.ArrayList;
import java.util.List;
import org.apache.james.managesieve.api.Session;

public class SettableSession
implements Session {
    String _user = null;
    boolean _isAuthenticated = false;
    List<Session.UserListener> _userListeners = new ArrayList<Session.UserListener>();
    List<Session.AuthenticationListener> _authenticationListeners = new ArrayList<Session.AuthenticationListener>();

    public void addAuthenticationListener(Session.AuthenticationListener listener) {
        this._authenticationListeners.add(listener);
    }

    public void addUserListener(Session.UserListener listener) {
        this._userListeners.add(listener);
    }

    public String getUser() {
        return this._user;
    }

    public boolean isAuthenticated() {
        return this._isAuthenticated;
    }

    public void removeAuthenticationListener(Session.AuthenticationListener listener) {
        this._authenticationListeners.remove(listener);
    }

    public void removeUserListener(Session.UserListener listener) {
        this._userListeners.remove(listener);
    }

    public void setAuthentication(boolean isAuthenticated) {
        this._isAuthenticated = isAuthenticated;
        for (Session.AuthenticationListener listener : this._authenticationListeners) {
            listener.notifyChange(isAuthenticated);
        }
    }

    public void setUser(String user) {
        this._user = user;
        for (Session.UserListener listener : this._userListeners) {
            listener.notifyChange(user);
        }
    }
}

