/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.managesieve.mailet.transcode;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.util.ByteArrayDataSource;
import org.apache.james.managesieve.transcode.LineToCoreToLine;
import org.apache.james.managesieve.util.ParserUtils;

public class MessageToCoreToMessage {
    private Map<String, Executable> _commands = this.computeCommands();
    private LineToCoreToLine _adapter = null;
    private HelpProvider _helpProvider = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static String getScript(MimeMessage message) throws IOException, MessagingException {
        String result = null;
        if (message.getContentType().startsWith("multipart/")) {
            MimeMultipart parts = (MimeMultipart)message.getContent();
            boolean found = false;
            for (int i = 0; !found && i < parts.getCount(); ++i) {
                MimeBodyPart part = (MimeBodyPart)parts.getBodyPart(i);
                found = part.isMimeType("application/sieve");
                if (!found) {
                    String fileName = null == part.getFileName() ? null : part.getFileName().toLowerCase();
                    boolean bl = found = null != fileName && (fileName.endsWith(".siv") || fileName.endsWith(".sieve"));
                }
                if (!found) continue;
                InputStream is = (InputStream)part.getContent();
                Scanner scanner = null;
                try {
                    scanner = new Scanner(is, "UTF-8").useDelimiter("\\A");
                    if (!scanner.hasNext()) continue;
                    result = scanner.next();
                    continue;
                }
                finally {
                    if (null != scanner) {
                        scanner.close();
                    }
                }
            }
        }
        if (null == result) {
            throw new MessagingException("Script part not found in this message");
        }
        return result;
    }

    protected static MimeBodyPart toPart(String name, String content) throws MessagingException, IOException {
        MimeBodyPart scriptPart = new MimeBodyPart();
        scriptPart.setDataHandler(new DataHandler((DataSource)new ByteArrayDataSource(content, "application/sieve; charset=UTF-8")));
        scriptPart.setDisposition("attachment");
        scriptPart.setFileName(name);
        return scriptPart;
    }

    protected static MimeBodyPart toPart(String message) throws MessagingException {
        MimeBodyPart part = new MimeBodyPart();
        part.setText(message);
        part.setDisposition("inline");
        return part;
    }

    private MessageToCoreToMessage() {
    }

    public MessageToCoreToMessage(LineToCoreToLine adapter, HelpProvider helpProvider) {
        this();
        this._adapter = adapter;
        this._helpProvider = helpProvider;
    }

    public MimeMessage execute(MimeMessage message) throws MessagingException {
        String subject = null == message.getSubject() ? "" : message.getSubject();
        String[] args = subject.split(" ", 2);
        String command = 0 == args.length ? "HELP" : args[0].toUpperCase();
        Executable executable = null;
        executable = this._commands.get(command);
        if (null == executable) {
            executable = this._commands.get("HELP");
        }
        MimeMultipart content = executable.execute(args.length > 1 ? args[1] : "", message);
        MimeMessage reply = (MimeMessage)message.reply(false);
        reply.setContent((Multipart)content);
        if (null == message.getAllRecipients() || 0 >= message.getAllRecipients().length) {
            throw new MessagingException("Message has no recipients");
        }
        Address from = message.getAllRecipients()[0];
        reply.setFrom(from);
        reply.saveChanges();
        return reply;
    }

    protected Map<String, Executable> computeCommands() {
        HashMap<String, Executable> commands = new HashMap<String, Executable>();
        commands.put("HELP", new Executable(){

            @Override
            public MimeMultipart execute(String operands, MimeMessage message) throws MessagingException {
                return MessageToCoreToMessage.this.help(operands, message);
            }
        });
        commands.put("CAPABILITY", new Executable(){

            @Override
            public MimeMultipart execute(String operands, MimeMessage message) throws MessagingException {
                return MessageToCoreToMessage.this.capability(operands, message);
            }
        });
        commands.put("CHECKSCRIPT", new Executable(){

            @Override
            public MimeMultipart execute(String operands, MimeMessage message) throws MessagingException {
                return MessageToCoreToMessage.this.checkScript(operands, message);
            }
        });
        commands.put("DELETESCRIPT", new Executable(){

            @Override
            public MimeMultipart execute(String operands, MimeMessage message) throws MessagingException {
                return MessageToCoreToMessage.this.deleteScript(operands, message);
            }
        });
        commands.put("GETSCRIPT", new Executable(){

            @Override
            public MimeMultipart execute(String operands, MimeMessage message) throws MessagingException {
                return MessageToCoreToMessage.this.getScript(operands, message);
            }
        });
        commands.put("HAVESPACE", new Executable(){

            @Override
            public MimeMultipart execute(String operands, MimeMessage message) throws MessagingException {
                return MessageToCoreToMessage.this.haveSpace(operands, message);
            }
        });
        commands.put("LISTSCRIPTS", new Executable(){

            @Override
            public MimeMultipart execute(String operands, MimeMessage message) throws MessagingException {
                return MessageToCoreToMessage.this.listScripts(operands, message);
            }
        });
        commands.put("PUTSCRIPT", new Executable(){

            @Override
            public MimeMultipart execute(String operands, MimeMessage message) throws MessagingException {
                return MessageToCoreToMessage.this.putScript(operands, message);
            }
        });
        commands.put("RENAMESCRIPT", new Executable(){

            @Override
            public MimeMultipart execute(String operands, MimeMessage message) throws MessagingException {
                return MessageToCoreToMessage.this.renameScript(operands, message);
            }
        });
        commands.put("SETACTIVE", new Executable(){

            @Override
            public MimeMultipart execute(String operands, MimeMessage message) throws MessagingException {
                return MessageToCoreToMessage.this.setActive(operands, message);
            }
        });
        commands.put("GETACTIVE", new Executable(){

            @Override
            public MimeMultipart execute(String operands, MimeMessage message) throws MessagingException {
                return MessageToCoreToMessage.this.getActive(operands, message);
            }
        });
        return commands;
    }

    protected MimeMultipart help(String operands, MimeMessage message) throws MessagingException {
        MimeMultipart multipart = new MimeMultipart();
        multipart.addBodyPart((BodyPart)MessageToCoreToMessage.toPart(this._helpProvider.getHelp()));
        return multipart;
    }

    protected MimeMultipart capability(String operands, MimeMessage message) throws MessagingException {
        MimeMultipart multipart = new MimeMultipart();
        multipart.addBodyPart((BodyPart)MessageToCoreToMessage.toPart(this._adapter.capability(operands)));
        return multipart;
    }

    protected MimeMultipart checkScript(String operands, MimeMessage message) throws MessagingException {
        MimeMultipart multipart = new MimeMultipart();
        String result = null;
        Scanner scanner = new Scanner(operands).useDelimiter("\\A");
        if (scanner.hasNext()) {
            result = "NO \"Too many arguments: " + scanner.next() + "\"";
        } else {
            try {
                String content = MessageToCoreToMessage.getScript(message);
                result = this._adapter.checkScript(content);
            }
            catch (MessagingException ex) {
                result = "NO \"" + ex.getMessage() + "\"";
            }
            catch (IOException ex) {
                result = "NO \"Failed to read script part\"";
            }
        }
        multipart.addBodyPart((BodyPart)MessageToCoreToMessage.toPart(result));
        return multipart;
    }

    protected MimeMultipart deleteScript(String operands, MimeMessage message) throws MessagingException {
        MimeMultipart multipart = new MimeMultipart();
        multipart.addBodyPart((BodyPart)MessageToCoreToMessage.toPart(this._adapter.deleteScript(operands)));
        return multipart;
    }

    protected MimeMultipart getScript(String operands, MimeMessage message) throws MessagingException {
        String result = this._adapter.getScript(operands);
        String response = null;
        String script = null;
        int endOfScript = result.lastIndexOf("\r\n");
        if (endOfScript > 0) {
            script = result.substring(0, endOfScript);
            response = result.substring(endOfScript + "\r\n".length());
        } else {
            response = result;
        }
        MimeMultipart multipart = new MimeMultipart();
        multipart.addBodyPart((BodyPart)MessageToCoreToMessage.toPart(response));
        if (null != script) {
            try {
                multipart.addBodyPart((BodyPart)MessageToCoreToMessage.toPart(ParserUtils.unquote((String)ParserUtils.getScriptName((String)operands)), script));
            }
            catch (IOException ex) {
                throw new MessagingException("Failed to add script part", (Exception)ex);
            }
        }
        return multipart;
    }

    protected MimeMultipart haveSpace(String operands, MimeMessage message) throws MessagingException {
        MimeMultipart multipart = new MimeMultipart();
        multipart.addBodyPart((BodyPart)MessageToCoreToMessage.toPart(this._adapter.haveSpace(operands)));
        return multipart;
    }

    protected MimeMultipart listScripts(String operands, MimeMessage message) throws MessagingException {
        MimeMultipart multipart = new MimeMultipart();
        multipart.addBodyPart((BodyPart)MessageToCoreToMessage.toPart(this._adapter.listScripts(operands)));
        return multipart;
    }

    protected MimeMultipart putScript(String operands, MimeMessage message) throws MessagingException {
        MimeMultipart multipart = new MimeMultipart();
        String result = null;
        String scriptName = ParserUtils.getScriptName((String)operands);
        if (null == scriptName || scriptName.isEmpty()) {
            result = "NO \"Missing argument: script name\"";
        } else {
            Scanner scanner = new Scanner(operands.substring(scriptName.length()).trim()).useDelimiter("\\A");
            if (scanner.hasNext()) {
                result = "NO \"Too many arguments: " + scanner.next() + "\"";
            } else {
                StringBuilder builder = new StringBuilder(scriptName);
                String content = null;
                try {
                    content = MessageToCoreToMessage.getScript(message);
                }
                catch (MessagingException ex) {
                    result = "NO \"" + ex.getMessage() + "\"";
                }
                catch (IOException ex) {
                    result = "NO \"Failed to read script part\"";
                }
                if (null != content) {
                    builder.append(' ').append(content);
                }
                result = this._adapter.putScript(builder.toString().trim());
            }
        }
        multipart.addBodyPart((BodyPart)MessageToCoreToMessage.toPart(result));
        return multipart;
    }

    protected MimeMultipart renameScript(String operands, MimeMessage message) throws MessagingException {
        MimeMultipart multipart = new MimeMultipart();
        multipart.addBodyPart((BodyPart)MessageToCoreToMessage.toPart(this._adapter.renameScript(operands)));
        return multipart;
    }

    protected MimeMultipart setActive(String operands, MimeMessage message) throws MessagingException {
        MimeMultipart multipart = new MimeMultipart();
        multipart.addBodyPart((BodyPart)MessageToCoreToMessage.toPart(this._adapter.setActive(operands)));
        return multipart;
    }

    protected MimeMultipart getActive(String operands, MimeMessage message) throws MessagingException {
        String result = this._adapter.getActive(operands);
        this._adapter.getActive(operands);
        String response = null;
        String script = null;
        int endOfScript = result.lastIndexOf("\r\n");
        if (endOfScript > 0) {
            script = result.substring(0, endOfScript);
            response = result.substring(endOfScript + "\r\n".length());
        } else {
            response = result;
        }
        MimeMultipart multipart = new MimeMultipart();
        multipart.addBodyPart((BodyPart)MessageToCoreToMessage.toPart(response));
        if (null != script) {
            try {
                multipart.addBodyPart((BodyPart)MessageToCoreToMessage.toPart("active", script));
            }
            catch (IOException ex) {
                throw new MessagingException("Failed to add script part", (Exception)ex);
            }
        }
        return multipart;
    }

    private static interface Executable {
        public MimeMultipart execute(String var1, MimeMessage var2) throws MessagingException;
    }

    public static interface HelpProvider {
        public String getHelp() throws MessagingException;
    }
}

