/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mailet.base.mail;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import javax.activation.ActivationDataFlavor;
import javax.activation.DataContentHandler;
import javax.activation.DataSource;
import javax.mail.MessagingException;

public abstract class AbstractDataContentHandler
implements DataContentHandler {
    private ActivationDataFlavor fieldDataFlavor;

    protected void updateDataFlavor() {
        this.setDataFlavor(this.computeDataFlavor());
    }

    protected abstract ActivationDataFlavor computeDataFlavor();

    protected void setDataFlavor(ActivationDataFlavor aDataFlavor) {
        this.fieldDataFlavor = aDataFlavor;
    }

    public Object getContent(DataSource aDataSource) throws IOException {
        Object content = null;
        try {
            content = this.computeContent(aDataSource);
        }
        catch (MessagingException messagingException) {
            // empty catch block
        }
        return content;
    }

    protected abstract Object computeContent(DataSource var1) throws MessagingException;

    public Object getTransferData(DataFlavor aDataFlavor, DataSource aDataSource) throws UnsupportedFlavorException, IOException {
        Object content = null;
        if (this.getDataFlavor().equals(aDataFlavor)) {
            content = this.getContent(aDataSource);
        }
        return content;
    }

    public DataFlavor[] getTransferDataFlavors() {
        return new DataFlavor[]{this.getDataFlavor()};
    }

    protected ActivationDataFlavor getDataFlavor() {
        ActivationDataFlavor dataFlavor = null;
        dataFlavor = this.getDataFlavorBasic();
        if (null == dataFlavor) {
            this.updateDataFlavor();
            return this.getDataFlavor();
        }
        return dataFlavor;
    }

    private ActivationDataFlavor getDataFlavorBasic() {
        return this.fieldDataFlavor;
    }
}

