/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jsieve.tests;

import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.apache.jsieve.Argument;
import org.apache.jsieve.Arguments;
import org.apache.jsieve.SieveContext;
import org.apache.jsieve.StringListArgument;
import org.apache.jsieve.TagArgument;
import org.apache.jsieve.exception.SieveException;
import org.apache.jsieve.exception.SyntaxException;
import org.apache.jsieve.mail.MailAdapter;
import org.apache.jsieve.tests.AbstractTest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractComparatorTest
extends AbstractTest {
    @Override
    protected boolean executeBasic(MailAdapter mail, Arguments arguments, SieveContext context) throws SieveException {
        Argument argument;
        String addressPart = null;
        String comparator = null;
        String matchType = null;
        List<String> headerNames = null;
        List<String> keys = null;
        ListIterator<Argument> argumentsIter = arguments.getArgumentList().listIterator();
        boolean stop = false;
        while (!stop && argumentsIter.hasNext()) {
            argument = argumentsIter.next();
            if (argument instanceof TagArgument) {
                String tag = ((TagArgument)argument).getTag();
                if (null == addressPart && (tag.equals(":localpart") || tag.equals(":domain") || tag.equals(":all"))) {
                    addressPart = tag;
                    continue;
                }
                if (null == comparator && tag.equals(":comparator")) {
                    if (!argumentsIter.hasNext()) continue;
                    argument = argumentsIter.next();
                    if (argument instanceof StringListArgument) {
                        List<String> stringList = ((StringListArgument)argument).getList();
                        if (stringList.size() != 1) {
                            throw new SyntaxException("Expecting exactly one String");
                        }
                        comparator = stringList.get(0);
                        continue;
                    }
                    throw new SyntaxException("Expecting a StringList");
                }
                if (null == matchType && (tag.equals(":is") || tag.equals(":contains") || tag.equals(":matches"))) {
                    matchType = tag;
                    continue;
                }
                throw context.getCoordinate().syntaxException("Found unexpected TagArgument");
            }
            argumentsIter.previous();
            stop = true;
        }
        if (argumentsIter.hasNext() && (argument = argumentsIter.next()) instanceof StringListArgument) {
            headerNames = ((StringListArgument)argument).getList();
        }
        if (null == headerNames) {
            throw context.getCoordinate().syntaxException("Expecting a StringList of header names");
        }
        if (argumentsIter.hasNext()) {
            argument = argumentsIter.next();
            if (argument instanceof StringListArgument) {
                keys = ((StringListArgument)argument).getList();
            }
        } else if (null == keys) {
            throw context.getCoordinate().syntaxException("Expecting a StringList of keys");
        }
        if (argumentsIter.hasNext()) {
            throw context.getCoordinate().syntaxException("Found unexpected arguments");
        }
        return this.match(mail, addressPart == null ? ":all" : addressPart, comparator == null ? "i;ascii-casemap" : comparator, matchType == null ? ":is" : matchType, headerNames, keys, context);
    }

    protected boolean match(MailAdapter mail, String addressPart, String comparator, String matchType, List<String> headerNames, List<String> keys, SieveContext context) throws SieveException {
        String headerName;
        boolean isMatched = false;
        Iterator<String> i$ = headerNames.iterator();
        while (i$.hasNext() && !(isMatched = this.match(mail, addressPart, comparator, matchType, headerName = i$.next(), keys, context))) {
        }
        return isMatched;
    }

    protected boolean match(MailAdapter mail, String addressPart, String comparator, String matchType, String headerName, List<String> keys, SieveContext context) throws SieveException {
        String key;
        boolean isMatched = false;
        Iterator<String> i$ = keys.iterator();
        while (i$.hasNext() && !(isMatched = this.match(mail, addressPart, comparator, matchType, headerName, key = i$.next(), context))) {
        }
        return isMatched;
    }

    protected abstract boolean match(MailAdapter var1, String var2, String var3, String var4, String var5, String var6, SieveContext var7) throws SieveException;

    @Override
    protected void validateArguments(Arguments arguments, SieveContext context) throws SieveException {
        if (arguments.hasTests()) {
            throw context.getCoordinate().syntaxException("Found unexpected tests");
        }
    }
}

