/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.jpa.mail.model.openjpa;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import javax.mail.Flags;
import javax.mail.internet.SharedInputStream;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Lob;
import javax.persistence.Table;
import org.apache.commons.io.IOUtils;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.jpa.mail.model.JPAMailbox;
import org.apache.james.mailbox.jpa.mail.model.openjpa.AbstractJPAMessage;
import org.apache.james.mailbox.store.mail.model.Message;
import org.apache.james.mailbox.store.mail.model.impl.PropertyBuilder;
import org.apache.openjpa.enhance.PCRegistry;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.enhance.StateManager;
import org.apache.openjpa.persistence.Externalizer;
import org.apache.openjpa.persistence.Factory;

@Entity(name="Message")
@Table(name="JAMES_MAIL")
public class JPAEncryptedMessage
extends AbstractJPAMessage
implements PersistenceCapable {
    @Basic(optional=false, fetch=FetchType.LAZY)
    @Column(name="MAIL_BYTES", length=1048576000, nullable=false)
    @Externalizer(value="EncryptDecryptHelper.getEncrypted")
    @Factory(value="EncryptDecryptHelper.getDecrypted")
    @Lob
    private byte[] body;
    @Basic(optional=false, fetch=FetchType.LAZY)
    @Column(name="HEADER_BYTES", length=0xA00000, nullable=false)
    @Externalizer(value="EncryptDecryptHelper.getEncrypted")
    @Factory(value="EncryptDecryptHelper.getDecrypted")
    @Lob
    private byte[] header;
    private static int pcInheritedFieldCount = AbstractJPAMessage.pcGetManagedFieldCount();
    private static String[] pcFieldNames;
    private static Class[] pcFieldTypes;
    private static byte[] pcFieldFlags;
    private static Class pcPCSuperclass;
    static /* synthetic */ Class class$Lorg$apache$james$mailbox$jpa$mail$model$openjpa$AbstractJPAMessage;
    static /* synthetic */ Class class$L$B;
    static /* synthetic */ Class class$Lorg$apache$james$mailbox$jpa$mail$model$openjpa$JPAEncryptedMessage;

    @Deprecated
    public JPAEncryptedMessage() {
    }

    public JPAEncryptedMessage(JPAMailbox mailbox, Date internalDate, int size, Flags flags, SharedInputStream content, int bodyStartOctet, PropertyBuilder propertyBuilder) throws MailboxException {
        super(mailbox, internalDate, flags, size, bodyStartOctet, propertyBuilder);
        try {
            int headerEnd = bodyStartOctet;
            if (headerEnd < 0) {
                headerEnd = 0;
            }
            this.header = IOUtils.toByteArray((InputStream)content.newStream(0L, (long)headerEnd));
            this.body = IOUtils.toByteArray((InputStream)content.newStream((long)this.getBodyStartOctet(), -1L));
        }
        catch (IOException e) {
            throw new MailboxException("Unable to parse message", (Exception)e);
        }
    }

    public JPAEncryptedMessage(JPAMailbox mailbox, long uid, long modSeq, Message<?> message) throws MailboxException {
        super(mailbox, uid, modSeq, message);
        try {
            this.body = IOUtils.toByteArray((InputStream)message.getBodyContent());
            this.header = IOUtils.toByteArray((InputStream)message.getHeaderContent());
        }
        catch (IOException e) {
            throw new MailboxException("Unable to parse message", (Exception)e);
        }
    }

    public InputStream getBodyContent() throws IOException {
        return new ByteArrayInputStream(JPAEncryptedMessage.pcGetbody(this));
    }

    public InputStream getHeaderContent() throws IOException {
        return new ByteArrayInputStream(JPAEncryptedMessage.pcGetheader(this));
    }

    @Override
    public int pcGetEnhancementContractVersion() {
        return 2;
    }

    static {
        Class clazz = class$Lorg$apache$james$mailbox$jpa$mail$model$openjpa$AbstractJPAMessage != null ? class$Lorg$apache$james$mailbox$jpa$mail$model$openjpa$AbstractJPAMessage : (class$Lorg$apache$james$mailbox$jpa$mail$model$openjpa$AbstractJPAMessage = JPAEncryptedMessage.class$("org.apache.james.mailbox.jpa.mail.model.openjpa.AbstractJPAMessage"));
        pcPCSuperclass = clazz;
        pcFieldNames = new String[]{"body", "header"};
        Class[] classArray = new Class[2];
        Class clazz2 = class$L$B != null ? class$L$B : (class$L$B = JPAEncryptedMessage.class$("[B"));
        classArray[0] = clazz2;
        classArray[1] = class$L$B != null ? class$L$B : (class$L$B = JPAEncryptedMessage.class$("[B"));
        pcFieldTypes = classArray;
        pcFieldFlags = new byte[]{21, 21};
        Class clazz3 = class$Lorg$apache$james$mailbox$jpa$mail$model$openjpa$JPAEncryptedMessage != null ? class$Lorg$apache$james$mailbox$jpa$mail$model$openjpa$JPAEncryptedMessage : (class$Lorg$apache$james$mailbox$jpa$mail$model$openjpa$JPAEncryptedMessage = JPAEncryptedMessage.class$("org.apache.james.mailbox.jpa.mail.model.openjpa.JPAEncryptedMessage"));
        PCRegistry.register((Class)clazz3, (String[])pcFieldNames, (Class[])pcFieldTypes, (byte[])pcFieldFlags, (Class)pcPCSuperclass, (String)"Message", (PersistenceCapable)new JPAEncryptedMessage());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    @Override
    protected void pcClearFields() {
        super.pcClearFields();
        this.body = null;
        this.header = null;
    }

    @Override
    public PersistenceCapable pcNewInstance(StateManager stateManager, Object object, boolean bl) {
        JPAEncryptedMessage jPAEncryptedMessage = new JPAEncryptedMessage();
        if (bl) {
            jPAEncryptedMessage.pcClearFields();
        }
        jPAEncryptedMessage.pcStateManager = stateManager;
        jPAEncryptedMessage.pcCopyKeyFieldsFromObjectId(object);
        return jPAEncryptedMessage;
    }

    @Override
    public PersistenceCapable pcNewInstance(StateManager stateManager, boolean bl) {
        JPAEncryptedMessage jPAEncryptedMessage = new JPAEncryptedMessage();
        if (bl) {
            jPAEncryptedMessage.pcClearFields();
        }
        jPAEncryptedMessage.pcStateManager = stateManager;
        return jPAEncryptedMessage;
    }

    protected static int pcGetManagedFieldCount() {
        return 2 + AbstractJPAMessage.pcGetManagedFieldCount();
    }

    @Override
    public void pcReplaceField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcReplaceField(n);
            return;
        }
        switch (n2) {
            case 0: {
                this.body = (byte[])this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 1: {
                this.header = (byte[])this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcReplaceFields(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            this.pcReplaceField(nArray[n]);
            ++n;
        }
    }

    @Override
    public void pcProvideField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcProvideField(n);
            return;
        }
        switch (n2) {
            case 0: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.body);
                return;
            }
            case 1: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.header);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcProvideFields(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            this.pcProvideField(nArray[n]);
            ++n;
        }
    }

    protected void pcCopyField(JPAEncryptedMessage jPAEncryptedMessage, int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcCopyField(jPAEncryptedMessage, n);
            return;
        }
        switch (n2) {
            case 0: {
                this.body = jPAEncryptedMessage.body;
                return;
            }
            case 1: {
                this.header = jPAEncryptedMessage.header;
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcCopyFields(Object object, int[] nArray) {
        JPAEncryptedMessage jPAEncryptedMessage = (JPAEncryptedMessage)((Object)object);
        if (jPAEncryptedMessage.pcStateManager != this.pcStateManager) {
            throw new IllegalArgumentException();
        }
        if (this.pcStateManager == null) {
            throw new IllegalStateException();
        }
        int n = 0;
        while (n < nArray.length) {
            this.pcCopyField(jPAEncryptedMessage, nArray[n]);
            ++n;
        }
    }

    @Override
    public Class pcGetIDOwningClass() {
        Class clazz = class$Lorg$apache$james$mailbox$jpa$mail$model$openjpa$JPAEncryptedMessage != null ? class$Lorg$apache$james$mailbox$jpa$mail$model$openjpa$JPAEncryptedMessage : (class$Lorg$apache$james$mailbox$jpa$mail$model$openjpa$JPAEncryptedMessage = JPAEncryptedMessage.class$("org.apache.james.mailbox.jpa.mail.model.openjpa.JPAEncryptedMessage"));
        return clazz;
    }

    private static final byte[] pcGetbody(JPAEncryptedMessage jPAEncryptedMessage) {
        if (jPAEncryptedMessage.pcStateManager == null) {
            return jPAEncryptedMessage.body;
        }
        int n = pcInheritedFieldCount + 0;
        jPAEncryptedMessage.pcStateManager.accessingField(n);
        return jPAEncryptedMessage.body;
    }

    private static final void pcSetbody(JPAEncryptedMessage jPAEncryptedMessage, byte[] byArray) {
        if (jPAEncryptedMessage.pcStateManager == null) {
            jPAEncryptedMessage.body = byArray;
            return;
        }
        jPAEncryptedMessage.pcStateManager.settingObjectField((PersistenceCapable)jPAEncryptedMessage, pcInheritedFieldCount + 0, (Object)jPAEncryptedMessage.body, (Object)byArray, 0);
    }

    private static final byte[] pcGetheader(JPAEncryptedMessage jPAEncryptedMessage) {
        if (jPAEncryptedMessage.pcStateManager == null) {
            return jPAEncryptedMessage.header;
        }
        int n = pcInheritedFieldCount + 1;
        jPAEncryptedMessage.pcStateManager.accessingField(n);
        return jPAEncryptedMessage.header;
    }

    private static final void pcSetheader(JPAEncryptedMessage jPAEncryptedMessage, byte[] byArray) {
        if (jPAEncryptedMessage.pcStateManager == null) {
            jPAEncryptedMessage.header = byArray;
            return;
        }
        jPAEncryptedMessage.pcStateManager.settingObjectField((PersistenceCapable)jPAEncryptedMessage, pcInheritedFieldCount + 1, (Object)jPAEncryptedMessage.header, (Object)byArray, 0);
    }
}

