/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.jpa;

import org.apache.james.mailbox.MailboxPathLocker;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.acl.GroupMembershipResolver;
import org.apache.james.mailbox.acl.MailboxACLResolver;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.jpa.JPAMailboxSessionMapperFactory;
import org.apache.james.mailbox.jpa.mail.JPAMailboxMapper;
import org.apache.james.mailbox.jpa.mail.model.JPAMailbox;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.mailbox.store.Authenticator;
import org.apache.james.mailbox.store.MailboxSessionMapperFactory;
import org.apache.james.mailbox.store.StoreMailboxManager;
import org.apache.james.mailbox.store.mail.model.Mailbox;
import org.apache.james.mailbox.store.transaction.Mapper;

public abstract class JPAMailboxManager
extends StoreMailboxManager<Long> {
    public JPAMailboxManager(JPAMailboxSessionMapperFactory mailboxSessionMapperFactory, Authenticator authenticator, MailboxPathLocker locker, MailboxACLResolver aclResolver, GroupMembershipResolver groupMembershipResolver) {
        super((MailboxSessionMapperFactory)mailboxSessionMapperFactory, authenticator, locker, aclResolver, groupMembershipResolver);
    }

    protected Mailbox<Long> doCreateMailbox(MailboxPath path, MailboxSession session) throws MailboxException {
        return new JPAMailbox(path, this.randomUidValidity());
    }

    public void deleteEverything(MailboxSession mailboxSession) throws MailboxException {
        final JPAMailboxMapper mapper = (JPAMailboxMapper)this.getMapperFactory().getMailboxMapper(mailboxSession);
        mapper.execute((Mapper.Transaction)new Mapper.VoidTransaction(){

            public void runVoid() throws MailboxException {
                mapper.deleteAllMemberships();
            }
        });
        mapper.execute((Mapper.Transaction)new Mapper.VoidTransaction(){

            public void runVoid() throws MailboxException {
                mapper.deleteAllMailboxes();
            }
        });
    }
}

