/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.jpa.openjpa;

import org.apache.james.mailbox.MailboxPathLocker;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.acl.GroupMembershipResolver;
import org.apache.james.mailbox.acl.MailboxACLResolver;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.jpa.JPAMailboxManager;
import org.apache.james.mailbox.jpa.JPAMailboxSessionMapperFactory;
import org.apache.james.mailbox.jpa.mail.model.openjpa.EncryptDecryptHelper;
import org.apache.james.mailbox.jpa.openjpa.OpenJPAMessageManager;
import org.apache.james.mailbox.store.Authenticator;
import org.apache.james.mailbox.store.JVMMailboxPathLocker;
import org.apache.james.mailbox.store.MailboxEventDispatcher;
import org.apache.james.mailbox.store.MailboxSessionMapperFactory;
import org.apache.james.mailbox.store.StoreMessageManager;
import org.apache.james.mailbox.store.mail.model.Mailbox;
import org.apache.james.mailbox.store.search.MessageSearchIndex;

public class OpenJPAMailboxManager
extends JPAMailboxManager {
    private OpenJPAMessageManager.AdvancedFeature feature;

    public OpenJPAMailboxManager(JPAMailboxSessionMapperFactory mapperFactory, Authenticator authenticator, MailboxPathLocker locker, boolean useStreaming, MailboxACLResolver aclResolver, GroupMembershipResolver groupMembershipResolver) {
        super(mapperFactory, authenticator, locker, aclResolver, groupMembershipResolver);
        this.feature = useStreaming ? OpenJPAMessageManager.AdvancedFeature.Streaming : OpenJPAMessageManager.AdvancedFeature.None;
    }

    public OpenJPAMailboxManager(JPAMailboxSessionMapperFactory mapperFactory, Authenticator authenticator, MailboxPathLocker locker, String encryptPass, MailboxACLResolver aclResolver, GroupMembershipResolver groupMembershipResolver) {
        super(mapperFactory, authenticator, locker, aclResolver, groupMembershipResolver);
        if (encryptPass != null) {
            EncryptDecryptHelper.init(encryptPass);
            this.feature = OpenJPAMessageManager.AdvancedFeature.Encryption;
        } else {
            this.feature = OpenJPAMessageManager.AdvancedFeature.None;
        }
    }

    public OpenJPAMailboxManager(JPAMailboxSessionMapperFactory mapperFactory, Authenticator authenticator, MailboxACLResolver aclResolver, GroupMembershipResolver groupMembershipResolver) {
        this(mapperFactory, authenticator, (MailboxPathLocker)new JVMMailboxPathLocker(), false, aclResolver, groupMembershipResolver);
    }

    protected StoreMessageManager<Long> createMessageManager(Mailbox<Long> mailboxRow, MailboxSession session) throws MailboxException {
        OpenJPAMessageManager result = new OpenJPAMessageManager((MailboxSessionMapperFactory<Long>)this.getMapperFactory(), (MessageSearchIndex<Long>)this.getMessageSearchIndex(), (MailboxEventDispatcher<Long>)this.getEventDispatcher(), this.getLocker(), mailboxRow, this.feature, this.getAclResolver(), this.getGroupMembershipResolver());
        return result;
    }
}

