/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.jpa.mail;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.EntityTransaction;
import javax.persistence.PersistenceException;
import javax.persistence.Query;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.jpa.mail.model.JPAMailbox;
import org.apache.james.mailbox.jpa.mail.model.openjpa.AbstractJPAMessage;
import org.apache.james.mailbox.jpa.mail.model.openjpa.JPAEncryptedMessage;
import org.apache.james.mailbox.jpa.mail.model.openjpa.JPAMessage;
import org.apache.james.mailbox.jpa.mail.model.openjpa.JPAStreamingMessage;
import org.apache.james.mailbox.model.MessageMetaData;
import org.apache.james.mailbox.model.MessageRange;
import org.apache.james.mailbox.store.SimpleMessageMetaData;
import org.apache.james.mailbox.store.mail.AbstractMessageMapper;
import org.apache.james.mailbox.store.mail.MessageMapper;
import org.apache.james.mailbox.store.mail.ModSeqProvider;
import org.apache.james.mailbox.store.mail.UidProvider;
import org.apache.james.mailbox.store.mail.model.Mailbox;
import org.apache.james.mailbox.store.mail.model.Message;
import org.apache.openjpa.persistence.ArgumentException;

public class JPAMessageMapper
extends AbstractMessageMapper<Long>
implements MessageMapper<Long> {
    protected EntityManagerFactory entityManagerFactory;
    protected EntityManager entityManager;

    public JPAMessageMapper(MailboxSession session, UidProvider<Long> uidProvider, ModSeqProvider<Long> modSeqProvider, EntityManagerFactory entityManagerFactory) {
        super(session, uidProvider, modSeqProvider);
        this.entityManagerFactory = entityManagerFactory;
    }

    public EntityManager getEntityManager() {
        if (this.entityManager != null) {
            return this.entityManager;
        }
        this.entityManager = this.entityManagerFactory.createEntityManager();
        return this.entityManager;
    }

    protected void begin() throws MailboxException {
        try {
            this.getEntityManager().getTransaction().begin();
        }
        catch (PersistenceException e) {
            throw new MailboxException("Begin of transaction failed", (Exception)((Object)e));
        }
    }

    protected void commit() throws MailboxException {
        try {
            this.getEntityManager().getTransaction().commit();
        }
        catch (PersistenceException e) {
            throw new MailboxException("Commit of transaction failed", (Exception)((Object)e));
        }
    }

    protected void rollback() throws MailboxException {
        EntityTransaction transaction = this.entityManager.getTransaction();
        if (transaction.isActive()) {
            this.getEntityManager().getTransaction().rollback();
        }
    }

    public void endRequest() {
        if (this.entityManager != null) {
            if (this.entityManager.isOpen()) {
                this.entityManager.close();
            }
            this.entityManager = null;
        }
    }

    public Iterator<Message<Long>> findInMailbox(Mailbox<Long> mailbox, MessageRange set, MessageMapper.FetchType fType, int max) throws MailboxException {
        try {
            List<Message<Long>> results;
            long from = set.getUidFrom();
            long to = set.getUidTo();
            MessageRange.Type type = set.getType();
            switch (type) {
                default: {
                    results = this.findMessagesInMailbox(mailbox, max);
                    break;
                }
                case FROM: {
                    results = this.findMessagesInMailboxAfterUID(mailbox, from, max);
                    break;
                }
                case ONE: {
                    results = this.findMessagesInMailboxWithUID(mailbox, from);
                    break;
                }
                case RANGE: {
                    results = this.findMessagesInMailboxBetweenUIDs(mailbox, from, to, max);
                }
            }
            return results.iterator();
        }
        catch (PersistenceException e) {
            throw new MailboxException("Search of MessageRange " + set + " failed in mailbox " + mailbox, (Exception)((Object)e));
        }
    }

    private List<Message<Long>> findMessagesInMailboxAfterUID(Mailbox<Long> mailbox, long uid, int batchSize) {
        Query query = this.getEntityManager().createNamedQuery("findMessagesInMailboxAfterUID").setParameter("idParam", mailbox.getMailboxId()).setParameter("uidParam", (Object)uid);
        if (batchSize > 0) {
            query.setMaxResults(batchSize);
        }
        return query.getResultList();
    }

    private List<Message<Long>> findMessagesInMailboxWithUID(Mailbox<Long> mailbox, long uid) {
        return this.getEntityManager().createNamedQuery("findMessagesInMailboxWithUID").setParameter("idParam", mailbox.getMailboxId()).setParameter("uidParam", (Object)uid).setMaxResults(1).getResultList();
    }

    private List<Message<Long>> findMessagesInMailboxBetweenUIDs(Mailbox<Long> mailbox, long from, long to, int batchSize) {
        Query query = this.getEntityManager().createNamedQuery("findMessagesInMailboxBetweenUIDs").setParameter("idParam", mailbox.getMailboxId()).setParameter("fromParam", (Object)from).setParameter("toParam", (Object)to);
        if (batchSize > 0) {
            query.setMaxResults(batchSize);
        }
        return query.getResultList();
    }

    private List<Message<Long>> findMessagesInMailbox(Mailbox<Long> mailbox, int batchSize) {
        Query query = this.getEntityManager().createNamedQuery("findMessagesInMailbox").setParameter("idParam", mailbox.getMailboxId());
        if (batchSize > 0) {
            query.setMaxResults(batchSize);
        }
        return query.getResultList();
    }

    private Map<Long, MessageMetaData> createMetaData(List<Message<Long>> uids) {
        HashMap<Long, MessageMetaData> data = new HashMap<Long, MessageMetaData>();
        for (int i = 0; i < uids.size(); ++i) {
            Message<Long> m = uids.get(i);
            data.put(m.getUid(), (MessageMetaData)new SimpleMessageMetaData(m));
        }
        return data;
    }

    private int deleteDeletedMessagesInMailbox(Mailbox<Long> mailbox) {
        return this.getEntityManager().createNamedQuery("deleteDeletedMessagesInMailbox").setParameter("idParam", mailbox.getMailboxId()).executeUpdate();
    }

    private int deleteDeletedMessagesInMailboxAfterUID(Mailbox<Long> mailbox, long uid) {
        return this.getEntityManager().createNamedQuery("deleteDeletedMessagesInMailboxAfterUID").setParameter("idParam", mailbox.getMailboxId()).setParameter("uidParam", (Object)uid).executeUpdate();
    }

    private int deleteDeletedMessagesInMailboxWithUID(Mailbox<Long> mailbox, long uid) {
        return this.getEntityManager().createNamedQuery("deleteDeletedMessagesInMailboxWithUID").setParameter("idParam", mailbox.getMailboxId()).setParameter("uidParam", (Object)uid).executeUpdate();
    }

    private int deleteDeletedMessagesInMailboxBetweenUIDs(Mailbox<Long> mailbox, long from, long to) {
        return this.getEntityManager().createNamedQuery("deleteDeletedMessagesInMailboxBetweenUIDs").setParameter("idParam", mailbox.getMailboxId()).setParameter("fromParam", (Object)from).setParameter("toParam", (Object)to).executeUpdate();
    }

    private List<Message<Long>> findDeletedMessagesInMailbox(Mailbox<Long> mailbox) {
        return this.getEntityManager().createNamedQuery("findDeletedMessagesInMailbox").setParameter("idParam", mailbox.getMailboxId()).getResultList();
    }

    private List<Message<Long>> findDeletedMessagesInMailboxAfterUID(Mailbox<Long> mailbox, long uid) {
        return this.getEntityManager().createNamedQuery("findDeletedMessagesInMailboxAfterUID").setParameter("idParam", mailbox.getMailboxId()).setParameter("uidParam", (Object)uid).getResultList();
    }

    private List<Message<Long>> findDeletedMessagesInMailboxWithUID(Mailbox<Long> mailbox, long uid) {
        return this.getEntityManager().createNamedQuery("findDeletedMessagesInMailboxWithUID").setParameter("idParam", mailbox.getMailboxId()).setParameter("uidParam", (Object)uid).setMaxResults(1).getResultList();
    }

    private List<Message<Long>> findDeletedMessagesInMailboxBetweenUIDs(Mailbox<Long> mailbox, long from, long to) {
        return this.getEntityManager().createNamedQuery("findDeletedMessagesInMailboxBetweenUIDs").setParameter("idParam", mailbox.getMailboxId()).setParameter("fromParam", (Object)from).setParameter("toParam", (Object)to).getResultList();
    }

    public long countMessagesInMailbox(Mailbox<Long> mailbox) throws MailboxException {
        try {
            return (Long)this.getEntityManager().createNamedQuery("countMessagesInMailbox").setParameter("idParam", mailbox.getMailboxId()).getSingleResult();
        }
        catch (PersistenceException e) {
            throw new MailboxException("Count of messages failed in mailbox " + mailbox, (Exception)((Object)e));
        }
    }

    public long countUnseenMessagesInMailbox(Mailbox<Long> mailbox) throws MailboxException {
        try {
            return (Long)this.getEntityManager().createNamedQuery("countUnseenMessagesInMailbox").setParameter("idParam", mailbox.getMailboxId()).getSingleResult();
        }
        catch (PersistenceException e) {
            throw new MailboxException("Count of useen messages failed in mailbox " + mailbox, (Exception)((Object)e));
        }
    }

    public void delete(Mailbox<Long> mailbox, Message<Long> message) throws MailboxException {
        try {
            this.getEntityManager().remove(message);
        }
        catch (PersistenceException e) {
            throw new MailboxException("Delete of message " + message + " failed in mailbox " + mailbox, (Exception)((Object)e));
        }
    }

    public Long findFirstUnseenMessageUid(Mailbox<Long> mailbox) throws MailboxException {
        try {
            Query query = this.getEntityManager().createNamedQuery("findUnseenMessagesInMailboxOrderByUid").setParameter("idParam", mailbox.getMailboxId());
            query.setMaxResults(1);
            List result = query.getResultList();
            if (result.isEmpty()) {
                return null;
            }
            return ((Message)result.get(0)).getUid();
        }
        catch (PersistenceException e) {
            throw new MailboxException("Search of first unseen message failed in mailbox " + mailbox, (Exception)((Object)e));
        }
    }

    public List<Long> findRecentMessageUidsInMailbox(Mailbox<Long> mailbox) throws MailboxException {
        try {
            Query query = this.getEntityManager().createNamedQuery("findRecentMessageUidsInMailbox").setParameter("idParam", mailbox.getMailboxId());
            return query.getResultList();
        }
        catch (PersistenceException e) {
            throw new MailboxException("Search of recent messages failed in mailbox " + mailbox, (Exception)((Object)e));
        }
    }

    protected MessageMetaData copy(Mailbox<Long> mailbox, long uid, long modSeq, Message<Long> original) throws MailboxException {
        AbstractJPAMessage copy = original instanceof JPAStreamingMessage ? new JPAStreamingMessage((JPAMailbox)mailbox, uid, modSeq, original) : (original instanceof JPAEncryptedMessage ? new JPAEncryptedMessage((JPAMailbox)mailbox, uid, modSeq, original) : new JPAMessage((JPAMailbox)mailbox, uid, modSeq, original));
        return this.save(mailbox, (Message<Long>)copy);
    }

    protected MessageMetaData save(Mailbox<Long> mailbox, Message<Long> message) throws MailboxException {
        try {
            ((AbstractJPAMessage)message).setMailbox((JPAMailbox)this.getEntityManager().find(JPAMailbox.class, mailbox.getMailboxId()));
            this.getEntityManager().persist(message);
            return new SimpleMessageMetaData(message);
        }
        catch (PersistenceException e) {
            throw new MailboxException("Save of message " + message + " failed in mailbox " + mailbox, (Exception)((Object)e));
        }
        catch (ArgumentException e) {
            throw new MailboxException("Save of message " + message + " failed in mailbox " + mailbox, (Exception)((Object)e));
        }
    }

    public Map<Long, MessageMetaData> expungeMarkedForDeletionInMailbox(Mailbox<Long> mailbox, MessageRange set) throws MailboxException {
        try {
            Map<Long, MessageMetaData> data;
            long from = set.getUidFrom();
            long to = set.getUidTo();
            switch (set.getType()) {
                case ONE: {
                    List<Message<Long>> results = this.findDeletedMessagesInMailboxWithUID(mailbox, from);
                    data = this.createMetaData(results);
                    this.deleteDeletedMessagesInMailboxWithUID(mailbox, from);
                    break;
                }
                case RANGE: {
                    List<Message<Long>> results = this.findDeletedMessagesInMailboxBetweenUIDs(mailbox, from, to);
                    data = this.createMetaData(results);
                    this.deleteDeletedMessagesInMailboxBetweenUIDs(mailbox, from, to);
                    break;
                }
                case FROM: {
                    List<Message<Long>> results = this.findDeletedMessagesInMailboxAfterUID(mailbox, from);
                    data = this.createMetaData(results);
                    this.deleteDeletedMessagesInMailboxAfterUID(mailbox, from);
                    break;
                }
                default: {
                    List<Message<Long>> results = this.findDeletedMessagesInMailbox(mailbox);
                    data = this.createMetaData(results);
                    this.deleteDeletedMessagesInMailbox(mailbox);
                }
            }
            return data;
        }
        catch (PersistenceException e) {
            throw new MailboxException("Search of MessageRange " + set + " failed in mailbox " + mailbox, (Exception)((Object)e));
        }
    }
}

