/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.jpa.openjpa;

import java.util.Date;
import javax.mail.Flags;
import javax.mail.internet.SharedInputStream;
import org.apache.james.mailbox.MailboxException;
import org.apache.james.mailbox.jpa.JPAMessageManager;
import org.apache.james.mailbox.jpa.mail.model.JPAMailbox;
import org.apache.james.mailbox.jpa.mail.model.openjpa.JPAStreamingMessage;
import org.apache.james.mailbox.store.MailboxEventDispatcher;
import org.apache.james.mailbox.store.MailboxSessionMapperFactory;
import org.apache.james.mailbox.store.mail.model.Mailbox;
import org.apache.james.mailbox.store.mail.model.Message;
import org.apache.james.mailbox.store.mail.model.impl.PropertyBuilder;
import org.apache.james.mailbox.store.search.MessageSearchIndex;

public class OpenJPAMessageManager
extends JPAMessageManager {
    private final boolean useStreaming;

    public OpenJPAMessageManager(MailboxSessionMapperFactory<Long> mapperFactory, MessageSearchIndex<Long> index, MailboxEventDispatcher<Long> dispatcher, Mailbox<Long> mailbox) throws MailboxException {
        this(mapperFactory, index, dispatcher, mailbox, false);
    }

    public OpenJPAMessageManager(MailboxSessionMapperFactory<Long> mapperFactory, MessageSearchIndex<Long> index, MailboxEventDispatcher<Long> dispatcher, Mailbox<Long> mailbox, boolean useStreaming) throws MailboxException {
        super(mapperFactory, index, dispatcher, mailbox);
        this.useStreaming = useStreaming;
    }

    @Override
    protected Message<Long> createMessage(Date internalDate, int size, int bodyStartOctet, SharedInputStream content, Flags flags, PropertyBuilder propertyBuilder) throws MailboxException {
        if (this.useStreaming) {
            int headerEnd = bodyStartOctet - 2;
            if (headerEnd < 0) {
                headerEnd = 0;
            }
            return new JPAStreamingMessage((JPAMailbox)this.getMailboxEntity(), internalDate, size, flags, content, bodyStartOctet, propertyBuilder);
        }
        return super.createMessage(internalDate, size, bodyStartOctet, content, flags, propertyBuilder);
    }
}

