/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.jpa.openjpa;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.mail.Flags;
import org.apache.james.mailbox.MailboxException;
import org.apache.james.mailbox.jpa.JPAMailboxSessionMapperFactory;
import org.apache.james.mailbox.jpa.JPAMessageManager;
import org.apache.james.mailbox.jpa.mail.model.JPAHeader;
import org.apache.james.mailbox.jpa.mail.model.JPAMailbox;
import org.apache.james.mailbox.jpa.mail.model.openjpa.JPAStreamingMessage;
import org.apache.james.mailbox.store.mail.UidProvider;
import org.apache.james.mailbox.store.mail.model.Header;
import org.apache.james.mailbox.store.mail.model.Mailbox;
import org.apache.james.mailbox.store.mail.model.Message;
import org.apache.james.mailbox.store.mail.model.PropertyBuilder;
import org.apache.james.mailbox.util.MailboxEventDispatcher;

public class OpenJPAMessageManager
extends JPAMessageManager {
    private final boolean useStreaming;

    public OpenJPAMessageManager(JPAMailboxSessionMapperFactory mapperFactory, UidProvider<Long> uidProvider, MailboxEventDispatcher dispatcher, Mailbox<Long> mailbox) throws MailboxException {
        this(mapperFactory, uidProvider, dispatcher, mailbox, false);
    }

    public OpenJPAMessageManager(JPAMailboxSessionMapperFactory mapperFactory, UidProvider<Long> uidProvider, MailboxEventDispatcher dispatcher, Mailbox<Long> mailbox, boolean useStreaming) throws MailboxException {
        super(mapperFactory, uidProvider, dispatcher, mailbox);
        this.useStreaming = useStreaming;
    }

    @Override
    protected Message<Long> createMessage(long uid, Date internalDate, int size, int bodyStartOctet, InputStream document, Flags flags, List<Header> headers, PropertyBuilder propertyBuilder) throws MailboxException {
        if (this.useStreaming) {
            ArrayList<JPAHeader> jpaHeaders = new ArrayList<JPAHeader>(headers.size());
            for (Header header : headers) {
                jpaHeaders.add((JPAHeader)header);
            }
            return new JPAStreamingMessage((JPAMailbox)this.getMailboxEntity(), uid, internalDate, size, flags, document, bodyStartOctet, jpaHeaders, propertyBuilder);
        }
        return super.createMessage(uid, internalDate, size, bodyStartOctet, document, flags, headers, propertyBuilder);
    }
}

