/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.jpa.mail.model.openjpa;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.mail.Flags;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.IdClass;
import javax.persistence.ManyToOne;
import javax.persistence.MappedSuperclass;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import org.apache.james.mailbox.MailboxException;
import org.apache.james.mailbox.jpa.mail.model.JPAHeader;
import org.apache.james.mailbox.jpa.mail.model.JPAMailbox;
import org.apache.james.mailbox.jpa.mail.model.JPAProperty;
import org.apache.james.mailbox.jpa.mail.model.JPAUserFlag;
import org.apache.james.mailbox.store.mail.model.AbstractMessage;
import org.apache.james.mailbox.store.mail.model.Header;
import org.apache.james.mailbox.store.mail.model.Message;
import org.apache.james.mailbox.store.mail.model.Property;
import org.apache.james.mailbox.store.mail.model.PropertyBuilder;
import org.apache.openjpa.enhance.FieldConsumer;
import org.apache.openjpa.enhance.FieldSupplier;
import org.apache.openjpa.enhance.PCRegistry;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.enhance.RedefinitionHelper;
import org.apache.openjpa.enhance.StateManager;
import org.apache.openjpa.persistence.jdbc.ElementJoinColumn;
import org.apache.openjpa.persistence.jdbc.ElementJoinColumns;
import org.apache.openjpa.persistence.jdbc.Index;
import org.apache.openjpa.util.LongId;
import org.apache.openjpa.util.ObjectId;
import org.apache.openjpa.util.UserException;

@IdClass(value=MailboxIdUidKey.class)
@NamedQueries(value={@NamedQuery(name="findRecentMessagesInMailbox", query="SELECT message FROM Message message WHERE message.mailbox.mailboxId = :idParam AND message.recent = TRUE"), @NamedQuery(name="findUnseenMessagesInMailboxOrderByUid", query="SELECT message FROM Message message WHERE message.mailbox.mailboxId = :idParam AND message.seen = FALSE ORDER BY message.uid ASC"), @NamedQuery(name="findMessagesInMailbox", query="SELECT message FROM Message message WHERE message.mailbox.mailboxId = :idParam"), @NamedQuery(name="findMessagesInMailboxBetweenUIDs", query="SELECT message FROM Message message WHERE message.mailbox.mailboxId = :idParam AND message.uid BETWEEN :fromParam AND :toParam"), @NamedQuery(name="findMessagesInMailboxWithUID", query="SELECT message FROM Message message WHERE message.mailbox.mailboxId = :idParam AND message.uid=:uidParam"), @NamedQuery(name="findMessagesInMailboxAfterUID", query="SELECT message FROM Message message WHERE message.mailbox.mailboxId = :idParam AND message.uid>=:uidParam"), @NamedQuery(name="findDeletedMessagesInMailbox", query="SELECT message.uid FROM Message message WHERE message.mailbox.mailboxId = :idParam AND message.deleted=TRUE"), @NamedQuery(name="findDeletedMessagesInMailboxBetweenUIDs", query="SELECT message.uid FROM Message message WHERE message.mailbox.mailboxId = :idParam AND message.uid BETWEEN :fromParam AND :toParam AND message.deleted=TRUE"), @NamedQuery(name="findDeletedMessagesInMailboxWithUID", query="SELECT message.uid FROM Message message WHERE message.mailbox.mailboxId = :idParam AND message.uid=:uidParam AND message.deleted=TRUE"), @NamedQuery(name="findDeletedMessagesInMailboxAfterUID", query="SELECT message.uid FROM Message message WHERE message.mailbox.mailboxId = :idParam AND message.uid>=:uidParam AND message.deleted=TRUE"), @NamedQuery(name="deleteDeletedMessagesInMailbox", query="DELETE FROM Message message WHERE message.mailbox.mailboxId = :idParam AND message.deleted=TRUE"), @NamedQuery(name="deleteDeletedMessagesInMailboxBetweenUIDs", query="DELETE FROM Message message WHERE message.mailbox.mailboxId = :idParam AND message.uid BETWEEN :fromParam AND :toParam AND message.deleted=TRUE"), @NamedQuery(name="deleteDeletedMessagesInMailboxWithUID", query="DELETE FROM Message message WHERE message.mailbox.mailboxId = :idParam AND message.uid=:uidParam AND message.deleted=TRUE"), @NamedQuery(name="deleteDeletedMessagesInMailboxAfterUID", query="DELETE FROM Message message WHERE message.mailbox.mailboxId = :idParam AND message.uid>=:uidParam AND message.deleted=TRUE"), @NamedQuery(name="countUnseenMessagesInMailbox", query="SELECT COUNT(message) FROM Message message WHERE message.mailbox.mailboxId = :idParam AND message.seen=FALSE"), @NamedQuery(name="countMessagesInMailbox", query="SELECT COUNT(message) FROM Message message WHERE message.mailbox.mailboxId = :idParam"), @NamedQuery(name="deleteMessages", query="DELETE FROM Message message WHERE message.mailbox.mailboxId = :idParam"), @NamedQuery(name="findLastUidInMailbox", query="SELECT message.uid FROM Message message WHERE message.mailbox.mailboxId = :idParam ORDER BY message.uid DESC"), @NamedQuery(name="deleteAllMemberships", query="DELETE FROM Message message")})
@MappedSuperclass
public abstract class AbstractJPAMessage
extends AbstractMessage<Long> {
    private static final String TOSTRING_SEPARATOR = " ";
    @Id
    @ManyToOne(cascade={CascadeType.PERSIST, CascadeType.REFRESH, CascadeType.MERGE}, fetch=FetchType.LAZY)
    @Column(name="MAILBOX_ID", nullable=true)
    private JPAMailbox mailbox;
    @Id
    @Column(name="MAIL_UID")
    private long uid;
    @Basic(optional=false)
    @Column(name="MAIL_DATE")
    private Date internalDate;
    @Basic(optional=false)
    @Column(name="MAIL_IS_ANSWERED", nullable=false)
    private boolean answered = false;
    @Basic(optional=false)
    @Column(name="MAIL_IS_DELETED", nullable=false)
    @Index
    private boolean deleted = false;
    @Basic(optional=false)
    @Column(name="MAIL_IS_DRAFT", nullable=false)
    private boolean draft = false;
    @Basic(optional=false)
    @Column(name="MAIL_IS_FLAGGED", nullable=false)
    private boolean flagged = false;
    @Basic(optional=false)
    @Column(name="MAIL_IS_RECENT", nullable=false)
    @Index
    private boolean recent = false;
    @Basic(optional=false)
    @Column(name="MAIL_IS_SEEN", nullable=false)
    @Index
    private boolean seen = false;
    @Basic(optional=false)
    @Column(name="MAIL_BODY_START_OCTET", nullable=false)
    private int bodyStartOctet;
    @Basic(optional=false)
    @Column(name="MAIL_CONTENT_OCTETS_COUNT", nullable=false)
    private long contentOctets;
    @Basic(optional=true)
    @Column(name="MAIL_MIME_TYPE", nullable=true, length=200)
    private String mediaType;
    @Basic(optional=true)
    @Column(name="MAIL_MIME_SUBTYPE", nullable=true, length=200)
    private String subType;
    @Basic(optional=true)
    @Column(name="MAIL_TEXTUAL_LINE_COUNT", nullable=true)
    private Long textualLineCount;
    @OneToMany(cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    @OrderBy(value="lineNumber")
    @ElementJoinColumns(value={@ElementJoinColumn(name="MAILBOX_ID", referencedColumnName="MAILBOX_ID"), @ElementJoinColumn(name="MAIL_UID", referencedColumnName="MAIL_UID")})
    private List<JPAHeader> headers;
    @OneToMany(cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    @OrderBy(value="line")
    @ElementJoinColumns(value={@ElementJoinColumn(name="MAILBOX_ID", referencedColumnName="MAILBOX_ID"), @ElementJoinColumn(name="MAIL_UID", referencedColumnName="MAIL_UID")})
    private List<JPAProperty> properties;
    @OneToMany(cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    @OrderBy(value="id")
    @ElementJoinColumns(value={@ElementJoinColumn(name="MAILBOX_ID", referencedColumnName="MAILBOX_ID"), @ElementJoinColumn(name="MAIL_UID", referencedColumnName="MAIL_UID")})
    private List<JPAUserFlag> userFlags;
    private static int pcInheritedFieldCount;
    private static String[] pcFieldNames;
    private static Class[] pcFieldTypes;
    private static byte[] pcFieldFlags;
    private static Class pcPCSuperclass;
    protected transient StateManager pcStateManager;
    static /* synthetic */ Class class$Ljava$util$List;
    static /* synthetic */ Class class$Ljava$util$Date;
    static /* synthetic */ Class class$Lorg$apache$james$mailbox$jpa$mail$model$JPAMailbox;
    static /* synthetic */ Class class$Ljava$lang$String;
    static /* synthetic */ Class class$Ljava$lang$Long;
    static /* synthetic */ Class class$Lorg$apache$james$mailbox$jpa$mail$model$openjpa$AbstractJPAMessage;
    private transient Object pcDetachedState;

    @Deprecated
    public AbstractJPAMessage() {
    }

    public AbstractJPAMessage(JPAMailbox mailbox, long uid, Date internalDate, Flags flags, long contentOctets, int bodyStartOctet, List<JPAHeader> headers, PropertyBuilder propertyBuilder) {
        this.mailbox = mailbox;
        this.internalDate = internalDate;
        this.uid = uid;
        this.userFlags = new ArrayList<JPAUserFlag>();
        this.setFlags(flags);
        this.contentOctets = contentOctets;
        this.bodyStartOctet = bodyStartOctet;
        this.headers = new ArrayList<JPAHeader>(headers);
        this.textualLineCount = propertyBuilder.getTextualLineCount();
        this.mediaType = propertyBuilder.getMediaType();
        this.subType = propertyBuilder.getSubType();
        List properties = propertyBuilder.toProperties();
        this.properties = new ArrayList<JPAProperty>(properties.size());
        int order = 0;
        for (Property property : properties) {
            this.properties.add(new JPAProperty(property, order++));
        }
    }

    public AbstractJPAMessage(JPAMailbox mailbox, long uid, Message<?> original) throws MailboxException {
        this.mailbox = mailbox;
        this.uid = uid;
        this.userFlags = new ArrayList<JPAUserFlag>();
        this.setFlags(original.createFlags());
        this.contentOctets = original.getFullContentOctets();
        this.bodyStartOctet = (int)(original.getFullContentOctets() - original.getBodyOctets());
        this.headers = new ArrayList<JPAHeader>();
        this.internalDate = original.getInternalDate();
        List originalHeaders = original.getHeaders();
        for (int i = 0; i < originalHeaders.size(); ++i) {
            this.headers.add(new JPAHeader((Header)originalHeaders.get(i)));
        }
        PropertyBuilder pBuilder = new PropertyBuilder(original.getProperties());
        this.textualLineCount = original.getTextualLineCount();
        this.mediaType = original.getMediaType();
        this.subType = original.getSubType();
        List properties = pBuilder.toProperties();
        this.properties = new ArrayList<JPAProperty>(properties.size());
        int order = 0;
        for (Property property : properties) {
            this.properties.add(new JPAProperty(property, order++));
        }
    }

    public List<Header> getHeaders() {
        return new ArrayList<Header>(AbstractJPAMessage.pcGetheaders(this));
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + (int)(this.getMailboxId() ^ this.getMailboxId() >>> 32);
        result = 31 * result + (int)(AbstractJPAMessage.pcGetuid(this) ^ AbstractJPAMessage.pcGetuid(this) >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        AbstractJPAMessage other = (AbstractJPAMessage)((Object)obj);
        if (this.getMailboxId() != null ? !this.getMailboxId().equals(other.getMailboxId()) : other.getMailboxId() != null) {
            return false;
        }
        return AbstractJPAMessage.pcGetuid(this) == AbstractJPAMessage.pcGetuid(other);
    }

    public String getMediaType() {
        return AbstractJPAMessage.pcGetmediaType(this);
    }

    public String getSubType() {
        return AbstractJPAMessage.pcGetsubType(this);
    }

    public List<Property> getProperties() {
        return new ArrayList<Property>(AbstractJPAMessage.pcGetproperties(this));
    }

    public Long getTextualLineCount() {
        return AbstractJPAMessage.pcGettextualLineCount(this);
    }

    public long getFullContentOctets() {
        return AbstractJPAMessage.pcGetcontentOctets(this);
    }

    protected int getBodyStartOctet() {
        return AbstractJPAMessage.pcGetbodyStartOctet(this);
    }

    public Date getInternalDate() {
        return AbstractJPAMessage.pcGetinternalDate(this);
    }

    public Long getMailboxId() {
        return this.getMailbox().getMailboxId();
    }

    public long getUid() {
        return AbstractJPAMessage.pcGetuid(this);
    }

    public boolean isAnswered() {
        return AbstractJPAMessage.pcGetanswered(this);
    }

    public boolean isDeleted() {
        return AbstractJPAMessage.pcGetdeleted(this);
    }

    public boolean isDraft() {
        return AbstractJPAMessage.pcGetdraft(this);
    }

    public boolean isFlagged() {
        return AbstractJPAMessage.pcGetflagged(this);
    }

    public boolean isRecent() {
        return AbstractJPAMessage.pcGetrecent(this);
    }

    public boolean isSeen() {
        return AbstractJPAMessage.pcGetseen(this);
    }

    public void setUid(long uid) {
        AbstractJPAMessage.pcSetuid(this, uid);
    }

    public void setFlags(Flags flags) {
        AbstractJPAMessage.pcSetanswered(this, flags.contains(Flags.Flag.ANSWERED));
        AbstractJPAMessage.pcSetdeleted(this, flags.contains(Flags.Flag.DELETED));
        AbstractJPAMessage.pcSetdraft(this, flags.contains(Flags.Flag.DRAFT));
        AbstractJPAMessage.pcSetflagged(this, flags.contains(Flags.Flag.FLAGGED));
        AbstractJPAMessage.pcSetrecent(this, flags.contains(Flags.Flag.RECENT));
        AbstractJPAMessage.pcSetseen(this, flags.contains(Flags.Flag.SEEN));
        String[] userflags = flags.getUserFlags();
        AbstractJPAMessage.pcGetuserFlags(this).clear();
        for (int i = 0; i < userflags.length; ++i) {
            AbstractJPAMessage.pcGetuserFlags(this).add(new JPAUserFlag(userflags[i]));
        }
    }

    public JPAMailbox getMailbox() {
        return AbstractJPAMessage.pcGetmailbox(this);
    }

    protected String[] createUserFlags() {
        String[] flags = new String[AbstractJPAMessage.pcGetuserFlags(this).size()];
        for (int i = 0; i < AbstractJPAMessage.pcGetuserFlags(this).size(); ++i) {
            flags[i] = ((JPAUserFlag)AbstractJPAMessage.pcGetuserFlags(this).get(i)).getName();
        }
        return flags;
    }

    public void setMailbox(JPAMailbox mailbox) {
        AbstractJPAMessage.pcSetmailbox(this, mailbox);
    }

    public String toString() {
        String retValue = "message(mailboxId = " + this.getMailboxId() + TOSTRING_SEPARATOR + "uid = " + AbstractJPAMessage.pcGetuid(this) + TOSTRING_SEPARATOR + "internalDate = " + AbstractJPAMessage.pcGetinternalDate(this) + TOSTRING_SEPARATOR + "answered = " + AbstractJPAMessage.pcGetanswered(this) + TOSTRING_SEPARATOR + "deleted = " + AbstractJPAMessage.pcGetdeleted(this) + TOSTRING_SEPARATOR + "draft = " + AbstractJPAMessage.pcGetdraft(this) + TOSTRING_SEPARATOR + "flagged = " + AbstractJPAMessage.pcGetflagged(this) + TOSTRING_SEPARATOR + "recent = " + AbstractJPAMessage.pcGetrecent(this) + TOSTRING_SEPARATOR + "seen = " + AbstractJPAMessage.pcGetseen(this) + TOSTRING_SEPARATOR + " )";
        return retValue;
    }

    public int pcGetEnhancementContractVersion() {
        return 2;
    }

    static {
        pcFieldNames = new String[]{"answered", "bodyStartOctet", "contentOctets", "deleted", "draft", "flagged", "headers", "internalDate", "mailbox", "mediaType", "properties", "recent", "seen", "subType", "textualLineCount", "uid", "userFlags"};
        Class[] classArray = new Class[17];
        classArray[0] = Boolean.TYPE;
        classArray[1] = Integer.TYPE;
        classArray[2] = Long.TYPE;
        classArray[3] = Boolean.TYPE;
        classArray[4] = Boolean.TYPE;
        classArray[5] = Boolean.TYPE;
        Class clazz = class$Ljava$util$List != null ? class$Ljava$util$List : (class$Ljava$util$List = AbstractJPAMessage.class$("java.util.List"));
        classArray[6] = clazz;
        Class clazz2 = class$Ljava$util$Date != null ? class$Ljava$util$Date : (class$Ljava$util$Date = AbstractJPAMessage.class$("java.util.Date"));
        classArray[7] = clazz2;
        Class clazz3 = class$Lorg$apache$james$mailbox$jpa$mail$model$JPAMailbox != null ? class$Lorg$apache$james$mailbox$jpa$mail$model$JPAMailbox : (class$Lorg$apache$james$mailbox$jpa$mail$model$JPAMailbox = AbstractJPAMessage.class$("org.apache.james.mailbox.jpa.mail.model.JPAMailbox"));
        classArray[8] = clazz3;
        Class clazz4 = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = AbstractJPAMessage.class$("java.lang.String"));
        classArray[9] = clazz4;
        classArray[10] = class$Ljava$util$List != null ? class$Ljava$util$List : (class$Ljava$util$List = AbstractJPAMessage.class$("java.util.List"));
        classArray[11] = Boolean.TYPE;
        classArray[12] = Boolean.TYPE;
        classArray[13] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = AbstractJPAMessage.class$("java.lang.String"));
        Class clazz5 = class$Ljava$lang$Long != null ? class$Ljava$lang$Long : (class$Ljava$lang$Long = AbstractJPAMessage.class$("java.lang.Long"));
        classArray[14] = clazz5;
        classArray[15] = Long.TYPE;
        classArray[16] = class$Ljava$util$List != null ? class$Ljava$util$List : (class$Ljava$util$List = AbstractJPAMessage.class$("java.util.List"));
        pcFieldTypes = classArray;
        pcFieldFlags = new byte[]{26, 26, 26, 26, 26, 26, 5, 26, 10, 26, 5, 26, 26, 26, 26, 26, 5};
        Class clazz6 = class$Lorg$apache$james$mailbox$jpa$mail$model$openjpa$AbstractJPAMessage != null ? class$Lorg$apache$james$mailbox$jpa$mail$model$openjpa$AbstractJPAMessage : (class$Lorg$apache$james$mailbox$jpa$mail$model$openjpa$AbstractJPAMessage = AbstractJPAMessage.class$("org.apache.james.mailbox.jpa.mail.model.openjpa.AbstractJPAMessage"));
        PCRegistry.register((Class)clazz6, (String[])pcFieldNames, (Class[])pcFieldTypes, (byte[])pcFieldFlags, (Class)pcPCSuperclass, (String)"AbstractJPAMessage", null);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected void pcClearFields() {
        this.answered = false;
        this.bodyStartOctet = 0;
        this.contentOctets = 0L;
        this.deleted = false;
        this.draft = false;
        this.flagged = false;
        this.headers = null;
        this.internalDate = null;
        this.mailbox = null;
        this.mediaType = null;
        this.properties = null;
        this.recent = false;
        this.seen = false;
        this.subType = null;
        this.textualLineCount = null;
        this.uid = 0L;
        this.userFlags = null;
    }

    public PersistenceCapable pcNewInstance(StateManager stateManager, Object object, boolean bl) {
        throw new UserException();
    }

    public PersistenceCapable pcNewInstance(StateManager stateManager, boolean bl) {
        throw new UserException();
    }

    protected static int pcGetManagedFieldCount() {
        return 17;
    }

    public void pcReplaceField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        switch (n2) {
            case 0: {
                this.answered = this.pcStateManager.replaceBooleanField((PersistenceCapable)this, n);
                return;
            }
            case 1: {
                this.bodyStartOctet = this.pcStateManager.replaceIntField((PersistenceCapable)this, n);
                return;
            }
            case 2: {
                this.contentOctets = this.pcStateManager.replaceLongField((PersistenceCapable)this, n);
                return;
            }
            case 3: {
                this.deleted = this.pcStateManager.replaceBooleanField((PersistenceCapable)this, n);
                return;
            }
            case 4: {
                this.draft = this.pcStateManager.replaceBooleanField((PersistenceCapable)this, n);
                return;
            }
            case 5: {
                this.flagged = this.pcStateManager.replaceBooleanField((PersistenceCapable)this, n);
                return;
            }
            case 6: {
                this.headers = (List)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 7: {
                this.internalDate = (Date)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 8: {
                this.mailbox = (JPAMailbox)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 9: {
                this.mediaType = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 10: {
                this.properties = (List)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 11: {
                this.recent = this.pcStateManager.replaceBooleanField((PersistenceCapable)this, n);
                return;
            }
            case 12: {
                this.seen = this.pcStateManager.replaceBooleanField((PersistenceCapable)this, n);
                return;
            }
            case 13: {
                this.subType = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 14: {
                this.textualLineCount = (Long)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 15: {
                this.uid = this.pcStateManager.replaceLongField((PersistenceCapable)this, n);
                return;
            }
            case 16: {
                this.userFlags = (List)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    public void pcReplaceFields(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            this.pcReplaceField(nArray[n]);
            ++n;
        }
    }

    public void pcProvideField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        switch (n2) {
            case 0: {
                this.pcStateManager.providedBooleanField((PersistenceCapable)this, n, this.answered);
                return;
            }
            case 1: {
                this.pcStateManager.providedIntField((PersistenceCapable)this, n, this.bodyStartOctet);
                return;
            }
            case 2: {
                this.pcStateManager.providedLongField((PersistenceCapable)this, n, this.contentOctets);
                return;
            }
            case 3: {
                this.pcStateManager.providedBooleanField((PersistenceCapable)this, n, this.deleted);
                return;
            }
            case 4: {
                this.pcStateManager.providedBooleanField((PersistenceCapable)this, n, this.draft);
                return;
            }
            case 5: {
                this.pcStateManager.providedBooleanField((PersistenceCapable)this, n, this.flagged);
                return;
            }
            case 6: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, this.headers);
                return;
            }
            case 7: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.internalDate);
                return;
            }
            case 8: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.mailbox);
                return;
            }
            case 9: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.mediaType);
                return;
            }
            case 10: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, this.properties);
                return;
            }
            case 11: {
                this.pcStateManager.providedBooleanField((PersistenceCapable)this, n, this.recent);
                return;
            }
            case 12: {
                this.pcStateManager.providedBooleanField((PersistenceCapable)this, n, this.seen);
                return;
            }
            case 13: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.subType);
                return;
            }
            case 14: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.textualLineCount);
                return;
            }
            case 15: {
                this.pcStateManager.providedLongField((PersistenceCapable)this, n, this.uid);
                return;
            }
            case 16: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, this.userFlags);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    public void pcProvideFields(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            this.pcProvideField(nArray[n]);
            ++n;
        }
    }

    protected void pcCopyField(AbstractJPAMessage abstractJPAMessage, int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        switch (n2) {
            case 0: {
                this.answered = abstractJPAMessage.answered;
                return;
            }
            case 1: {
                this.bodyStartOctet = abstractJPAMessage.bodyStartOctet;
                return;
            }
            case 2: {
                this.contentOctets = abstractJPAMessage.contentOctets;
                return;
            }
            case 3: {
                this.deleted = abstractJPAMessage.deleted;
                return;
            }
            case 4: {
                this.draft = abstractJPAMessage.draft;
                return;
            }
            case 5: {
                this.flagged = abstractJPAMessage.flagged;
                return;
            }
            case 6: {
                this.headers = abstractJPAMessage.headers;
                return;
            }
            case 7: {
                this.internalDate = abstractJPAMessage.internalDate;
                return;
            }
            case 8: {
                this.mailbox = abstractJPAMessage.mailbox;
                return;
            }
            case 9: {
                this.mediaType = abstractJPAMessage.mediaType;
                return;
            }
            case 10: {
                this.properties = abstractJPAMessage.properties;
                return;
            }
            case 11: {
                this.recent = abstractJPAMessage.recent;
                return;
            }
            case 12: {
                this.seen = abstractJPAMessage.seen;
                return;
            }
            case 13: {
                this.subType = abstractJPAMessage.subType;
                return;
            }
            case 14: {
                this.textualLineCount = abstractJPAMessage.textualLineCount;
                return;
            }
            case 15: {
                this.uid = abstractJPAMessage.uid;
                return;
            }
            case 16: {
                this.userFlags = abstractJPAMessage.userFlags;
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    public void pcCopyFields(Object object, int[] nArray) {
        AbstractJPAMessage abstractJPAMessage = (AbstractJPAMessage)((Object)object);
        if (abstractJPAMessage.pcStateManager != this.pcStateManager) {
            throw new IllegalArgumentException();
        }
        if (this.pcStateManager == null) {
            throw new IllegalStateException();
        }
        int n = 0;
        while (n < nArray.length) {
            this.pcCopyField(abstractJPAMessage, nArray[n]);
            ++n;
        }
    }

    public Object pcGetGenericContext() {
        if (this.pcStateManager == null) {
            return null;
        }
        return this.pcStateManager.getGenericContext();
    }

    public Object pcFetchObjectId() {
        if (this.pcStateManager == null) {
            return null;
        }
        return this.pcStateManager.fetchObjectId();
    }

    public boolean pcIsDeleted() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isDeleted();
    }

    public boolean pcIsDirty() {
        if (this.pcStateManager == null) {
            return false;
        }
        StateManager stateManager = this.pcStateManager;
        RedefinitionHelper.dirtyCheck((StateManager)stateManager);
        return stateManager.isDirty();
    }

    public boolean pcIsNew() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isNew();
    }

    public boolean pcIsPersistent() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isPersistent();
    }

    public boolean pcIsTransactional() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isTransactional();
    }

    public boolean pcSerializing() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.serializing();
    }

    public void pcDirty(String string) {
        if (this.pcStateManager == null) {
            return;
        }
        this.pcStateManager.dirty(string);
    }

    public StateManager pcGetStateManager() {
        return this.pcStateManager;
    }

    public Object pcGetVersion() {
        if (this.pcStateManager == null) {
            return null;
        }
        return this.pcStateManager.getVersion();
    }

    public synchronized void pcReplaceStateManager(StateManager stateManager) throws SecurityException {
        if (this.pcStateManager != null) {
            this.pcStateManager = this.pcStateManager.replaceStateManager(stateManager);
            return;
        }
        this.pcStateManager = stateManager;
    }

    public void pcCopyKeyFieldsToObjectId(FieldSupplier fieldSupplier, Object object) {
        MailboxIdUidKey mailboxIdUidKey = (MailboxIdUidKey)((ObjectId)object).getId();
        int n = pcInheritedFieldCount;
        mailboxIdUidKey.mailbox = fieldSupplier.fetchLongField(8 + n);
        mailboxIdUidKey.uid = fieldSupplier.fetchLongField(15 + n);
    }

    public void pcCopyKeyFieldsToObjectId(Object object) {
        Object object2;
        MailboxIdUidKey mailboxIdUidKey = (MailboxIdUidKey)((ObjectId)object).getId();
        JPAMailbox jPAMailbox = this.mailbox;
        mailboxIdUidKey.mailbox = jPAMailbox != null && (object2 = ((PersistenceCapable)jPAMailbox).pcNewObjectIdInstance()) != null ? ((LongId)object2).getId() : 0L;
        mailboxIdUidKey.uid = this.uid;
    }

    public void pcCopyKeyFieldsFromObjectId(FieldConsumer fieldConsumer, Object object) {
        MailboxIdUidKey mailboxIdUidKey = (MailboxIdUidKey)((ObjectId)object).getId();
        fieldConsumer.storeLongField(8 + pcInheritedFieldCount, mailboxIdUidKey.mailbox);
        fieldConsumer.storeLongField(15 + pcInheritedFieldCount, mailboxIdUidKey.uid);
    }

    public void pcCopyKeyFieldsFromObjectId(Object object) {
        MailboxIdUidKey mailboxIdUidKey = (MailboxIdUidKey)((ObjectId)object).getId();
        if (this.pcStateManager == null) {
            return;
        }
        this.mailbox = (JPAMailbox)this.pcStateManager.getPCPrimaryKey((Object)mailboxIdUidKey, 8 + pcInheritedFieldCount);
        this.uid = mailboxIdUidKey.uid;
    }

    public Class pcGetIDOwningClass() {
        Class clazz = class$Lorg$apache$james$mailbox$jpa$mail$model$openjpa$AbstractJPAMessage != null ? class$Lorg$apache$james$mailbox$jpa$mail$model$openjpa$AbstractJPAMessage : (class$Lorg$apache$james$mailbox$jpa$mail$model$openjpa$AbstractJPAMessage = AbstractJPAMessage.class$("org.apache.james.mailbox.jpa.mail.model.openjpa.AbstractJPAMessage"));
        return clazz;
    }

    public Object pcNewObjectIdInstance(Object object) {
        throw new IllegalArgumentException("The id type \"class org.apache.james.mailbox.jpa.mail.model.openjpa.AbstractJPAMessage$MailboxIdUidKey\" specified by persistent type \"class org.apache.james.mailbox.jpa.mail.model.openjpa.AbstractJPAMessage\" does not have a public class org.apache.james.mailbox.jpa.mail.model.openjpa.AbstractJPAMessage$MailboxIdUidKey(String) or class org.apache.james.mailbox.jpa.mail.model.openjpa.AbstractJPAMessage$MailboxIdUidKey(Class, String) constructor.");
    }

    public Object pcNewObjectIdInstance() {
        return new ObjectId(this.pcGetIDOwningClass(), (Object)new MailboxIdUidKey());
    }

    private static final boolean pcGetanswered(AbstractJPAMessage abstractJPAMessage) {
        if (abstractJPAMessage.pcStateManager == null) {
            return abstractJPAMessage.answered;
        }
        int n = pcInheritedFieldCount + 0;
        abstractJPAMessage.pcStateManager.accessingField(n);
        return abstractJPAMessage.answered;
    }

    private static final void pcSetanswered(AbstractJPAMessage abstractJPAMessage, boolean bl) {
        if (abstractJPAMessage.pcStateManager == null) {
            abstractJPAMessage.answered = bl;
            return;
        }
        abstractJPAMessage.pcStateManager.settingBooleanField((PersistenceCapable)abstractJPAMessage, pcInheritedFieldCount + 0, abstractJPAMessage.answered, bl, 0);
    }

    private static final int pcGetbodyStartOctet(AbstractJPAMessage abstractJPAMessage) {
        if (abstractJPAMessage.pcStateManager == null) {
            return abstractJPAMessage.bodyStartOctet;
        }
        int n = pcInheritedFieldCount + 1;
        abstractJPAMessage.pcStateManager.accessingField(n);
        return abstractJPAMessage.bodyStartOctet;
    }

    private static final void pcSetbodyStartOctet(AbstractJPAMessage abstractJPAMessage, int n) {
        if (abstractJPAMessage.pcStateManager == null) {
            abstractJPAMessage.bodyStartOctet = n;
            return;
        }
        abstractJPAMessage.pcStateManager.settingIntField((PersistenceCapable)abstractJPAMessage, pcInheritedFieldCount + 1, abstractJPAMessage.bodyStartOctet, n, 0);
    }

    private static final long pcGetcontentOctets(AbstractJPAMessage abstractJPAMessage) {
        if (abstractJPAMessage.pcStateManager == null) {
            return abstractJPAMessage.contentOctets;
        }
        int n = pcInheritedFieldCount + 2;
        abstractJPAMessage.pcStateManager.accessingField(n);
        return abstractJPAMessage.contentOctets;
    }

    private static final void pcSetcontentOctets(AbstractJPAMessage abstractJPAMessage, long l) {
        if (abstractJPAMessage.pcStateManager == null) {
            abstractJPAMessage.contentOctets = l;
            return;
        }
        abstractJPAMessage.pcStateManager.settingLongField((PersistenceCapable)abstractJPAMessage, pcInheritedFieldCount + 2, abstractJPAMessage.contentOctets, l, 0);
    }

    private static final boolean pcGetdeleted(AbstractJPAMessage abstractJPAMessage) {
        if (abstractJPAMessage.pcStateManager == null) {
            return abstractJPAMessage.deleted;
        }
        int n = pcInheritedFieldCount + 3;
        abstractJPAMessage.pcStateManager.accessingField(n);
        return abstractJPAMessage.deleted;
    }

    private static final void pcSetdeleted(AbstractJPAMessage abstractJPAMessage, boolean bl) {
        if (abstractJPAMessage.pcStateManager == null) {
            abstractJPAMessage.deleted = bl;
            return;
        }
        abstractJPAMessage.pcStateManager.settingBooleanField((PersistenceCapable)abstractJPAMessage, pcInheritedFieldCount + 3, abstractJPAMessage.deleted, bl, 0);
    }

    private static final boolean pcGetdraft(AbstractJPAMessage abstractJPAMessage) {
        if (abstractJPAMessage.pcStateManager == null) {
            return abstractJPAMessage.draft;
        }
        int n = pcInheritedFieldCount + 4;
        abstractJPAMessage.pcStateManager.accessingField(n);
        return abstractJPAMessage.draft;
    }

    private static final void pcSetdraft(AbstractJPAMessage abstractJPAMessage, boolean bl) {
        if (abstractJPAMessage.pcStateManager == null) {
            abstractJPAMessage.draft = bl;
            return;
        }
        abstractJPAMessage.pcStateManager.settingBooleanField((PersistenceCapable)abstractJPAMessage, pcInheritedFieldCount + 4, abstractJPAMessage.draft, bl, 0);
    }

    private static final boolean pcGetflagged(AbstractJPAMessage abstractJPAMessage) {
        if (abstractJPAMessage.pcStateManager == null) {
            return abstractJPAMessage.flagged;
        }
        int n = pcInheritedFieldCount + 5;
        abstractJPAMessage.pcStateManager.accessingField(n);
        return abstractJPAMessage.flagged;
    }

    private static final void pcSetflagged(AbstractJPAMessage abstractJPAMessage, boolean bl) {
        if (abstractJPAMessage.pcStateManager == null) {
            abstractJPAMessage.flagged = bl;
            return;
        }
        abstractJPAMessage.pcStateManager.settingBooleanField((PersistenceCapable)abstractJPAMessage, pcInheritedFieldCount + 5, abstractJPAMessage.flagged, bl, 0);
    }

    private static final List pcGetheaders(AbstractJPAMessage abstractJPAMessage) {
        if (abstractJPAMessage.pcStateManager == null) {
            return abstractJPAMessage.headers;
        }
        int n = pcInheritedFieldCount + 6;
        abstractJPAMessage.pcStateManager.accessingField(n);
        return abstractJPAMessage.headers;
    }

    private static final void pcSetheaders(AbstractJPAMessage abstractJPAMessage, List list) {
        if (abstractJPAMessage.pcStateManager == null) {
            abstractJPAMessage.headers = list;
            return;
        }
        abstractJPAMessage.pcStateManager.settingObjectField((PersistenceCapable)abstractJPAMessage, pcInheritedFieldCount + 6, abstractJPAMessage.headers, (Object)list, 0);
    }

    private static final Date pcGetinternalDate(AbstractJPAMessage abstractJPAMessage) {
        if (abstractJPAMessage.pcStateManager == null) {
            return abstractJPAMessage.internalDate;
        }
        int n = pcInheritedFieldCount + 7;
        abstractJPAMessage.pcStateManager.accessingField(n);
        return abstractJPAMessage.internalDate;
    }

    private static final void pcSetinternalDate(AbstractJPAMessage abstractJPAMessage, Date date) {
        if (abstractJPAMessage.pcStateManager == null) {
            abstractJPAMessage.internalDate = date;
            return;
        }
        abstractJPAMessage.pcStateManager.settingObjectField((PersistenceCapable)abstractJPAMessage, pcInheritedFieldCount + 7, (Object)abstractJPAMessage.internalDate, (Object)date, 0);
    }

    private static final JPAMailbox pcGetmailbox(AbstractJPAMessage abstractJPAMessage) {
        if (abstractJPAMessage.pcStateManager == null) {
            return abstractJPAMessage.mailbox;
        }
        int n = pcInheritedFieldCount + 8;
        abstractJPAMessage.pcStateManager.accessingField(n);
        return abstractJPAMessage.mailbox;
    }

    private static final void pcSetmailbox(AbstractJPAMessage abstractJPAMessage, JPAMailbox jPAMailbox) {
        if (abstractJPAMessage.pcStateManager == null) {
            abstractJPAMessage.mailbox = jPAMailbox;
            return;
        }
        abstractJPAMessage.pcStateManager.settingObjectField((PersistenceCapable)abstractJPAMessage, pcInheritedFieldCount + 8, (Object)abstractJPAMessage.mailbox, (Object)jPAMailbox, 0);
    }

    private static final String pcGetmediaType(AbstractJPAMessage abstractJPAMessage) {
        if (abstractJPAMessage.pcStateManager == null) {
            return abstractJPAMessage.mediaType;
        }
        int n = pcInheritedFieldCount + 9;
        abstractJPAMessage.pcStateManager.accessingField(n);
        return abstractJPAMessage.mediaType;
    }

    private static final void pcSetmediaType(AbstractJPAMessage abstractJPAMessage, String string) {
        if (abstractJPAMessage.pcStateManager == null) {
            abstractJPAMessage.mediaType = string;
            return;
        }
        abstractJPAMessage.pcStateManager.settingStringField((PersistenceCapable)abstractJPAMessage, pcInheritedFieldCount + 9, abstractJPAMessage.mediaType, string, 0);
    }

    private static final List pcGetproperties(AbstractJPAMessage abstractJPAMessage) {
        if (abstractJPAMessage.pcStateManager == null) {
            return abstractJPAMessage.properties;
        }
        int n = pcInheritedFieldCount + 10;
        abstractJPAMessage.pcStateManager.accessingField(n);
        return abstractJPAMessage.properties;
    }

    private static final void pcSetproperties(AbstractJPAMessage abstractJPAMessage, List list) {
        if (abstractJPAMessage.pcStateManager == null) {
            abstractJPAMessage.properties = list;
            return;
        }
        abstractJPAMessage.pcStateManager.settingObjectField((PersistenceCapable)abstractJPAMessage, pcInheritedFieldCount + 10, abstractJPAMessage.properties, (Object)list, 0);
    }

    private static final boolean pcGetrecent(AbstractJPAMessage abstractJPAMessage) {
        if (abstractJPAMessage.pcStateManager == null) {
            return abstractJPAMessage.recent;
        }
        int n = pcInheritedFieldCount + 11;
        abstractJPAMessage.pcStateManager.accessingField(n);
        return abstractJPAMessage.recent;
    }

    private static final void pcSetrecent(AbstractJPAMessage abstractJPAMessage, boolean bl) {
        if (abstractJPAMessage.pcStateManager == null) {
            abstractJPAMessage.recent = bl;
            return;
        }
        abstractJPAMessage.pcStateManager.settingBooleanField((PersistenceCapable)abstractJPAMessage, pcInheritedFieldCount + 11, abstractJPAMessage.recent, bl, 0);
    }

    private static final boolean pcGetseen(AbstractJPAMessage abstractJPAMessage) {
        if (abstractJPAMessage.pcStateManager == null) {
            return abstractJPAMessage.seen;
        }
        int n = pcInheritedFieldCount + 12;
        abstractJPAMessage.pcStateManager.accessingField(n);
        return abstractJPAMessage.seen;
    }

    private static final void pcSetseen(AbstractJPAMessage abstractJPAMessage, boolean bl) {
        if (abstractJPAMessage.pcStateManager == null) {
            abstractJPAMessage.seen = bl;
            return;
        }
        abstractJPAMessage.pcStateManager.settingBooleanField((PersistenceCapable)abstractJPAMessage, pcInheritedFieldCount + 12, abstractJPAMessage.seen, bl, 0);
    }

    private static final String pcGetsubType(AbstractJPAMessage abstractJPAMessage) {
        if (abstractJPAMessage.pcStateManager == null) {
            return abstractJPAMessage.subType;
        }
        int n = pcInheritedFieldCount + 13;
        abstractJPAMessage.pcStateManager.accessingField(n);
        return abstractJPAMessage.subType;
    }

    private static final void pcSetsubType(AbstractJPAMessage abstractJPAMessage, String string) {
        if (abstractJPAMessage.pcStateManager == null) {
            abstractJPAMessage.subType = string;
            return;
        }
        abstractJPAMessage.pcStateManager.settingStringField((PersistenceCapable)abstractJPAMessage, pcInheritedFieldCount + 13, abstractJPAMessage.subType, string, 0);
    }

    private static final Long pcGettextualLineCount(AbstractJPAMessage abstractJPAMessage) {
        if (abstractJPAMessage.pcStateManager == null) {
            return abstractJPAMessage.textualLineCount;
        }
        int n = pcInheritedFieldCount + 14;
        abstractJPAMessage.pcStateManager.accessingField(n);
        return abstractJPAMessage.textualLineCount;
    }

    private static final void pcSettextualLineCount(AbstractJPAMessage abstractJPAMessage, Long l) {
        if (abstractJPAMessage.pcStateManager == null) {
            abstractJPAMessage.textualLineCount = l;
            return;
        }
        abstractJPAMessage.pcStateManager.settingObjectField((PersistenceCapable)abstractJPAMessage, pcInheritedFieldCount + 14, (Object)abstractJPAMessage.textualLineCount, (Object)l, 0);
    }

    private static final long pcGetuid(AbstractJPAMessage abstractJPAMessage) {
        if (abstractJPAMessage.pcStateManager == null) {
            return abstractJPAMessage.uid;
        }
        int n = pcInheritedFieldCount + 15;
        abstractJPAMessage.pcStateManager.accessingField(n);
        return abstractJPAMessage.uid;
    }

    private static final void pcSetuid(AbstractJPAMessage abstractJPAMessage, long l) {
        if (abstractJPAMessage.pcStateManager == null) {
            abstractJPAMessage.uid = l;
            return;
        }
        abstractJPAMessage.pcStateManager.settingLongField((PersistenceCapable)abstractJPAMessage, pcInheritedFieldCount + 15, abstractJPAMessage.uid, l, 0);
    }

    private static final List pcGetuserFlags(AbstractJPAMessage abstractJPAMessage) {
        if (abstractJPAMessage.pcStateManager == null) {
            return abstractJPAMessage.userFlags;
        }
        int n = pcInheritedFieldCount + 16;
        abstractJPAMessage.pcStateManager.accessingField(n);
        return abstractJPAMessage.userFlags;
    }

    private static final void pcSetuserFlags(AbstractJPAMessage abstractJPAMessage, List list) {
        if (abstractJPAMessage.pcStateManager == null) {
            abstractJPAMessage.userFlags = list;
            return;
        }
        abstractJPAMessage.pcStateManager.settingObjectField((PersistenceCapable)abstractJPAMessage, pcInheritedFieldCount + 16, abstractJPAMessage.userFlags, (Object)list, 0);
    }

    public Boolean pcIsDetached() {
        if (this.pcStateManager != null) {
            if (this.pcStateManager.isDetached()) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        if (this.pcGetDetachedState() != null && this.pcGetDetachedState() != PersistenceCapable.DESERIALIZED) {
            return Boolean.TRUE;
        }
        if (!this.pcisDetachedStateDefinitive()) {
            return null;
        }
        return Boolean.FALSE;
    }

    private boolean pcisDetachedStateDefinitive() {
        return false;
    }

    public Object pcGetDetachedState() {
        return this.pcDetachedState;
    }

    public void pcSetDetachedState(Object object) {
        this.pcDetachedState = object;
    }

    public static class MailboxIdUidKey
    implements Serializable {
        private static final long serialVersionUID = 7847632032426660997L;
        public long mailbox;
        public long uid;

        public int hashCode() {
            int PRIME = 31;
            int result = 1;
            result = 31 * result + (int)(this.mailbox ^ this.mailbox >>> 32);
            result = 31 * result + (int)(this.uid ^ this.uid >>> 32);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            MailboxIdUidKey other = (MailboxIdUidKey)obj;
            if (this.mailbox != other.mailbox) {
                return false;
            }
            return this.uid == other.uid;
        }
    }
}

