/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.jpa.mail;

import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceException;
import org.apache.james.mailbox.MailboxException;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.store.mail.CachingUidProvider;
import org.apache.james.mailbox.store.mail.model.Mailbox;

public class JPACachingUidProvider
extends CachingUidProvider<Long> {
    private final EntityManagerFactory factory;

    public JPACachingUidProvider(EntityManagerFactory factory) {
        this.factory = factory;
    }

    protected long getLastUid(MailboxSession session, Mailbox<Long> mailbox) throws MailboxException {
        EntityManager em = this.factory.createEntityManager();
        try {
            em.getTransaction().begin();
            long uid = (Long)em.createNamedQuery("findLastUidInMailbox").setParameter("idParam", mailbox.getMailboxId()).setMaxResults(1).getSingleResult();
            em.getTransaction().commit();
            long l = uid;
            return l;
        }
        catch (NoResultException e) {
            em.getTransaction().rollback();
            long l = 0L;
            return l;
        }
        catch (PersistenceException e) {
            em.getTransaction().rollback();
            throw new MailboxException("Unable to retrieve last uid for mailbox " + mailbox);
        }
        finally {
            if (em.isOpen()) {
                em.close();
            }
        }
    }
}

