/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.jpa;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import javax.mail.Flags;
import org.apache.james.mailbox.MailboxException;
import org.apache.james.mailbox.jpa.JPAMailboxSessionMapperFactory;
import org.apache.james.mailbox.jpa.mail.model.JPAHeader;
import org.apache.james.mailbox.jpa.mail.model.openjpa.JPAMailboxMembership;
import org.apache.james.mailbox.store.MapperStoreMessageManager;
import org.apache.james.mailbox.store.MessageMapperFactory;
import org.apache.james.mailbox.store.mail.model.Header;
import org.apache.james.mailbox.store.mail.model.Mailbox;
import org.apache.james.mailbox.store.mail.model.MailboxMembership;
import org.apache.james.mailbox.store.mail.model.PropertyBuilder;
import org.apache.james.mailbox.util.MailboxEventDispatcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JPAMessageManager
extends MapperStoreMessageManager<Long> {
    public JPAMessageManager(JPAMailboxSessionMapperFactory mapperFactory, AtomicLong lastUid, MailboxEventDispatcher dispatcher, Mailbox<Long> mailbox) throws MailboxException {
        super((MessageMapperFactory)mapperFactory, lastUid, dispatcher, mailbox);
    }

    protected MailboxMembership<Long> createMessage(Date internalDate, int size, int bodyStartOctet, InputStream document, Flags flags, List<Header> headers, PropertyBuilder propertyBuilder) throws MailboxException {
        ArrayList<JPAHeader> jpaHeaders = new ArrayList<JPAHeader>(headers.size());
        for (Header header : headers) {
            jpaHeaders.add((JPAHeader)header);
        }
        JPAMailboxMembership message = new JPAMailboxMembership((Long)this.getMailboxEntity().getMailboxId(), internalDate, size, flags, document, bodyStartOctet, jpaHeaders, propertyBuilder);
        return message;
    }

    protected Header createHeader(int lineNumber, String name, String value) {
        JPAHeader header = new JPAHeader(lineNumber, name, value);
        return header;
    }
}

