/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.jpa.mail.model.openjpa;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.MappedSuperclass;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import org.apache.james.mailbox.jpa.mail.model.JPAHeader;
import org.apache.james.mailbox.jpa.mail.model.JPAProperty;
import org.apache.james.mailbox.store.mail.model.AbstractMessage;
import org.apache.james.mailbox.store.mail.model.Header;
import org.apache.james.mailbox.store.mail.model.Message;
import org.apache.james.mailbox.store.mail.model.Property;
import org.apache.james.mailbox.store.mail.model.PropertyBuilder;
import org.apache.openjpa.enhance.FieldConsumer;
import org.apache.openjpa.enhance.FieldSupplier;
import org.apache.openjpa.enhance.PCRegistry;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.enhance.RedefinitionHelper;
import org.apache.openjpa.enhance.StateManager;
import org.apache.openjpa.persistence.jdbc.ElementJoinColumn;
import org.apache.openjpa.util.InternalException;
import org.apache.openjpa.util.LongId;
import org.apache.openjpa.util.UserException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@MappedSuperclass
public abstract class AbstractJPAMessage
extends AbstractMessage
implements PersistenceCapable {
    @Id
    @GeneratedValue
    private long id;
    @OneToMany(cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    @ElementJoinColumn(name="MESSAGE_ID")
    private List<JPAHeader> headers;
    @Basic(optional=false)
    private int bodyStartOctet;
    @Basic(optional=false)
    private long contentOctets;
    @Basic(optional=true)
    private String mediaType;
    @Basic(optional=true)
    private String subType;
    @OneToMany(cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    @OrderBy(value="line")
    @ElementJoinColumn(name="MESSAGE_ID")
    private List<JPAProperty> properties;
    @Basic(optional=true)
    private Long textualLineCount;
    private static int pcInheritedFieldCount;
    private static String[] pcFieldNames;
    private static Class[] pcFieldTypes;
    private static byte[] pcFieldFlags;
    private static Class pcPCSuperclass;
    protected transient StateManager pcStateManager;
    static /* synthetic */ Class class$Ljava$util$List;
    static /* synthetic */ Class class$Ljava$lang$String;
    static /* synthetic */ Class class$Ljava$lang$Long;
    static /* synthetic */ Class class$Lorg$apache$james$mailbox$jpa$mail$model$openjpa$AbstractJPAMessage;
    private transient Object pcDetachedState;

    @Deprecated
    public AbstractJPAMessage() {
    }

    public AbstractJPAMessage(long contentOctets, int bodyStartOctet, List<JPAHeader> headers, PropertyBuilder propertyBuilder) {
        this.contentOctets = contentOctets;
        this.bodyStartOctet = bodyStartOctet;
        this.headers = new ArrayList<JPAHeader>(headers);
        this.textualLineCount = propertyBuilder.getTextualLineCount();
        this.mediaType = propertyBuilder.getMediaType();
        this.subType = propertyBuilder.getSubType();
        List properties = propertyBuilder.toProperties();
        this.properties = new ArrayList<JPAProperty>(properties.size());
        int order = 0;
        for (Property property : properties) {
            this.properties.add(new JPAProperty(property, order++));
        }
    }

    public AbstractJPAMessage(Message message) {
        this.contentOctets = message.getFullContentOctets();
        this.bodyStartOctet = (int)(message.getFullContentOctets() - message.getBodyOctets());
        this.headers = new ArrayList<JPAHeader>();
        List originalHeaders = message.getHeaders();
        for (int i = 0; i < originalHeaders.size(); ++i) {
            this.headers.add(new JPAHeader((Header)originalHeaders.get(i)));
        }
        PropertyBuilder pBuilder = new PropertyBuilder(message.getProperties());
        this.textualLineCount = pBuilder.getTextualLineCount();
        this.mediaType = pBuilder.getMediaType();
        this.subType = pBuilder.getSubType();
        List properties = pBuilder.toProperties();
        this.properties = new ArrayList<JPAProperty>(properties.size());
        int order = 0;
        for (Property property : properties) {
            this.properties.add(new JPAProperty(property, order++));
        }
    }

    public List<Header> getHeaders() {
        return new ArrayList<Header>(AbstractJPAMessage.pcGetheaders(this));
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + (int)(AbstractJPAMessage.pcGetid(this) ^ AbstractJPAMessage.pcGetid(this) >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        AbstractJPAMessage other = (AbstractJPAMessage)((Object)obj);
        return AbstractJPAMessage.pcGetid(this) == AbstractJPAMessage.pcGetid(other);
    }

    public String toString() {
        String retValue = "message(id = " + AbstractJPAMessage.pcGetid(this) + " )";
        return retValue;
    }

    public String getMediaType() {
        return AbstractJPAMessage.pcGetmediaType(this);
    }

    public String getSubType() {
        return AbstractJPAMessage.pcGetsubType(this);
    }

    public List<Property> getProperties() {
        return new ArrayList<Property>(AbstractJPAMessage.pcGetproperties(this));
    }

    public Long getTextualLineCount() {
        return AbstractJPAMessage.pcGettextualLineCount(this);
    }

    public long getFullContentOctets() {
        return AbstractJPAMessage.pcGetcontentOctets(this);
    }

    protected int getBodyStartOctet() {
        return AbstractJPAMessage.pcGetbodyStartOctet(this);
    }

    public int pcGetEnhancementContractVersion() {
        return 2;
    }

    static {
        pcFieldNames = new String[]{"bodyStartOctet", "contentOctets", "headers", "id", "mediaType", "properties", "subType", "textualLineCount"};
        Class[] classArray = new Class[8];
        classArray[0] = Integer.TYPE;
        classArray[1] = Long.TYPE;
        Class clazz = class$Ljava$util$List != null ? class$Ljava$util$List : (class$Ljava$util$List = AbstractJPAMessage.class$("java.util.List"));
        classArray[2] = clazz;
        classArray[3] = Long.TYPE;
        Class clazz2 = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = AbstractJPAMessage.class$("java.lang.String"));
        classArray[4] = clazz2;
        classArray[5] = class$Ljava$util$List != null ? class$Ljava$util$List : (class$Ljava$util$List = AbstractJPAMessage.class$("java.util.List"));
        classArray[6] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = AbstractJPAMessage.class$("java.lang.String"));
        Class clazz3 = class$Ljava$lang$Long != null ? class$Ljava$lang$Long : (class$Ljava$lang$Long = AbstractJPAMessage.class$("java.lang.Long"));
        classArray[7] = clazz3;
        pcFieldTypes = classArray;
        pcFieldFlags = new byte[]{26, 26, 5, 26, 26, 5, 26, 26};
        Class clazz4 = class$Lorg$apache$james$mailbox$jpa$mail$model$openjpa$AbstractJPAMessage != null ? class$Lorg$apache$james$mailbox$jpa$mail$model$openjpa$AbstractJPAMessage : (class$Lorg$apache$james$mailbox$jpa$mail$model$openjpa$AbstractJPAMessage = AbstractJPAMessage.class$("org.apache.james.mailbox.jpa.mail.model.openjpa.AbstractJPAMessage"));
        PCRegistry.register((Class)clazz4, (String[])pcFieldNames, (Class[])pcFieldTypes, (byte[])pcFieldFlags, (Class)pcPCSuperclass, (String)"AbstractJPAMessage", null);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected void pcClearFields() {
        this.bodyStartOctet = 0;
        this.contentOctets = 0L;
        this.headers = null;
        this.id = 0L;
        this.mediaType = null;
        this.properties = null;
        this.subType = null;
        this.textualLineCount = null;
    }

    public PersistenceCapable pcNewInstance(StateManager stateManager, Object object, boolean bl) {
        throw new UserException();
    }

    public PersistenceCapable pcNewInstance(StateManager stateManager, boolean bl) {
        throw new UserException();
    }

    protected static int pcGetManagedFieldCount() {
        return 8;
    }

    public void pcReplaceField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        switch (n2) {
            case 0: {
                this.bodyStartOctet = this.pcStateManager.replaceIntField((PersistenceCapable)this, n);
                return;
            }
            case 1: {
                this.contentOctets = this.pcStateManager.replaceLongField((PersistenceCapable)this, n);
                return;
            }
            case 2: {
                this.headers = (List)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 3: {
                this.id = this.pcStateManager.replaceLongField((PersistenceCapable)this, n);
                return;
            }
            case 4: {
                this.mediaType = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 5: {
                this.properties = (List)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 6: {
                this.subType = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 7: {
                this.textualLineCount = (Long)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    public void pcReplaceFields(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            this.pcReplaceField(nArray[n]);
            ++n;
        }
    }

    public void pcProvideField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        switch (n2) {
            case 0: {
                this.pcStateManager.providedIntField((PersistenceCapable)this, n, this.bodyStartOctet);
                return;
            }
            case 1: {
                this.pcStateManager.providedLongField((PersistenceCapable)this, n, this.contentOctets);
                return;
            }
            case 2: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, this.headers);
                return;
            }
            case 3: {
                this.pcStateManager.providedLongField((PersistenceCapable)this, n, this.id);
                return;
            }
            case 4: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.mediaType);
                return;
            }
            case 5: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, this.properties);
                return;
            }
            case 6: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.subType);
                return;
            }
            case 7: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.textualLineCount);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    public void pcProvideFields(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            this.pcProvideField(nArray[n]);
            ++n;
        }
    }

    protected void pcCopyField(AbstractJPAMessage abstractJPAMessage, int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        switch (n2) {
            case 0: {
                this.bodyStartOctet = abstractJPAMessage.bodyStartOctet;
                return;
            }
            case 1: {
                this.contentOctets = abstractJPAMessage.contentOctets;
                return;
            }
            case 2: {
                this.headers = abstractJPAMessage.headers;
                return;
            }
            case 3: {
                this.id = abstractJPAMessage.id;
                return;
            }
            case 4: {
                this.mediaType = abstractJPAMessage.mediaType;
                return;
            }
            case 5: {
                this.properties = abstractJPAMessage.properties;
                return;
            }
            case 6: {
                this.subType = abstractJPAMessage.subType;
                return;
            }
            case 7: {
                this.textualLineCount = abstractJPAMessage.textualLineCount;
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    public void pcCopyFields(Object object, int[] nArray) {
        AbstractJPAMessage abstractJPAMessage = (AbstractJPAMessage)((Object)object);
        if (abstractJPAMessage.pcStateManager != this.pcStateManager) {
            throw new IllegalArgumentException();
        }
        if (this.pcStateManager == null) {
            throw new IllegalStateException();
        }
        int n = 0;
        while (n < nArray.length) {
            this.pcCopyField(abstractJPAMessage, nArray[n]);
            ++n;
        }
    }

    public Object pcGetGenericContext() {
        if (this.pcStateManager == null) {
            return null;
        }
        return this.pcStateManager.getGenericContext();
    }

    public Object pcFetchObjectId() {
        if (this.pcStateManager == null) {
            return null;
        }
        return this.pcStateManager.fetchObjectId();
    }

    public boolean pcIsDeleted() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isDeleted();
    }

    public boolean pcIsDirty() {
        if (this.pcStateManager == null) {
            return false;
        }
        StateManager stateManager = this.pcStateManager;
        RedefinitionHelper.dirtyCheck((StateManager)stateManager);
        return stateManager.isDirty();
    }

    public boolean pcIsNew() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isNew();
    }

    public boolean pcIsPersistent() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isPersistent();
    }

    public boolean pcIsTransactional() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isTransactional();
    }

    public boolean pcSerializing() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.serializing();
    }

    public void pcDirty(String string) {
        if (this.pcStateManager == null) {
            return;
        }
        this.pcStateManager.dirty(string);
    }

    public StateManager pcGetStateManager() {
        return this.pcStateManager;
    }

    public Object pcGetVersion() {
        if (this.pcStateManager == null) {
            return null;
        }
        return this.pcStateManager.getVersion();
    }

    public synchronized void pcReplaceStateManager(StateManager stateManager) throws SecurityException {
        if (this.pcStateManager != null) {
            this.pcStateManager = this.pcStateManager.replaceStateManager(stateManager);
            return;
        }
        this.pcStateManager = stateManager;
    }

    public void pcCopyKeyFieldsToObjectId(FieldSupplier fieldSupplier, Object object) {
        throw new InternalException();
    }

    public void pcCopyKeyFieldsToObjectId(Object object) {
        throw new InternalException();
    }

    public void pcCopyKeyFieldsFromObjectId(FieldConsumer fieldConsumer, Object object) {
        LongId longId = (LongId)object;
        fieldConsumer.storeLongField(3 + pcInheritedFieldCount, longId.getId());
    }

    public void pcCopyKeyFieldsFromObjectId(Object object) {
        LongId longId = (LongId)object;
        this.id = longId.getId();
    }

    public Class pcGetIDOwningClass() {
        Class clazz = class$Lorg$apache$james$mailbox$jpa$mail$model$openjpa$AbstractJPAMessage != null ? class$Lorg$apache$james$mailbox$jpa$mail$model$openjpa$AbstractJPAMessage : (class$Lorg$apache$james$mailbox$jpa$mail$model$openjpa$AbstractJPAMessage = AbstractJPAMessage.class$("org.apache.james.mailbox.jpa.mail.model.openjpa.AbstractJPAMessage"));
        return clazz;
    }

    public Object pcNewObjectIdInstance(Object object) {
        return new LongId(this.pcGetIDOwningClass(), (String)object);
    }

    public Object pcNewObjectIdInstance() {
        return new LongId(this.pcGetIDOwningClass(), this.id);
    }

    private static final int pcGetbodyStartOctet(AbstractJPAMessage abstractJPAMessage) {
        if (abstractJPAMessage.pcStateManager == null) {
            return abstractJPAMessage.bodyStartOctet;
        }
        int n = pcInheritedFieldCount + 0;
        abstractJPAMessage.pcStateManager.accessingField(n);
        return abstractJPAMessage.bodyStartOctet;
    }

    private static final void pcSetbodyStartOctet(AbstractJPAMessage abstractJPAMessage, int n) {
        if (abstractJPAMessage.pcStateManager == null) {
            abstractJPAMessage.bodyStartOctet = n;
            return;
        }
        abstractJPAMessage.pcStateManager.settingIntField((PersistenceCapable)abstractJPAMessage, pcInheritedFieldCount + 0, abstractJPAMessage.bodyStartOctet, n, 0);
    }

    private static final long pcGetcontentOctets(AbstractJPAMessage abstractJPAMessage) {
        if (abstractJPAMessage.pcStateManager == null) {
            return abstractJPAMessage.contentOctets;
        }
        int n = pcInheritedFieldCount + 1;
        abstractJPAMessage.pcStateManager.accessingField(n);
        return abstractJPAMessage.contentOctets;
    }

    private static final void pcSetcontentOctets(AbstractJPAMessage abstractJPAMessage, long l) {
        if (abstractJPAMessage.pcStateManager == null) {
            abstractJPAMessage.contentOctets = l;
            return;
        }
        abstractJPAMessage.pcStateManager.settingLongField((PersistenceCapable)abstractJPAMessage, pcInheritedFieldCount + 1, abstractJPAMessage.contentOctets, l, 0);
    }

    private static final List pcGetheaders(AbstractJPAMessage abstractJPAMessage) {
        if (abstractJPAMessage.pcStateManager == null) {
            return abstractJPAMessage.headers;
        }
        int n = pcInheritedFieldCount + 2;
        abstractJPAMessage.pcStateManager.accessingField(n);
        return abstractJPAMessage.headers;
    }

    private static final void pcSetheaders(AbstractJPAMessage abstractJPAMessage, List list) {
        if (abstractJPAMessage.pcStateManager == null) {
            abstractJPAMessage.headers = list;
            return;
        }
        abstractJPAMessage.pcStateManager.settingObjectField((PersistenceCapable)abstractJPAMessage, pcInheritedFieldCount + 2, abstractJPAMessage.headers, (Object)list, 0);
    }

    private static final long pcGetid(AbstractJPAMessage abstractJPAMessage) {
        if (abstractJPAMessage.pcStateManager == null) {
            return abstractJPAMessage.id;
        }
        int n = pcInheritedFieldCount + 3;
        abstractJPAMessage.pcStateManager.accessingField(n);
        return abstractJPAMessage.id;
    }

    private static final void pcSetid(AbstractJPAMessage abstractJPAMessage, long l) {
        if (abstractJPAMessage.pcStateManager == null) {
            abstractJPAMessage.id = l;
            return;
        }
        abstractJPAMessage.pcStateManager.settingLongField((PersistenceCapable)abstractJPAMessage, pcInheritedFieldCount + 3, abstractJPAMessage.id, l, 0);
    }

    private static final String pcGetmediaType(AbstractJPAMessage abstractJPAMessage) {
        if (abstractJPAMessage.pcStateManager == null) {
            return abstractJPAMessage.mediaType;
        }
        int n = pcInheritedFieldCount + 4;
        abstractJPAMessage.pcStateManager.accessingField(n);
        return abstractJPAMessage.mediaType;
    }

    private static final void pcSetmediaType(AbstractJPAMessage abstractJPAMessage, String string) {
        if (abstractJPAMessage.pcStateManager == null) {
            abstractJPAMessage.mediaType = string;
            return;
        }
        abstractJPAMessage.pcStateManager.settingStringField((PersistenceCapable)abstractJPAMessage, pcInheritedFieldCount + 4, abstractJPAMessage.mediaType, string, 0);
    }

    private static final List pcGetproperties(AbstractJPAMessage abstractJPAMessage) {
        if (abstractJPAMessage.pcStateManager == null) {
            return abstractJPAMessage.properties;
        }
        int n = pcInheritedFieldCount + 5;
        abstractJPAMessage.pcStateManager.accessingField(n);
        return abstractJPAMessage.properties;
    }

    private static final void pcSetproperties(AbstractJPAMessage abstractJPAMessage, List list) {
        if (abstractJPAMessage.pcStateManager == null) {
            abstractJPAMessage.properties = list;
            return;
        }
        abstractJPAMessage.pcStateManager.settingObjectField((PersistenceCapable)abstractJPAMessage, pcInheritedFieldCount + 5, abstractJPAMessage.properties, (Object)list, 0);
    }

    private static final String pcGetsubType(AbstractJPAMessage abstractJPAMessage) {
        if (abstractJPAMessage.pcStateManager == null) {
            return abstractJPAMessage.subType;
        }
        int n = pcInheritedFieldCount + 6;
        abstractJPAMessage.pcStateManager.accessingField(n);
        return abstractJPAMessage.subType;
    }

    private static final void pcSetsubType(AbstractJPAMessage abstractJPAMessage, String string) {
        if (abstractJPAMessage.pcStateManager == null) {
            abstractJPAMessage.subType = string;
            return;
        }
        abstractJPAMessage.pcStateManager.settingStringField((PersistenceCapable)abstractJPAMessage, pcInheritedFieldCount + 6, abstractJPAMessage.subType, string, 0);
    }

    private static final Long pcGettextualLineCount(AbstractJPAMessage abstractJPAMessage) {
        if (abstractJPAMessage.pcStateManager == null) {
            return abstractJPAMessage.textualLineCount;
        }
        int n = pcInheritedFieldCount + 7;
        abstractJPAMessage.pcStateManager.accessingField(n);
        return abstractJPAMessage.textualLineCount;
    }

    private static final void pcSettextualLineCount(AbstractJPAMessage abstractJPAMessage, Long l) {
        if (abstractJPAMessage.pcStateManager == null) {
            abstractJPAMessage.textualLineCount = l;
            return;
        }
        abstractJPAMessage.pcStateManager.settingObjectField((PersistenceCapable)abstractJPAMessage, pcInheritedFieldCount + 7, (Object)abstractJPAMessage.textualLineCount, (Object)l, 0);
    }

    public Boolean pcIsDetached() {
        if (this.pcStateManager != null) {
            if (this.pcStateManager.isDetached()) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        if (this.pcGetDetachedState() != null && this.pcGetDetachedState() != PersistenceCapable.DESERIALIZED) {
            return Boolean.TRUE;
        }
        if (this.id != 0L) {
            return Boolean.TRUE;
        }
        if (!this.pcisDetachedStateDefinitive()) {
            return null;
        }
        return Boolean.FALSE;
    }

    private boolean pcisDetachedStateDefinitive() {
        return false;
    }

    public Object pcGetDetachedState() {
        return this.pcDetachedState;
    }

    public void pcSetDetachedState(Object object) {
        this.pcDetachedState = object;
    }
}

