/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.jpa.mail;

import java.util.Iterator;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.LockModeType;
import javax.persistence.PersistenceException;
import javax.persistence.Query;
import org.apache.james.mailbox.MailboxException;
import org.apache.james.mailbox.MessageRange;
import org.apache.james.mailbox.SearchQuery;
import org.apache.james.mailbox.jpa.JPATransactionalMapper;
import org.apache.james.mailbox.jpa.mail.model.JPAMailbox;
import org.apache.james.mailbox.jpa.mail.model.openjpa.AbstractJPAMailboxMembership;
import org.apache.james.mailbox.jpa.mail.model.openjpa.JPAMailboxMembership;
import org.apache.james.mailbox.jpa.mail.model.openjpa.JPAStreamingMailboxMembership;
import org.apache.james.mailbox.store.SearchQueryIterator;
import org.apache.james.mailbox.store.mail.MessageMapper;
import org.apache.james.mailbox.store.mail.model.Mailbox;
import org.apache.james.mailbox.store.mail.model.MailboxMembership;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JPAMessageMapper
extends JPATransactionalMapper
implements MessageMapper<Long> {
    public JPAMessageMapper(EntityManagerFactory entityManagerFactory) {
        super(entityManagerFactory);
    }

    public List<MailboxMembership<Long>> findInMailbox(Mailbox<Long> mailbox, MessageRange set) throws MailboxException {
        try {
            List<MailboxMembership<Long>> results;
            long from = set.getUidFrom();
            long to = set.getUidTo();
            MessageRange.Type type = set.getType();
            switch (type) {
                default: {
                    results = this.findMessagesInMailbox(mailbox);
                    break;
                }
                case FROM: {
                    results = this.findMessagesInMailboxAfterUID(mailbox, from);
                    break;
                }
                case ONE: {
                    results = this.findMessagesInMailboxWithUID(mailbox, from);
                    break;
                }
                case RANGE: {
                    results = this.findMessagesInMailboxBetweenUIDs(mailbox, from, to);
                }
            }
            return results;
        }
        catch (PersistenceException e) {
            throw new MailboxException("Search of MessageRange " + set + " failed in mailbox " + mailbox, (Exception)((Object)e));
        }
    }

    private List<MailboxMembership<Long>> findMessagesInMailboxAfterUID(Mailbox<Long> mailbox, long uid) {
        return this.getEntityManager().createNamedQuery("findMessagesInMailboxAfterUID").setParameter("idParam", mailbox.getMailboxId()).setParameter("uidParam", (Object)uid).getResultList();
    }

    private List<MailboxMembership<Long>> findMessagesInMailboxWithUID(Mailbox<Long> mailbox, long uid) {
        return this.getEntityManager().createNamedQuery("findMessagesInMailboxWithUID").setParameter("idParam", mailbox.getMailboxId()).setParameter("uidParam", (Object)uid).setMaxResults(1).getResultList();
    }

    private List<MailboxMembership<Long>> findMessagesInMailboxBetweenUIDs(Mailbox<Long> mailbox, long from, long to) {
        return this.getEntityManager().createNamedQuery("findMessagesInMailboxBetweenUIDs").setParameter("idParam", mailbox.getMailboxId()).setParameter("fromParam", (Object)from).setParameter("toParam", (Object)to).getResultList();
    }

    private List<MailboxMembership<Long>> findMessagesInMailbox(Mailbox<Long> mailbox) {
        return this.getEntityManager().createNamedQuery("findMessagesInMailbox").setParameter("idParam", mailbox.getMailboxId()).getResultList();
    }

    public List<MailboxMembership<Long>> findMarkedForDeletionInMailbox(Mailbox<Long> mailbox, MessageRange set) throws MailboxException {
        try {
            List<MailboxMembership<Long>> results;
            long from = set.getUidFrom();
            long to = set.getUidTo();
            switch (set.getType()) {
                case ONE: {
                    results = this.findDeletedMessagesInMailboxWithUID(mailbox, from);
                    break;
                }
                case RANGE: {
                    results = this.findDeletedMessagesInMailboxBetweenUIDs(mailbox, from, to);
                    break;
                }
                case FROM: {
                    results = this.findDeletedMessagesInMailboxAfterUID(mailbox, from);
                    break;
                }
                default: {
                    results = this.findDeletedMessagesInMailbox(mailbox);
                }
            }
            return results;
        }
        catch (PersistenceException e) {
            throw new MailboxException("Search of MessageRange " + set + " failed in mailbox " + mailbox, (Exception)((Object)e));
        }
    }

    private List<MailboxMembership<Long>> findDeletedMessagesInMailbox(Mailbox<Long> mailbox) {
        return this.getEntityManager().createNamedQuery("findDeletedMessagesInMailbox").setParameter("idParam", mailbox.getMailboxId()).getResultList();
    }

    private List<MailboxMembership<Long>> findDeletedMessagesInMailboxAfterUID(Mailbox<Long> mailbox, long uid) {
        return this.getEntityManager().createNamedQuery("findDeletedMessagesInMailboxAfterUID").setParameter("idParam", mailbox.getMailboxId()).setParameter("uidParam", (Object)uid).getResultList();
    }

    private List<MailboxMembership<Long>> findDeletedMessagesInMailboxWithUID(Mailbox<Long> mailbox, long uid) {
        return this.getEntityManager().createNamedQuery("findDeletedMessagesInMailboxWithUID").setParameter("idParam", mailbox.getMailboxId()).setParameter("uidParam", (Object)uid).setMaxResults(1).getResultList();
    }

    private List<MailboxMembership<Long>> findDeletedMessagesInMailboxBetweenUIDs(Mailbox<Long> mailbox, long from, long to) {
        return this.getEntityManager().createNamedQuery("findDeletedMessagesInMailboxBetweenUIDs").setParameter("idParam", mailbox.getMailboxId()).setParameter("fromParam", (Object)from).setParameter("toParam", (Object)to).getResultList();
    }

    public long countMessagesInMailbox(Mailbox<Long> mailbox) throws MailboxException {
        try {
            return (Long)this.getEntityManager().createNamedQuery("countMessagesInMailbox").setParameter("idParam", mailbox.getMailboxId()).getSingleResult();
        }
        catch (PersistenceException e) {
            throw new MailboxException("Count of messages failed in mailbox " + mailbox, (Exception)((Object)e));
        }
    }

    public long countUnseenMessagesInMailbox(Mailbox<Long> mailbox) throws MailboxException {
        try {
            return (Long)this.getEntityManager().createNamedQuery("countUnseenMessagesInMailbox").setParameter("idParam", mailbox.getMailboxId()).getSingleResult();
        }
        catch (PersistenceException e) {
            throw new MailboxException("Count of useen messages failed in mailbox " + mailbox, (Exception)((Object)e));
        }
    }

    public Iterator<Long> searchMailbox(Mailbox<Long> mailbox, SearchQuery query) throws MailboxException {
        try {
            SearchQuery.Criterion firstCriterion;
            StringBuilder queryBuilder = new StringBuilder(50);
            queryBuilder.append("SELECT membership FROM Membership membership WHERE membership.mailboxId = ").append(mailbox.getMailboxId());
            List criteria = query.getCriterias();
            boolean range = false;
            int rangeLength = -1;
            if (criteria.size() == 1 && (firstCriterion = (SearchQuery.Criterion)criteria.get(0)) instanceof SearchQuery.UidCriterion) {
                SearchQuery.UidCriterion uidCriterion = (SearchQuery.UidCriterion)firstCriterion;
                SearchQuery.NumericRange[] ranges = uidCriterion.getOperator().getRange();
                rangeLength = ranges.length;
                for (int i = 0; i < ranges.length; ++i) {
                    long low = ranges[i].getLowValue();
                    long high = ranges[i].getHighValue();
                    if (low == Long.MAX_VALUE) {
                        queryBuilder.append(" AND membership.uid<=").append(high);
                        range = true;
                        continue;
                    }
                    if (low == high) {
                        queryBuilder.append(" AND membership.uid=").append(low);
                        range = false;
                        continue;
                    }
                    queryBuilder.append(" AND membership.uid BETWEEN ").append(low).append(" AND ").append(high);
                    range = true;
                }
            }
            if (rangeLength != 0 || range) {
                queryBuilder.append(" order by membership.uid");
            }
            Query jQuery = this.getEntityManager().createQuery(queryBuilder.toString());
            if (rangeLength == 1 && !range) {
                jQuery.setMaxResults(1);
            }
            return new SearchQueryIterator(jQuery.getResultList().iterator(), query);
        }
        catch (PersistenceException e) {
            throw new MailboxException("Search of messages via the query " + query + " failed in mailbox " + mailbox, (Exception)((Object)e));
        }
    }

    public void delete(Mailbox<Long> mailbox, MailboxMembership<Long> message) throws MailboxException {
        try {
            this.getEntityManager().remove(message);
        }
        catch (PersistenceException e) {
            throw new MailboxException("Delete of message " + message + " failed in mailbox " + mailbox, (Exception)((Object)e));
        }
    }

    public Long findFirstUnseenMessageUid(Mailbox<Long> mailbox) throws MailboxException {
        try {
            Query query = this.getEntityManager().createNamedQuery("findUnseenMessagesInMailboxOrderByUid").setParameter("idParam", mailbox.getMailboxId());
            query.setMaxResults(1);
            List result = query.getResultList();
            if (result.isEmpty()) {
                return null;
            }
            return ((MailboxMembership)result.get(0)).getUid();
        }
        catch (PersistenceException e) {
            throw new MailboxException("Search of first unseen message failed in mailbox " + mailbox, (Exception)((Object)e));
        }
    }

    public List<MailboxMembership<Long>> findRecentMessagesInMailbox(Mailbox<Long> mailbox, int limit) throws MailboxException {
        try {
            Query query = this.getEntityManager().createNamedQuery("findRecentMessagesInMailbox").setParameter("idParam", mailbox.getMailboxId());
            if (limit > 0) {
                query = query.setMaxResults(limit);
            }
            return query.getResultList();
        }
        catch (PersistenceException e) {
            throw new MailboxException("Search of recent messages failed in mailbox " + mailbox, (Exception)((Object)e));
        }
    }

    public long save(Mailbox<Long> mailbox, MailboxMembership<Long> message) throws MailboxException {
        try {
            if (message.getUid() == 0L) {
                ((AbstractJPAMailboxMembership)message).setUid(this.reserveUid((JPAMailbox)mailbox));
            }
            this.getEntityManager().persist(message);
            return message.getUid();
        }
        catch (PersistenceException e) {
            throw new MailboxException("Save of message " + message + " failed in mailbox " + mailbox, (Exception)((Object)e));
        }
    }

    public long copy(Mailbox<Long> mailbox, MailboxMembership<Long> original) throws MailboxException {
        AbstractJPAMailboxMembership copy = original instanceof JPAStreamingMailboxMembership ? new JPAStreamingMailboxMembership((Long)mailbox.getMailboxId(), (MailboxMembership<?>)((AbstractJPAMailboxMembership)original)) : new JPAMailboxMembership((long)((Long)mailbox.getMailboxId()), (AbstractJPAMailboxMembership)original);
        return this.save(mailbox, (MailboxMembership<Long>)copy);
    }

    protected long reserveUid(JPAMailbox mailbox) {
        EntityManager manager = this.getEntityManager();
        JPAMailbox m = (JPAMailbox)manager.find(JPAMailbox.class, (Object)mailbox.getMailboxId(), LockModeType.PESSIMISTIC_WRITE);
        manager.refresh((Object)m);
        m.consumeUid();
        manager.persist((Object)m);
        return m.getLastUid();
    }
}

