/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.jpa;

import org.apache.james.mailbox.MailboxException;
import org.apache.james.mailbox.MailboxPath;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.jpa.JPAMailboxSessionMapperFactory;
import org.apache.james.mailbox.jpa.mail.model.JPAMailbox;
import org.apache.james.mailbox.jpa.user.model.JPASubscription;
import org.apache.james.mailbox.store.Authenticator;
import org.apache.james.mailbox.store.MailboxSessionMapperFactory;
import org.apache.james.mailbox.store.StoreMailboxManager;
import org.apache.james.mailbox.store.mail.MailboxMapper;
import org.apache.james.mailbox.store.transaction.Mapper;
import org.apache.james.mailbox.store.user.model.Subscription;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JPAMailboxManager
extends StoreMailboxManager<Long> {
    public JPAMailboxManager(JPAMailboxSessionMapperFactory mailboxSessionMapperFactory, Authenticator authenticator) {
        super((MailboxSessionMapperFactory)mailboxSessionMapperFactory, authenticator);
    }

    protected void doCreateMailbox(MailboxPath path, MailboxSession session) throws MailboxException {
        final JPAMailbox mailbox = new JPAMailbox(path, this.randomUidValidity());
        final MailboxMapper mapper = this.mailboxSessionMapperFactory.getMailboxMapper(session);
        mapper.execute((Mapper.Transaction)new Mapper.VoidTransaction(){

            public void runVoid() throws MailboxException {
                mapper.save(mailbox);
            }
        });
    }

    public void deleteEverything(MailboxSession mailboxSession) throws MailboxException {
        final MailboxMapper mapper = this.mailboxSessionMapperFactory.getMailboxMapper(mailboxSession);
        mapper.execute((Mapper.Transaction)new Mapper.VoidTransaction(){

            public void runVoid() throws MailboxException {
                mapper.deleteAll();
            }
        });
    }

    protected Subscription createSubscription(MailboxSession session, String mailbox) {
        JPASubscription newSubscription = new JPASubscription(session.getUser().getUserName(), mailbox);
        return newSubscription;
    }
}

