/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jsieve.util;

import java.io.IOException;
import org.apache.jsieve.util.HaltTraversalException;
import org.apache.jsieve.util.SieveHandler;

public class SieveToXml {
    public static final String DEFAULT_NAME_ATTRIBUTE = "name";
    public static final String DEFAULT_NAME_ACTION_COMMAND = "action";
    public static final String DEFAULT_NAME_CONTROL_COMMAND = "control";
    public static final String DEFAULT_NAME_TEST = "test";
    public static final String DEFAULT_NAME_LIST = "list";
    public static final String DEFAULT_NAME_NUM = "num";
    public static final String DEFAULT_NAME_TAG = "tag";
    public static final String DEFAULT_NAME_STRING = "str";
    public static final String DEFAULT_PREFIX = "sieve";
    public static final String DEFAULT_NAMESPACE = "urn:ietf:params:xml:ns:sieve";
    public static final String[] CONTROL_COMMANDS = new String[]{"If", "Require", "Stop"};
    private String namespaceUri = "urn:ietf:params:xml:ns:sieve";
    private String namespacePrefix = "sieve";
    private String stringElementName = "str";
    private String tagElementName = "tag";
    private String numberElementName = "num";
    private String listElementName = "list";
    private String nameAttributeName = "name";
    private NameMapper commandNameMapper = SieveToXml.sieveInXmlMapper();
    private NameMapper testNameMapper = SieveToXml.uniformMapper("test");

    public static final NameMapper uniformMapper(final String elementLocalName) {
        return new NameMapper(){

            public String toElementName(String name) {
                return elementLocalName;
            }
        };
    }

    public static final NameMapper sieveInXmlMapper() {
        return new NameMapper(){

            public String toElementName(String name) {
                boolean isControlCommand = false;
                for (int i = 0; i < CONTROL_COMMANDS.length; ++i) {
                    if (!CONTROL_COMMANDS[i].equalsIgnoreCase(name)) continue;
                    isControlCommand = true;
                    break;
                }
                String result = isControlCommand ? SieveToXml.DEFAULT_NAME_CONTROL_COMMAND : SieveToXml.DEFAULT_NAME_ACTION_COMMAND;
                return result;
            }
        };
    }

    public NameMapper getCommandNameMapper() {
        return this.commandNameMapper;
    }

    public void setCommandNameMapper(NameMapper commandNameMapper) {
        this.commandNameMapper = commandNameMapper;
    }

    public String getListElementName() {
        return this.listElementName;
    }

    public void setListElementName(String listElementName) {
        this.listElementName = listElementName;
    }

    public String getNameAttributeName() {
        return this.nameAttributeName;
    }

    public void setNameAttributeName(String nameAttributeName) {
        this.nameAttributeName = nameAttributeName;
    }

    public String getNamespacePrefix() {
        return this.namespacePrefix;
    }

    public void setNamespacePrefix(String namespacePrefix) {
        this.namespacePrefix = namespacePrefix;
    }

    public String getNamespaceUri() {
        return this.namespaceUri;
    }

    public void setNamespaceUri(String namespaceUri) {
        this.namespaceUri = namespaceUri;
    }

    public String getNumberElementName() {
        return this.numberElementName;
    }

    public void setNumberElementName(String numberElementName) {
        this.numberElementName = numberElementName;
    }

    public String getStringElementName() {
        return this.stringElementName;
    }

    public void setStringElementName(String stringElementName) {
        this.stringElementName = stringElementName;
    }

    public String getTagElementName() {
        return this.tagElementName;
    }

    public void setTagElementName(String tagElementName) {
        this.tagElementName = tagElementName;
    }

    public NameMapper getTestNameMapper() {
        return this.testNameMapper;
    }

    public void setTestNameMapper(NameMapper testNameMapper) {
        this.testNameMapper = testNameMapper;
    }

    public SieveHandler build(Out out) {
        Worker worker = new Worker(this.nameAttributeName, this.namespaceUri, this.namespacePrefix, this.stringElementName, this.tagElementName, this.numberElementName, this.listElementName, this.commandNameMapper, this.testNameMapper, out);
        return worker;
    }

    private static final class Worker
    extends SieveHandler.Base {
        private final String nameAttributeName;
        private final String namespaceUri;
        private final String namespacePrefix;
        private final String stringElementName;
        private final String tagElementName;
        private final String numberElementName;
        private final String listElementName;
        private final NameMapper commandNameMapper;
        private final NameMapper testNameMapper;
        private final Out out;

        public Worker(String nameAttributeName, String namespaceUri, String namespacePrefix, String stringElementName, String tagElementName, String numberElementName, String listElementName, NameMapper commandNameMapper, NameMapper testNameMapper, Out out) {
            this.nameAttributeName = nameAttributeName;
            this.namespaceUri = namespaceUri;
            this.namespacePrefix = namespacePrefix;
            this.stringElementName = stringElementName;
            this.tagElementName = tagElementName;
            this.numberElementName = numberElementName;
            this.listElementName = listElementName;
            this.commandNameMapper = commandNameMapper;
            this.testNameMapper = testNameMapper;
            this.out = out;
        }

        public SieveHandler endCommand(String commandName) throws HaltTraversalException {
            return this.closeElement();
        }

        private SieveHandler closeElement() throws HaltTraversalException {
            try {
                this.out.closeElement();
                return this;
            }
            catch (IOException e) {
                throw new HaltTraversalException(e);
            }
        }

        public SieveHandler startCommand(String commandName) throws HaltTraversalException {
            try {
                this.out.openElement(this.commandNameMapper.toElementName(commandName), this.namespaceUri, this.namespacePrefix);
                this.nameAttribute(commandName);
                return this;
            }
            catch (IOException e) {
                throw new HaltTraversalException(e);
            }
        }

        public SieveHandler listMember(String string) throws HaltTraversalException {
            try {
                this.out.openElement(this.stringElementName, this.namespaceUri, this.namespacePrefix);
                this.out.content(string);
                this.out.closeElement();
                return this;
            }
            catch (IOException e) {
                throw new HaltTraversalException(e);
            }
        }

        public SieveHandler argument(int number) throws HaltTraversalException {
            try {
                this.out.openElement(this.numberElementName, this.namespaceUri, this.namespacePrefix);
                this.out.content(Integer.toString(number));
                this.out.closeElement();
                return this;
            }
            catch (IOException e) {
                throw new HaltTraversalException(e);
            }
        }

        public SieveHandler argument(String tag) throws HaltTraversalException {
            try {
                this.out.openElement(this.tagElementName, this.namespaceUri, this.namespacePrefix);
                this.out.content(tag);
                this.out.closeElement();
                return this;
            }
            catch (IOException e) {
                throw new HaltTraversalException(e);
            }
        }

        public SieveHandler endTest(String testName) throws HaltTraversalException {
            return this.closeElement();
        }

        public SieveHandler startTest(String testName) throws HaltTraversalException {
            try {
                this.out.openElement(this.testNameMapper.toElementName(testName), this.namespaceUri, this.namespacePrefix);
                this.nameAttribute(testName);
                return this;
            }
            catch (IOException e) {
                throw new HaltTraversalException(e);
            }
        }

        public SieveHandler endTestList() throws HaltTraversalException {
            return this.closeElement();
        }

        public SieveHandler startTestList() throws HaltTraversalException {
            try {
                this.out.openElement(this.listElementName, this.namespaceUri, this.namespacePrefix);
                return this;
            }
            catch (IOException e) {
                throw new HaltTraversalException(e);
            }
        }

        private void nameAttribute(String name) throws IOException {
            if (this.nameAttributeName != null) {
                this.out.attribute(this.nameAttributeName, this.namespaceUri, this.namespacePrefix, name);
            }
        }
    }

    public static interface NameMapper {
        public String toElementName(String var1);
    }

    public static interface Out {
        public void openElement(CharSequence var1, CharSequence var2, CharSequence var3) throws IOException;

        public void attribute(CharSequence var1, CharSequence var2, CharSequence var3, CharSequence var4) throws IOException;

        public void content(CharSequence var1) throws IOException;

        public void closeElement() throws IOException;
    }
}

