/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jsieve;

import java.util.concurrent.ConcurrentMap;
import org.apache.jsieve.CommandManager;
import org.apache.jsieve.ExecutableCommand;
import org.apache.jsieve.exception.LookupException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandManagerImpl
implements CommandManager {
    private final ConcurrentMap<String, String> classNameMap;

    public CommandManagerImpl(ConcurrentMap<String, String> classNameMap) {
        this.classNameMap = classNameMap;
    }

    private Class lookup(String name) throws LookupException {
        Class<?> cmdClass = null;
        try {
            cmdClass = this.getClass().getClassLoader().loadClass(this.getClassName(name));
        }
        catch (ClassNotFoundException e) {
            throw new LookupException("Command named '" + name + "' not found.");
        }
        if (!ExecutableCommand.class.isAssignableFrom(cmdClass)) {
            throw new LookupException("Class " + cmdClass.getName() + " must implement " + ExecutableCommand.class.getName());
        }
        return cmdClass;
    }

    @Override
    public ExecutableCommand getCommand(String name) throws LookupException {
        try {
            return (ExecutableCommand)this.lookup(name).newInstance();
        }
        catch (InstantiationException e) {
            throw new LookupException(e.getMessage());
        }
        catch (IllegalAccessException e) {
            throw new LookupException(e.getMessage());
        }
    }

    @Override
    public boolean isCommandSupported(String name) {
        boolean isSupported = false;
        try {
            this.lookup(name);
            isSupported = true;
        }
        catch (LookupException lookupException) {
            // empty catch block
        }
        return isSupported;
    }

    protected String getClassName(String name) throws LookupException {
        String className = (String)this.classNameMap.get(name.toLowerCase());
        if (null == className) {
            throw new LookupException("Command named '" + name + "' not mapped.");
        }
        return className;
    }
}

