/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jsieve.mailet;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.mail.Header;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.james.mime4j.field.address.AddressList;
import org.apache.james.mime4j.field.address.Mailbox;
import org.apache.james.mime4j.field.address.MailboxList;
import org.apache.james.mime4j.field.address.parser.ParseException;
import org.apache.jsieve.SieveContext;
import org.apache.jsieve.exception.InternetAddressException;
import org.apache.jsieve.exception.SieveException;
import org.apache.jsieve.mail.Action;
import org.apache.jsieve.mail.AddressImpl;
import org.apache.jsieve.mail.MailAdapter;
import org.apache.jsieve.mail.MailUtils;
import org.apache.jsieve.mail.SieveMailException;
import org.apache.jsieve.mail.optional.EnvelopeAccessors;
import org.apache.jsieve.mailet.ActionContext;
import org.apache.jsieve.mailet.ActionDispatcher;
import org.apache.jsieve.mailet.Poster;
import org.apache.mailet.Mail;
import org.apache.mailet.MailAddress;
import org.apache.mailet.MailetContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SieveMailAdapter
implements MailAdapter,
EnvelopeAccessors,
ActionContext {
    private static final Log LOG = LogFactory.getLog(SieveMailAdapter.class);
    private Log log = LOG;
    private Mail fieldMail;
    private MailetContext fieldMailetContext;
    private List<Action> fieldActions;
    private final ActionDispatcher dispatcher;
    private final Poster poster;
    private String contentText;

    public SieveMailAdapter(Mail aMail, MailetContext aMailetContext, ActionDispatcher dispatcher, Poster poster) {
        this.poster = poster;
        this.dispatcher = dispatcher;
        this.setMail(aMail);
        this.setMailetContext(aMailetContext);
    }

    public void setLog(Log log) {
        this.log = log;
    }

    protected MimeMessage getMessage() throws MessagingException {
        return this.getMail().getMessage();
    }

    public List<Action> getActions() {
        List<Action> actions = null;
        actions = this.getActionsBasic();
        if (null == actions) {
            this.updateActions();
            return this.getActions();
        }
        return actions;
    }

    protected List<Action> computeActions() {
        return new ArrayList<Action>();
    }

    private List<Action> getActionsBasic() {
        return this.fieldActions;
    }

    public void addAction(Action action) {
        this.getActions().add(action);
    }

    public void executeActions() throws SieveException {
        List<Action> actions = this.getActions();
        for (Action action : actions) {
            this.getMailetContext().log("Executing action: " + action.toString());
            try {
                this.dispatcher.execute(action, this.getMail(), this);
            }
            catch (MessagingException e) {
                throw new SieveException((Throwable)e);
            }
        }
    }

    protected void setActions(List<Action> actions) {
        this.fieldActions = actions;
    }

    protected void updateActions() {
        this.setActions(this.computeActions());
    }

    public List<String> getHeader(String name) throws SieveMailException {
        try {
            String[] headers = this.getMessage().getHeader(name);
            return headers == null ? new ArrayList(0) : Arrays.asList(headers);
        }
        catch (MessagingException ex) {
            throw new SieveMailException((Throwable)ex);
        }
    }

    public List<String> getHeaderNames() throws SieveMailException {
        HashSet<String> headerNames = new HashSet<String>();
        try {
            Enumeration allHeaders = this.getMessage().getAllHeaders();
            while (allHeaders.hasMoreElements()) {
                headerNames.add(((Header)allHeaders.nextElement()).getName());
            }
            return new ArrayList<String>(headerNames);
        }
        catch (MessagingException ex) {
            throw new SieveMailException((Throwable)ex);
        }
    }

    public List<String> getMatchingHeader(String name) throws SieveMailException {
        return MailUtils.getMatchingHeader((MailAdapter)this, (String)name);
    }

    public int getSize() throws SieveMailException {
        try {
            return this.getMessage().getSize();
        }
        catch (MessagingException ex) {
            throw new SieveMailException((Throwable)ex);
        }
    }

    protected Map<String, String> getEnvelopes() {
        HashMap<String, String> envelopes = new HashMap<String, String>(2);
        if (null != this.getEnvelopeFrom()) {
            envelopes.put("From", this.getEnvelopeFrom());
        }
        if (null != this.getEnvelopeTo()) {
            envelopes.put("To", this.getEnvelopeTo());
        }
        return envelopes;
    }

    public List<String> getEnvelope(String name) throws SieveMailException {
        ArrayList<String> values = new ArrayList<String>(1);
        String value = this.getEnvelopes().get(name);
        if (null != value) {
            values.add(value);
        }
        return values;
    }

    public List<String> getEnvelopeNames() throws SieveMailException {
        return new ArrayList<String>(this.getEnvelopes().keySet());
    }

    public List<String> getMatchingEnvelope(String name) throws SieveMailException {
        ArrayList<String> matchedEnvelopeValues = new ArrayList<String>(32);
        for (String envelopeName : this.getEnvelopeNames()) {
            if (!envelopeName.trim().equalsIgnoreCase(name)) continue;
            matchedEnvelopeValues.addAll(this.getEnvelope(envelopeName));
        }
        return matchedEnvelopeValues;
    }

    public String getEnvelopeFrom() {
        MailAddress sender = this.getMail().getSender();
        return null == sender ? "" : sender.toString();
    }

    public String getEnvelopeTo() {
        String recipient = null;
        Iterator recipientIter = this.getMail().getRecipients().iterator();
        if (recipientIter.hasNext()) {
            recipient = recipientIter.next().toString();
        }
        return recipient;
    }

    public Mail getMail() {
        return this.fieldMail;
    }

    protected void setMail(Mail mail) {
        this.fieldMail = mail;
        this.contentText = null;
    }

    public MailetContext getMailetContext() {
        return this.fieldMailetContext;
    }

    protected void setMailetContext(MailetContext mailetContext) {
        this.fieldMailetContext = mailetContext;
    }

    public String toString() {
        String messageID = null;
        try {
            messageID = this.getMail().getMessage().getMessageID();
        }
        catch (MessagingException e) {
            messageID = "<" + e.getMessage() + ">";
        }
        return this.getClass().getName() + " Envelope From: " + (null == this.getEnvelopeFrom() ? "null" : this.getEnvelopeFrom()) + " Envelope To: " + (null == this.getEnvelopeTo() ? "null" : this.getEnvelopeTo()) + " Message ID: " + (null == messageID ? "null" : messageID);
    }

    public String getContentType() throws SieveMailException {
        try {
            return this.getMessage().getContentType();
        }
        catch (MessagingException e) {
            throw new SieveMailException((Throwable)e);
        }
    }

    public MailAdapter.Address[] parseAddresses(String arg) throws SieveMailException, InternetAddressException {
        try {
            MailboxList list = AddressList.parse((String)arg).flatten();
            int size = list.size();
            MailAdapter.Address[] results = new MailAdapter.Address[size];
            for (int i = 0; i < size; ++i) {
                Mailbox mailbox = list.get(i);
                results[i] = new AddressImpl(mailbox.getLocalPart(), mailbox.getDomain());
            }
            return null;
        }
        catch (ParseException e) {
            throw new InternetAddressException((Throwable)e);
        }
    }

    @Override
    public Log getLog() {
        return this.log;
    }

    @Override
    public String getServerInfo() {
        return this.getMailetContext().getServerInfo();
    }

    @Override
    public void post(String uri, MimeMessage mail) throws MessagingException {
        this.poster.post(uri, mail);
    }

    public void post(MailAddress sender, Collection recipients, MimeMessage mail) throws MessagingException {
        this.getMailetContext().sendMail(sender, recipients, mail);
    }

    public boolean isInBodyText(String phraseCaseInsensitive) throws SieveMailException {
        try {
            if (this.contentText == null) {
                this.contentText = this.getMessage().getContent().toString().toLowerCase();
            }
            return this.contentText.contains(phraseCaseInsensitive);
        }
        catch (MessagingException e) {
            throw new SieveMailException((Throwable)e);
        }
        catch (IOException e) {
            throw new SieveMailException((Throwable)e);
        }
    }

    public void setContext(SieveContext context) {
    }
}

