/****************************************************************
 * Licensed to the Apache Software Foundation (ASF) under one   *
 * or more contributor license agreements.  See the NOTICE file *
 * distributed with this work for additional information        *
 * regarding copyright ownership.  The ASF licenses this file   *
 * to you under the Apache License, Version 2.0 (the            *
 * "License"); you may not use this file except in compliance   *
 * with the License.  You may obtain a copy of the License at   *
 *                                                              *
 *   http://www.apache.org/licenses/LICENSE-2.0                 *
 *                                                              *
 * Unless required by applicable law or agreed to in writing,   *
 * software distributed under the License is distributed on an  *
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY       *
 * KIND, either express or implied.  See the License for the    *
 * specific language governing permissions and limitations      *
 * under the License.                                           *
 ****************************************************************/
package org.apache.james.mailbox.torque.om.map;

import java.util.Date;

import org.apache.torque.Torque;
import org.apache.torque.TorqueException;
import org.apache.torque.map.DatabaseMap;
import org.apache.torque.map.MapBuilder;
import org.apache.torque.map.TableMap;

/**
 * This class was autogenerated by Torque on:
 * 
 * [Wed Sep 06 08:50:08 CEST 2006]
 * 
 * @deprecated Torque implementation will get removed in the next release
 */
@Deprecated()
public class MessageMapBuilder implements MapBuilder {
    /**
     * The name of this class
     */
    public static final String CLASS_NAME = "org.apache.james.mailbox.torque.om.map.MessageMapBuilder";

    /**
     * The database map.
     */
    private DatabaseMap dbMap = null;

    /**
     * Tells us if this DatabaseMapBuilder is built so that we don't have to
     * re-build it every time.
     * 
     * @return true if this DatabaseMapBuilder is built
     */
    public boolean isBuilt() {
        return (dbMap != null);
    }

    /**
     * Gets the databasemap this map builder built.
     * 
     * @return the databasemap
     */
    public DatabaseMap getDatabaseMap() {
        return this.dbMap;
    }

    /**
     * The doBuild() method builds the DatabaseMap
     * 
     * @throws TorqueException
     */
    public void doBuild() throws TorqueException {
        dbMap = Torque.getDatabaseMap("mailboxmanager");

        dbMap.addTable("message");
        TableMap tMap = dbMap.getTable("message");

        tMap.setPrimaryKeyMethod("none");

        tMap.addForeignPrimaryKey("message.MAILBOX_ID", new Long(0), "mailbox",
                "mailbox_id");
        tMap.addPrimaryKey("message.UID", new Long(0));
        tMap.addColumn("message.FLAGS", new Integer(0));
        tMap.addColumn("message.INTERNAL_DATE", new Date());
    }
}
