/****************************************************************
 * Licensed to the Apache Software Foundation (ASF) under one   *
 * or more contributor license agreements.  See the NOTICE file *
 * distributed with this work for additional information        *
 * regarding copyright ownership.  The ASF licenses this file   *
 * to you under the Apache License, Version 2.0 (the            *
 * "License"); you may not use this file except in compliance   *
 * with the License.  You may obtain a copy of the License at   *
 *                                                              *
 *   http://www.apache.org/licenses/LICENSE-2.0                 *
 *                                                              *
 * Unless required by applicable law or agreed to in writing,   *
 * software distributed under the License is distributed on an  *
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY       *
 * KIND, either express or implied.  See the License for the    *
 * specific language governing permissions and limitations      *
 * under the License.                                           *
 ****************************************************************/
package org.apache.james.mailbox.torque.om.map;

import org.apache.torque.Torque;
import org.apache.torque.TorqueException;
import org.apache.torque.map.DatabaseMap;
import org.apache.torque.map.MapBuilder;
import org.apache.torque.map.TableMap;

/**
 * This class was autogenerated by Torque on:
 * 
 * [Tue Sep 05 21:34:06 CEST 2006]
 * 
 * @deprecated Torque implementation will get removed in the next release
 */
@Deprecated()
public class MailboxMapBuilder implements MapBuilder {
    /**
     * The name of this class
     */
    public static final String CLASS_NAME = "org.apache.james.mailbox.torque.om.map.MailboxMapBuilder";

    /**
     * The database map.
     */
    private DatabaseMap dbMap = null;

    /**
     * Tells us if this DatabaseMapBuilder is built so that we don't have to
     * re-build it every time.
     * 
     * @return true if this DatabaseMapBuilder is built
     */
    public boolean isBuilt() {
        return (dbMap != null);
    }

    /**
     * Gets the databasemap this map builder built.
     * 
     * @return the databasemap
     */
    public DatabaseMap getDatabaseMap() {
        return this.dbMap;
    }

    /**
     * The doBuild() method builds the DatabaseMap
     * 
     * @throws TorqueException
     */
    public void doBuild() throws TorqueException {
        dbMap = Torque.getDatabaseMap("mailboxmanager");

        dbMap.addTable("mailbox");
        TableMap tMap = dbMap.getTable("mailbox");

        tMap.setPrimaryKeyMethod(TableMap.NATIVE);

        tMap.setPrimaryKeyMethodInfo("mailbox");

        tMap.addPrimaryKey("mailbox.MAILBOX_ID", new Long(0));
        tMap.addColumn("mailbox.NAME", "", 255);
        tMap.addColumn("mailbox.UID_VALIDITY", new Long(0));
        tMap.addColumn("mailbox.LAST_UID", new Long(0));
        tMap.addColumn("mailbox.MESSAGE_COUNT", new Integer(0));
        tMap.addColumn("mailbox.SIZE", new Long(0));
    }
}
