/****************************************************************
 * Licensed to the Apache Software Foundation (ASF) under one   *
 * or more contributor license agreements.  See the NOTICE file *
 * distributed with this work for additional information        *
 * regarding copyright ownership.  The ASF licenses this file   *
 * to you under the Apache License, Version 2.0 (the            *
 * "License"); you may not use this file except in compliance   *
 * with the License.  You may obtain a copy of the License at   *
 *                                                              *
 *   http://www.apache.org/licenses/LICENSE-2.0                 *
 *                                                              *
 * Unless required by applicable law or agreed to in writing,   *
 * software distributed under the License is distributed on an  *
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY       *
 * KIND, either express or implied.  See the License for the    *
 * specific language governing permissions and limitations      *
 * under the License.                                           *
 ****************************************************************/

package org.apache.james.mailbox.torque.om;

import java.util.ArrayList;
import java.util.List;

import org.apache.torque.TorqueException;
import org.apache.torque.util.BasePeer;
import org.apache.torque.util.Criteria;

import com.workingdogs.village.Record;

/**
 * The skeleton for this class was autogenerated by Torque on:
 * 
 * [Wed Sep 06 11:15:19 CEST 2006]
 * 
 * You should add additional methods to this class to meet the application
 * requirements. This class will only be generated as long as it does not
 * already exist in the output directory.
 *
 * @deprecated Torque implementation will get removed in the next release
 */
@Deprecated()
public class MessageRowPeer extends
        org.apache.james.mailbox.torque.om.BaseMessageRowPeer {

    /**
     * 
     */
    private static final long serialVersionUID = 1708650986440774692L;

    public static List doSelectJoinMessageFlags(Criteria criteria)
            throws TorqueException {

        MessageRowPeer.addSelectColumns(criteria);
        int offset = numColumns + 1;
        MessageFlagsPeer.addSelectColumns(criteria);

        criteria
                .addJoin(MessageRowPeer.MAILBOX_ID, MessageFlagsPeer.MAILBOX_ID);
        criteria.addJoin(MessageRowPeer.UID, MessageFlagsPeer.UID);

        List rows = BasePeer.doSelect(criteria);
        List result = new ArrayList(rows.size());

        for (int i = 0; i < rows.size(); i++) {
            Record row = (Record) rows.get(i);

            Class omClass = MessageRowPeer.getOMClass();
            MessageRow messageRow = (MessageRow) MessageRowPeer.row2Object(row,
                    1, omClass);

            omClass = MessageFlagsPeer.getOMClass();
            MessageFlags messageFlags = (MessageFlags) MessageFlagsPeer
                    .row2Object(row, offset, omClass);
            messageRow.setMessageFlags(messageFlags);

            result.add(messageRow);
        }
        return result;
    }

}
