/****************************************************************
 * Licensed to the Apache Software Foundation (ASF) under one   *
 * or more contributor license agreements.  See the NOTICE file *
 * distributed with this work for additional information        *
 * regarding copyright ownership.  The ASF licenses this file   *
 * to you under the Apache License, Version 2.0 (the            *
 * "License"); you may not use this file except in compliance   *
 * with the License.  You may obtain a copy of the License at   *
 *                                                              *
 *   http://www.apache.org/licenses/LICENSE-2.0                 *
 *                                                              *
 * Unless required by applicable law or agreed to in writing,   *
 * software distributed under the License is distributed on an  *
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY       *
 * KIND, either express or implied.  See the License for the    *
 * specific language governing permissions and limitations      *
 * under the License.                                           *
 ****************************************************************/
package org.apache.james.mailbox.torque.om;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;

import org.apache.commons.lang.ObjectUtils;
import org.apache.torque.TorqueException;
import org.apache.torque.map.TableMap;
import org.apache.torque.om.BaseObject;
import org.apache.torque.om.ComboKey;
import org.apache.torque.om.NumberKey;
import org.apache.torque.om.ObjectKey;
import org.apache.torque.om.SimpleKey;
import org.apache.torque.util.Criteria;
import org.apache.torque.util.Transaction;

/**
 * 
 * 
 * This class was autogenerated by Torque on:
 * 
 * [Sun Dec 09 17:45:09 GMT 2007]
 * 
 * You should not use this class directly. It should not even be extended all
 * references should be to MessageRow
 * 
 * @deprecated Torque implementation will get removed in the next release
 */
@Deprecated()
public abstract class BaseMessageRow extends BaseObject {
    /** Serial version */
    private static final long serialVersionUID = 1197222309712L;

    /** The Peer class */
    private static final MessageRowPeer peer = new MessageRowPeer();

    /** The value for the mailboxId field */
    private long mailboxId;

    /** The value for the uid field */
    private long uid;

    /** The value for the internalDate field */
    private Date internalDate;

    /** The value for the size field */
    private int size;

    /**
     * Get the MailboxId
     * 
     * @return long
     */
    public long getMailboxId() {
        return mailboxId;
    }

    /**
     * Set the value of MailboxId
     * 
     * @param v
     *            new value
     */
    public void setMailboxId(long v) throws TorqueException {

        if (this.mailboxId != v) {
            this.mailboxId = v;
            setModified(true);
        }

        if (aMailboxRow != null && !(aMailboxRow.getMailboxId() == v)) {
            aMailboxRow = null;
        }

        // update associated MessageFlags
        if (collMessageFlagss != null) {
            for (int i = 0; i < collMessageFlagss.size(); i++) {
                ((MessageFlags) collMessageFlagss.get(i)).setMailboxId(v);
            }
        }

        // update associated MessageHeader
        if (collMessageHeaders != null) {
            for (int i = 0; i < collMessageHeaders.size(); i++) {
                ((MessageHeader) collMessageHeaders.get(i)).setMailboxId(v);
            }
        }

        // update associated MessageBody
        if (collMessageBodys != null) {
            for (int i = 0; i < collMessageBodys.size(); i++) {
                ((MessageBody) collMessageBodys.get(i)).setMailboxId(v);
            }
        }
    }

    /**
     * Get the Uid
     * 
     * @return long
     */
    public long getUid() {
        return uid;
    }

    /**
     * Set the value of Uid
     * 
     * @param v
     *            new value
     */
    public void setUid(long v) throws TorqueException {

        if (this.uid != v) {
            this.uid = v;
            setModified(true);
        }

        // update associated MessageFlags
        if (collMessageFlagss != null) {
            for (int i = 0; i < collMessageFlagss.size(); i++) {
                ((MessageFlags) collMessageFlagss.get(i)).setUid(v);
            }
        }

        // update associated MessageHeader
        if (collMessageHeaders != null) {
            for (int i = 0; i < collMessageHeaders.size(); i++) {
                ((MessageHeader) collMessageHeaders.get(i)).setUid(v);
            }
        }

        // update associated MessageBody
        if (collMessageBodys != null) {
            for (int i = 0; i < collMessageBodys.size(); i++) {
                ((MessageBody) collMessageBodys.get(i)).setUid(v);
            }
        }
    }

    /**
     * Get the InternalDate
     * 
     * @return Date
     */
    public Date getInternalDate() {
        return internalDate;
    }

    /**
     * Set the value of InternalDate
     * 
     * @param v
     *            new value
     */
    public void setInternalDate(Date v) {

        if (!ObjectUtils.equals(this.internalDate, v)) {
            this.internalDate = v;
            setModified(true);
        }

    }

    /**
     * Get the Size
     * 
     * @return int
     */
    public int getSize() {
        return size;
    }

    /**
     * Set the value of Size
     * 
     * @param v
     *            new value
     */
    public void setSize(int v) {

        if (this.size != v) {
            this.size = v;
            setModified(true);
        }

    }

    private MailboxRow aMailboxRow;

    /**
     * Declares an association between this object and a MailboxRow object
     * 
     * @param v
     *            MailboxRow
     * @throws TorqueException
     */
    public void setMailboxRow(MailboxRow v) throws TorqueException {
        if (v == null) {
            setMailboxId(0);
        } else {
            setMailboxId(v.getMailboxId());
        }
        aMailboxRow = v;
    }

    /**
     * Returns the associated MailboxRow object. If it was not retrieved before,
     * the object is retrieved from the database
     * 
     * @return the associated MailboxRow object
     * @throws TorqueException
     */
    public MailboxRow getMailboxRow() throws TorqueException {
        if (aMailboxRow == null && (this.mailboxId != 0)) {
            aMailboxRow = MailboxRowPeer.retrieveByPK(SimpleKey
                    .keyFor(this.mailboxId));
        }
        return aMailboxRow;
    }

    /**
     * Return the associated MailboxRow object If it was not retrieved before,
     * the object is retrieved from the database using the passed connection
     * 
     * @param connection
     *            the connection used to retrieve the associated object from the
     *            database, if it was not retrieved before
     * @return the associated MailboxRow object
     * @throws TorqueException
     */
    public MailboxRow getMailboxRow(Connection connection)
            throws TorqueException {
        if (aMailboxRow == null && (this.mailboxId != 0)) {
            aMailboxRow = MailboxRowPeer.retrieveByPK(SimpleKey
                    .keyFor(this.mailboxId), connection);
        }
        return aMailboxRow;
    }

    /**
     * Provides convenient way to set a relationship based on a ObjectKey, for
     * example <code>bar.setFooKey(foo.getPrimaryKey())</code>
     * 
     */
    public void setMailboxRowKey(ObjectKey key) throws TorqueException {

        setMailboxId(((NumberKey) key).longValue());
    }

    /**
     * Collection to store aggregation of collMessageFlagss
     */
    protected List collMessageFlagss;

    /**
     * Temporary storage of collMessageFlagss to save a possible db hit in the
     * event objects are add to the collection, but the complete collection is
     * never requested.
     */
    protected void initMessageFlagss() {
        if (collMessageFlagss == null) {
            collMessageFlagss = new ArrayList();
        }
    }

    /**
     * Method called to associate a MessageFlags object to this object through
     * the MessageFlags foreign key attribute
     * 
     * @param l
     *            MessageFlags
     * @throws TorqueException
     */
    public void addMessageFlags(MessageFlags l) throws TorqueException {
        getMessageFlagss().add(l);
        l.setMessageRow((MessageRow) this);
    }

    /**
     * The criteria used to select the current contents of collMessageFlagss
     */
    private Criteria lastMessageFlagssCriteria = null;

    /**
     * If this collection has already been initialized, returns the collection.
     * Otherwise returns the results of getMessageFlagss(new Criteria())
     * 
     * @return the collection of associated objects
     * @throws TorqueException
     */
    public List getMessageFlagss() throws TorqueException {
        if (collMessageFlagss == null) {
            collMessageFlagss = getMessageFlagss(new Criteria(10));
        }
        return collMessageFlagss;
    }

    /**
     * If this collection has already been initialized with an identical
     * criteria, it returns the collection. Otherwise if this MessageRow has
     * previously been saved, it will retrieve related MessageFlagss from
     * storage. If this MessageRow is new, it will return an empty collection or
     * the current collection, the criteria is ignored on a new object.
     * 
     * @throws TorqueException
     */
    public List getMessageFlagss(Criteria criteria) throws TorqueException {
        if (collMessageFlagss == null) {
            if (isNew()) {
                collMessageFlagss = new ArrayList();
            } else {
                criteria.add(MessageFlagsPeer.MAILBOX_ID, getMailboxId());
                criteria.add(MessageFlagsPeer.UID, getUid());
                collMessageFlagss = MessageFlagsPeer.doSelect(criteria);
            }
        } else {
            // criteria has no effect for a new object
            if (!isNew()) {
                // the following code is to determine if a new query is
                // called for. If the criteria is the same as the last
                // one, just return the collection.
                criteria.add(MessageFlagsPeer.MAILBOX_ID, getMailboxId());
                criteria.add(MessageFlagsPeer.UID, getUid());
                if (!lastMessageFlagssCriteria.equals(criteria)) {
                    collMessageFlagss = MessageFlagsPeer.doSelect(criteria);
                }
            }
        }
        lastMessageFlagssCriteria = criteria;

        return collMessageFlagss;
    }

    /**
     * If this collection has already been initialized, returns the collection.
     * Otherwise returns the results of getMessageFlagss(new
     * Criteria(),Connection) This method takes in the Connection also as input
     * so that referenced objects can also be obtained using a Connection that
     * is taken as input
     */
    public List getMessageFlagss(Connection con) throws TorqueException {
        if (collMessageFlagss == null) {
            collMessageFlagss = getMessageFlagss(new Criteria(10), con);
        }
        return collMessageFlagss;
    }

    /**
     * If this collection has already been initialized with an identical
     * criteria, it returns the collection. Otherwise if this MessageRow has
     * previously been saved, it will retrieve related MessageFlagss from
     * storage. If this MessageRow is new, it will return an empty collection or
     * the current collection, the criteria is ignored on a new object. This
     * method takes in the Connection also as input so that referenced objects
     * can also be obtained using a Connection that is taken as input
     */
    public List getMessageFlagss(Criteria criteria, Connection con)
            throws TorqueException {
        if (collMessageFlagss == null) {
            if (isNew()) {
                collMessageFlagss = new ArrayList();
            } else {
                criteria.add(MessageFlagsPeer.MAILBOX_ID, getMailboxId());
                criteria.add(MessageFlagsPeer.UID, getUid());
                collMessageFlagss = MessageFlagsPeer.doSelect(criteria, con);
            }
        } else {
            // criteria has no effect for a new object
            if (!isNew()) {
                // the following code is to determine if a new query is
                // called for. If the criteria is the same as the last
                // one, just return the collection.
                criteria.add(MessageFlagsPeer.MAILBOX_ID, getMailboxId());
                criteria.add(MessageFlagsPeer.UID, getUid());
                if (!lastMessageFlagssCriteria.equals(criteria)) {
                    collMessageFlagss = MessageFlagsPeer
                            .doSelect(criteria, con);
                }
            }
        }
        lastMessageFlagssCriteria = criteria;

        return collMessageFlagss;
    }

    /**
     * If this collection has already been initialized with an identical
     * criteria, it returns the collection. Otherwise if this MessageRow is new,
     * it will return an empty collection; or if this MessageRow has previously
     * been saved, it will retrieve related MessageFlagss from storage.
     * 
     * This method is protected by default in order to keep the public api
     * reasonable. You can provide public methods for those you actually need in
     * MessageRow.
     */
    protected List getMessageFlagssJoinMessageRow(Criteria criteria)
            throws TorqueException {
        if (collMessageFlagss == null) {
            if (isNew()) {
                collMessageFlagss = new ArrayList();
            } else {
                criteria.add(MessageFlagsPeer.MAILBOX_ID, getMailboxId());
                criteria.add(MessageFlagsPeer.UID, getUid());
                collMessageFlagss = MessageFlagsPeer
                        .doSelectJoinMessageRow(criteria);
            }
        } else {
            // the following code is to determine if a new query is
            // called for. If the criteria is the same as the last
            // one, just return the collection.
            criteria.add(MessageFlagsPeer.MAILBOX_ID, getMailboxId());
            criteria.add(MessageFlagsPeer.UID, getUid());
            if (!lastMessageFlagssCriteria.equals(criteria)) {
                collMessageFlagss = MessageFlagsPeer
                        .doSelectJoinMessageRow(criteria);
            }
        }
        lastMessageFlagssCriteria = criteria;

        return collMessageFlagss;
    }

    /**
     * Collection to store aggregation of collMessageHeaders
     */
    protected List collMessageHeaders;

    /**
     * Temporary storage of collMessageHeaders to save a possible db hit in the
     * event objects are add to the collection, but the complete collection is
     * never requested.
     */
    protected void initMessageHeaders() {
        if (collMessageHeaders == null) {
            collMessageHeaders = new ArrayList();
        }
    }

    /**
     * Method called to associate a MessageHeader object to this object through
     * the MessageHeader foreign key attribute
     * 
     * @param l
     *            MessageHeader
     * @throws TorqueException
     */
    public void addMessageHeader(MessageHeader l) throws TorqueException {
        getMessageHeaders().add(l);
        l.setMessageRow((MessageRow) this);
    }

    /**
     * The criteria used to select the current contents of collMessageHeaders
     */
    private Criteria lastMessageHeadersCriteria = null;

    /**
     * If this collection has already been initialized, returns the collection.
     * Otherwise returns the results of getMessageHeaders(new Criteria())
     * 
     * @return the collection of associated objects
     * @throws TorqueException
     */
    public List getMessageHeaders() throws TorqueException {
        if (collMessageHeaders == null) {
            collMessageHeaders = getMessageHeaders(new Criteria(10));
        }
        return collMessageHeaders;
    }

    /**
     * If this collection has already been initialized with an identical
     * criteria, it returns the collection. Otherwise if this MessageRow has
     * previously been saved, it will retrieve related MessageHeaders from
     * storage. If this MessageRow is new, it will return an empty collection or
     * the current collection, the criteria is ignored on a new object.
     * 
     * @throws TorqueException
     */
    public List getMessageHeaders(Criteria criteria) throws TorqueException {
        if (collMessageHeaders == null) {
            if (isNew()) {
                collMessageHeaders = new ArrayList();
            } else {
                criteria.add(MessageHeaderPeer.MAILBOX_ID, getMailboxId());
                criteria.add(MessageHeaderPeer.UID, getUid());
                collMessageHeaders = MessageHeaderPeer.doSelect(criteria);
            }
        } else {
            // criteria has no effect for a new object
            if (!isNew()) {
                // the following code is to determine if a new query is
                // called for. If the criteria is the same as the last
                // one, just return the collection.
                criteria.add(MessageHeaderPeer.MAILBOX_ID, getMailboxId());
                criteria.add(MessageHeaderPeer.UID, getUid());
                if (!lastMessageHeadersCriteria.equals(criteria)) {
                    collMessageHeaders = MessageHeaderPeer.doSelect(criteria);
                }
            }
        }
        lastMessageHeadersCriteria = criteria;

        return collMessageHeaders;
    }

    /**
     * If this collection has already been initialized, returns the collection.
     * Otherwise returns the results of getMessageHeaders(new
     * Criteria(),Connection) This method takes in the Connection also as input
     * so that referenced objects can also be obtained using a Connection that
     * is taken as input
     */
    public List getMessageHeaders(Connection con) throws TorqueException {
        if (collMessageHeaders == null) {
            collMessageHeaders = getMessageHeaders(new Criteria(10), con);
        }
        return collMessageHeaders;
    }

    /**
     * If this collection has already been initialized with an identical
     * criteria, it returns the collection. Otherwise if this MessageRow has
     * previously been saved, it will retrieve related MessageHeaders from
     * storage. If this MessageRow is new, it will return an empty collection or
     * the current collection, the criteria is ignored on a new object. This
     * method takes in the Connection also as input so that referenced objects
     * can also be obtained using a Connection that is taken as input
     */
    public List getMessageHeaders(Criteria criteria, Connection con)
            throws TorqueException {
        if (collMessageHeaders == null) {
            if (isNew()) {
                collMessageHeaders = new ArrayList();
            } else {
                criteria.add(MessageHeaderPeer.MAILBOX_ID, getMailboxId());
                criteria.add(MessageHeaderPeer.UID, getUid());
                collMessageHeaders = MessageHeaderPeer.doSelect(criteria, con);
            }
        } else {
            // criteria has no effect for a new object
            if (!isNew()) {
                // the following code is to determine if a new query is
                // called for. If the criteria is the same as the last
                // one, just return the collection.
                criteria.add(MessageHeaderPeer.MAILBOX_ID, getMailboxId());
                criteria.add(MessageHeaderPeer.UID, getUid());
                if (!lastMessageHeadersCriteria.equals(criteria)) {
                    collMessageHeaders = MessageHeaderPeer.doSelect(criteria,
                            con);
                }
            }
        }
        lastMessageHeadersCriteria = criteria;

        return collMessageHeaders;
    }

    /**
     * If this collection has already been initialized with an identical
     * criteria, it returns the collection. Otherwise if this MessageRow is new,
     * it will return an empty collection; or if this MessageRow has previously
     * been saved, it will retrieve related MessageHeaders from storage.
     * 
     * This method is protected by default in order to keep the public api
     * reasonable. You can provide public methods for those you actually need in
     * MessageRow.
     */
    protected List getMessageHeadersJoinMessageRow(Criteria criteria)
            throws TorqueException {
        if (collMessageHeaders == null) {
            if (isNew()) {
                collMessageHeaders = new ArrayList();
            } else {
                criteria.add(MessageHeaderPeer.MAILBOX_ID, getMailboxId());
                criteria.add(MessageHeaderPeer.UID, getUid());
                collMessageHeaders = MessageHeaderPeer
                        .doSelectJoinMessageRow(criteria);
            }
        } else {
            // the following code is to determine if a new query is
            // called for. If the criteria is the same as the last
            // one, just return the collection.
            criteria.add(MessageHeaderPeer.MAILBOX_ID, getMailboxId());
            criteria.add(MessageHeaderPeer.UID, getUid());
            if (!lastMessageHeadersCriteria.equals(criteria)) {
                collMessageHeaders = MessageHeaderPeer
                        .doSelectJoinMessageRow(criteria);
            }
        }
        lastMessageHeadersCriteria = criteria;

        return collMessageHeaders;
    }

    /**
     * Collection to store aggregation of collMessageBodys
     */
    protected List collMessageBodys;

    /**
     * Temporary storage of collMessageBodys to save a possible db hit in the
     * event objects are add to the collection, but the complete collection is
     * never requested.
     */
    protected void initMessageBodys() {
        if (collMessageBodys == null) {
            collMessageBodys = new ArrayList();
        }
    }

    /**
     * Method called to associate a MessageBody object to this object through
     * the MessageBody foreign key attribute
     * 
     * @param l
     *            MessageBody
     * @throws TorqueException
     */
    public void addMessageBody(MessageBody l) throws TorqueException {
        getMessageBodys().add(l);
        l.setMessageRow((MessageRow) this);
    }

    /**
     * The criteria used to select the current contents of collMessageBodys
     */
    private Criteria lastMessageBodysCriteria = null;

    /**
     * If this collection has already been initialized, returns the collection.
     * Otherwise returns the results of getMessageBodys(new Criteria())
     * 
     * @return the collection of associated objects
     * @throws TorqueException
     */
    public List getMessageBodys() throws TorqueException {
        if (collMessageBodys == null) {
            collMessageBodys = getMessageBodys(new Criteria(10));
        }
        return collMessageBodys;
    }

    /**
     * If this collection has already been initialized with an identical
     * criteria, it returns the collection. Otherwise if this MessageRow has
     * previously been saved, it will retrieve related MessageBodys from
     * storage. If this MessageRow is new, it will return an empty collection or
     * the current collection, the criteria is ignored on a new object.
     * 
     * @throws TorqueException
     */
    public List getMessageBodys(Criteria criteria) throws TorqueException {
        if (collMessageBodys == null) {
            if (isNew()) {
                collMessageBodys = new ArrayList();
            } else {
                criteria.add(MessageBodyPeer.MAILBOX_ID, getMailboxId());
                criteria.add(MessageBodyPeer.UID, getUid());
                collMessageBodys = MessageBodyPeer.doSelect(criteria);
            }
        } else {
            // criteria has no effect for a new object
            if (!isNew()) {
                // the following code is to determine if a new query is
                // called for. If the criteria is the same as the last
                // one, just return the collection.
                criteria.add(MessageBodyPeer.MAILBOX_ID, getMailboxId());
                criteria.add(MessageBodyPeer.UID, getUid());
                if (!lastMessageBodysCriteria.equals(criteria)) {
                    collMessageBodys = MessageBodyPeer.doSelect(criteria);
                }
            }
        }
        lastMessageBodysCriteria = criteria;

        return collMessageBodys;
    }

    /**
     * If this collection has already been initialized, returns the collection.
     * Otherwise returns the results of getMessageBodys(new
     * Criteria(),Connection) This method takes in the Connection also as input
     * so that referenced objects can also be obtained using a Connection that
     * is taken as input
     */
    public List getMessageBodys(Connection con) throws TorqueException {
        if (collMessageBodys == null) {
            collMessageBodys = getMessageBodys(new Criteria(10), con);
        }
        return collMessageBodys;
    }

    /**
     * If this collection has already been initialized with an identical
     * criteria, it returns the collection. Otherwise if this MessageRow has
     * previously been saved, it will retrieve related MessageBodys from
     * storage. If this MessageRow is new, it will return an empty collection or
     * the current collection, the criteria is ignored on a new object. This
     * method takes in the Connection also as input so that referenced objects
     * can also be obtained using a Connection that is taken as input
     */
    public List getMessageBodys(Criteria criteria, Connection con)
            throws TorqueException {
        if (collMessageBodys == null) {
            if (isNew()) {
                collMessageBodys = new ArrayList();
            } else {
                criteria.add(MessageBodyPeer.MAILBOX_ID, getMailboxId());
                criteria.add(MessageBodyPeer.UID, getUid());
                collMessageBodys = MessageBodyPeer.doSelect(criteria, con);
            }
        } else {
            // criteria has no effect for a new object
            if (!isNew()) {
                // the following code is to determine if a new query is
                // called for. If the criteria is the same as the last
                // one, just return the collection.
                criteria.add(MessageBodyPeer.MAILBOX_ID, getMailboxId());
                criteria.add(MessageBodyPeer.UID, getUid());
                if (!lastMessageBodysCriteria.equals(criteria)) {
                    collMessageBodys = MessageBodyPeer.doSelect(criteria, con);
                }
            }
        }
        lastMessageBodysCriteria = criteria;

        return collMessageBodys;
    }

    /**
     * If this collection has already been initialized with an identical
     * criteria, it returns the collection. Otherwise if this MessageRow is new,
     * it will return an empty collection; or if this MessageRow has previously
     * been saved, it will retrieve related MessageBodys from storage.
     * 
     * This method is protected by default in order to keep the public api
     * reasonable. You can provide public methods for those you actually need in
     * MessageRow.
     */
    protected List getMessageBodysJoinMessageRow(Criteria criteria)
            throws TorqueException {
        if (collMessageBodys == null) {
            if (isNew()) {
                collMessageBodys = new ArrayList();
            } else {
                criteria.add(MessageBodyPeer.MAILBOX_ID, getMailboxId());
                criteria.add(MessageBodyPeer.UID, getUid());
                collMessageBodys = MessageBodyPeer
                        .doSelectJoinMessageRow(criteria);
            }
        } else {
            // the following code is to determine if a new query is
            // called for. If the criteria is the same as the last
            // one, just return the collection.
            criteria.add(MessageBodyPeer.MAILBOX_ID, getMailboxId());
            criteria.add(MessageBodyPeer.UID, getUid());
            if (!lastMessageBodysCriteria.equals(criteria)) {
                collMessageBodys = MessageBodyPeer
                        .doSelectJoinMessageRow(criteria);
            }
        }
        lastMessageBodysCriteria = criteria;

        return collMessageBodys;
    }

    private static List fieldNames = null;

    /**
     * Generate a list of field names.
     * 
     * @return a list of field names
     */
    public static synchronized List getFieldNames() {
        if (fieldNames == null) {
            fieldNames = new ArrayList();
            fieldNames.add("MailboxId");
            fieldNames.add("Uid");
            fieldNames.add("InternalDate");
            fieldNames.add("Size");
            fieldNames = Collections.unmodifiableList(fieldNames);
        }
        return fieldNames;
    }

    /**
     * Retrieves a field from the object by field (Java) name passed in as a
     * String.
     * 
     * @param name
     *            field name
     * @return value
     */
    public Object getByName(String name) {
        if (name.equals("MailboxId")) {
            return new Long(getMailboxId());
        }
        if (name.equals("Uid")) {
            return new Long(getUid());
        }
        if (name.equals("InternalDate")) {
            return getInternalDate();
        }
        if (name.equals("Size")) {
            return new Integer(getSize());
        }
        return null;
    }

    /**
     * Set a field in the object by field (Java) name.
     * 
     * @param name
     *            field name
     * @param value
     *            field value
     * @return True if value was set, false if not (invalid name / protected
     *         field).
     * @throws IllegalArgumentException
     *             if object type of value does not match field object type.
     * @throws TorqueException
     *             If a problem occures with the set[Field] method.
     */
    public boolean setByName(String name, Object value) throws TorqueException,
            IllegalArgumentException {
        if (name.equals("MailboxId")) {
            if (value == null || !(Long.class.isInstance(value))) {
                throw new IllegalArgumentException(
                        "setByName: value parameter was null or not a Long object.");
            }
            setMailboxId(((Long) value).longValue());
            return true;
        }
        if (name.equals("Uid")) {
            if (value == null || !(Long.class.isInstance(value))) {
                throw new IllegalArgumentException(
                        "setByName: value parameter was null or not a Long object.");
            }
            setUid(((Long) value).longValue());
            return true;
        }
        if (name.equals("InternalDate")) {
            // Object fields can be null
            if (value != null && !Date.class.isInstance(value)) {
                throw new IllegalArgumentException(
                        "Invalid type of object specified for value in setByName");
            }
            setInternalDate((Date) value);
            return true;
        }
        if (name.equals("Size")) {
            if (value == null || !(Integer.class.isInstance(value))) {
                throw new IllegalArgumentException(
                        "setByName: value parameter was null or not an Integer object.");
            }
            setSize(((Integer) value).intValue());
            return true;
        }
        return false;
    }

    /**
     * Retrieves a field from the object by name passed in as a String. The
     * String must be one of the static Strings defined in this Class' Peer.
     * 
     * @param name
     *            peer name
     * @return value
     */
    public Object getByPeerName(String name) {
        if (name.equals(MessageRowPeer.MAILBOX_ID)) {
            return new Long(getMailboxId());
        }
        if (name.equals(MessageRowPeer.UID)) {
            return new Long(getUid());
        }
        if (name.equals(MessageRowPeer.INTERNAL_DATE)) {
            return getInternalDate();
        }
        if (name.equals(MessageRowPeer.SIZE)) {
            return new Integer(getSize());
        }
        return null;
    }

    /**
     * Set field values by Peer Field Name
     * 
     * @param name
     *            field name
     * @param value
     *            field value
     * @return True if value was set, false if not (invalid name / protected
     *         field).
     * @throws IllegalArgumentException
     *             if object type of value does not match field object type.
     * @throws TorqueException
     *             If a problem occures with the set[Field] method.
     */
    public boolean setByPeerName(String name, Object value)
            throws TorqueException, IllegalArgumentException {
        if (MessageRowPeer.MAILBOX_ID.equals(name)) {
            return setByName("MailboxId", value);
        }
        if (MessageRowPeer.UID.equals(name)) {
            return setByName("Uid", value);
        }
        if (MessageRowPeer.INTERNAL_DATE.equals(name)) {
            return setByName("InternalDate", value);
        }
        if (MessageRowPeer.SIZE.equals(name)) {
            return setByName("Size", value);
        }
        return false;
    }

    /**
     * Retrieves a field from the object by Position as specified in the xml
     * schema. Zero-based.
     * 
     * @param pos
     *            position in xml schema
     * @return value
     */
    public Object getByPosition(int pos) {
        if (pos == 0) {
            return new Long(getMailboxId());
        }
        if (pos == 1) {
            return new Long(getUid());
        }
        if (pos == 2) {
            return getInternalDate();
        }
        if (pos == 3) {
            return new Integer(getSize());
        }
        return null;
    }

    /**
     * Set field values by its position (zero based) in the XML schema.
     * 
     * @param position
     *            The field position
     * @param value
     *            field value
     * @return True if value was set, false if not (invalid position / protected
     *         field).
     * @throws IllegalArgumentException
     *             if object type of value does not match field object type.
     * @throws TorqueException
     *             If a problem occures with the set[Field] method.
     */
    public boolean setByPosition(int position, Object value)
            throws TorqueException, IllegalArgumentException {
        if (position == 0) {
            return setByName("MailboxId", value);
        }
        if (position == 1) {
            return setByName("Uid", value);
        }
        if (position == 2) {
            return setByName("InternalDate", value);
        }
        if (position == 3) {
            return setByName("Size", value);
        }
        return false;
    }

    /**
     * Stores the object in the database. If the object is new, it inserts it;
     * otherwise an update is performed.
     * 
     * @throws Exception
     */
    public void save() throws TorqueException {
        save(MessageRowPeer.DATABASE_NAME);
    }

    /**
     * Stores the object in the database. If the object is new, it inserts it;
     * otherwise an update is performed. Note: this code is here because the
     * method body is auto-generated conditionally and therefore needs to be in
     * this file instead of in the super class, BaseObject.
     * 
     * @param dbName
     * @throws TorqueException
     */
    public void save(String dbName) throws TorqueException {
        Connection con = null;
        try {
            con = Transaction.begin(dbName);
            save(con);
            Transaction.commit(con);
        } catch (TorqueException e) {
            Transaction.safeRollback(con);
            throw e;
        }
    }

    /**
     * flag to prevent endless save loop, if this object is referenced by
     * another object which falls in this transaction.
     */
    private boolean alreadyInSave = false;

    /**
     * Stores the object in the database. If the object is new, it inserts it;
     * otherwise an update is performed. This method is meant to be used as part
     * of a transaction, otherwise use the save() method and the connection
     * details will be handled internally
     * 
     * @param con
     * @throws TorqueException
     */
    public void save(Connection con) throws TorqueException {
        if (!alreadyInSave) {
            alreadyInSave = true;

            // If this object has been modified, then save it to the database.
            if (isModified()) {
                if (isNew()) {
                    MessageRowPeer.doInsert((MessageRow) this, con);
                    setNew(false);
                } else {
                    MessageRowPeer.doUpdate((MessageRow) this, con);
                }
            }

            if (collMessageFlagss != null) {
                for (int i = 0; i < collMessageFlagss.size(); i++) {
                    ((MessageFlags) collMessageFlagss.get(i)).save(con);
                }
            }

            if (collMessageHeaders != null) {
                for (int i = 0; i < collMessageHeaders.size(); i++) {
                    ((MessageHeader) collMessageHeaders.get(i)).save(con);
                }
            }

            if (collMessageBodys != null) {
                for (int i = 0; i < collMessageBodys.size(); i++) {
                    ((MessageBody) collMessageBodys.get(i)).save(con);
                }
            }
            alreadyInSave = false;
        }
    }

    private final SimpleKey[] pks = new SimpleKey[2];

    private final ComboKey comboPK = new ComboKey(pks);

    /**
     * Set the PrimaryKey with an ObjectKey
     * 
     * @param key
     */
    public void setPrimaryKey(ObjectKey key) throws TorqueException {
        SimpleKey[] keys = (SimpleKey[]) key.getValue();
        setMailboxId(((NumberKey) keys[0]).longValue());
        setUid(((NumberKey) keys[1]).longValue());
    }

    /**
     * Set the PrimaryKey using SimpleKeys.
     * 
     * @param mailboxId
     *            long
     * @param uid
     *            long
     */
    public void setPrimaryKey(long mailboxId, long uid) throws TorqueException {
        setMailboxId(mailboxId);
        setUid(uid);
    }

    /**
     * Set the PrimaryKey using a String.
     */
    public void setPrimaryKey(String key) throws TorqueException {
        setPrimaryKey(new ComboKey(key));
    }

    /**
     * returns an id that differentiates this object from others of its class.
     */
    public ObjectKey getPrimaryKey() {
        pks[0] = SimpleKey.keyFor(getMailboxId());
        pks[1] = SimpleKey.keyFor(getUid());
        return comboPK;
    }

    /**
     * Makes a copy of this object. It creates a new object filling in the
     * simple attributes. It then fills all the association collections and sets
     * the related objects to isNew=true.
     */
    public MessageRow copy() throws TorqueException {
        return copy(true);
    }

    /**
     * Makes a copy of this object. It creates a new object filling in the
     * simple attributes. If the parameter deepcopy is true, it then fills all
     * the association collections and sets the related objects to isNew=true.
     * 
     * @param deepcopy
     *            whether to copy the associated objects.
     */
    public MessageRow copy(boolean deepcopy) throws TorqueException {
        return copyInto(new MessageRow(), deepcopy);
    }

    /**
     * Fills the copyObj with the contents of this object. The associated
     * objects are also copied and treated as new objects.
     * 
     * @param copyObj
     *            the object to fill.
     */
    protected MessageRow copyInto(MessageRow copyObj) throws TorqueException {
        return copyInto(copyObj, true);
    }

    /**
     * Fills the copyObj with the contents of this object. If deepcopy is true,
     * The associated objects are also copied and treated as new objects.
     * 
     * @param copyObj
     *            the object to fill.
     * @param deepcopy
     *            whether the associated objects should be copied.
     */
    protected MessageRow copyInto(MessageRow copyObj, boolean deepcopy)
            throws TorqueException {
        copyObj.setMailboxId(mailboxId);
        copyObj.setUid(uid);
        copyObj.setInternalDate(internalDate);
        copyObj.setSize(size);

        copyObj.setMailboxId(0);
        copyObj.setUid(0);

        if (deepcopy) {

            List vMessageFlagss = getMessageFlagss();
            if (vMessageFlagss != null) {
                for (int i = 0; i < vMessageFlagss.size(); i++) {
                    MessageFlags obj = (MessageFlags) vMessageFlagss.get(i);
                    copyObj.addMessageFlags(obj.copy());
                }
            } else {
                copyObj.collMessageFlagss = null;
            }

            List vMessageHeaders = getMessageHeaders();
            if (vMessageHeaders != null) {
                for (int i = 0; i < vMessageHeaders.size(); i++) {
                    MessageHeader obj = (MessageHeader) vMessageHeaders.get(i);
                    copyObj.addMessageHeader(obj.copy());
                }
            } else {
                copyObj.collMessageHeaders = null;
            }

            List vMessageBodys = getMessageBodys();
            if (vMessageBodys != null) {
                for (int i = 0; i < vMessageBodys.size(); i++) {
                    MessageBody obj = (MessageBody) vMessageBodys.get(i);
                    copyObj.addMessageBody(obj.copy());
                }
            } else {
                copyObj.collMessageBodys = null;
            }
        }
        return copyObj;
    }

    /**
     * returns a peer instance associated with this om. Since Peer classes are
     * not to have any instance attributes, this method returns the same
     * instance for all member of this class. The method could therefore be
     * static, but this would prevent one from overriding the behavior.
     */
    public MessageRowPeer getPeer() {
        return peer;
    }

    /**
     * Retrieves the TableMap object related to this Table data without compiler
     * warnings of using getPeer().getTableMap().
     * 
     * @return The associated TableMap object.
     */
    public TableMap getTableMap() throws TorqueException {
        return MessageRowPeer.getTableMap();
    }

    public String toString() {
        StringBuffer str = new StringBuffer();
        str.append("MessageRow:\n");
        str.append("MailboxId = ").append(getMailboxId()).append("\n");
        str.append("Uid = ").append(getUid()).append("\n");
        str.append("InternalDate = ").append(getInternalDate()).append("\n");
        str.append("Size = ").append(getSize()).append("\n");
        return (str.toString());
    }
}
