/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailet.crypto.matcher;

import java.io.Serializable;
import java.security.Principal;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.mail.MessagingException;
import org.apache.mailet.Mail;
import org.apache.mailet.base.GenericMatcher;

public class IsX509CertificateSubject
extends GenericMatcher {
    protected String sourceAttribute;
    protected String check;

    public void init() throws MessagingException {
        String condition = this.getCondition();
        if (condition == null || condition.indexOf(";") == -1) {
            throw new MessagingException("Invalid matcher configuration: " + condition);
        }
        int pos = condition.indexOf(";");
        this.sourceAttribute = condition.substring(0, pos).trim();
        this.check = condition.substring(pos + 1, condition.length());
    }

    public Collection match(Mail mail) throws MessagingException {
        Serializable obj = mail.getAttribute(this.sourceAttribute);
        if (obj != null) {
            List certificates = obj instanceof X509Certificate ? Collections.singletonList(obj) : (List)((Object)obj);
            boolean valid = false;
            Iterator iter = certificates.iterator();
            while (iter.hasNext()) {
                X509Certificate cert = (X509Certificate)iter.next();
                Principal prin = cert.getSubjectDN();
                if (((Object)prin).toString().indexOf(this.check) <= 0) continue;
                valid = true;
            }
            if (valid) {
                return mail.getRecipients();
            }
            return null;
        }
        return null;
    }
}

