/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailet.crypto.mailet;

import java.io.IOException;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.apache.james.mailet.crypto.mailet.AbstractSign;
import org.apache.mailet.Mail;

public class Sign
extends AbstractSign {
    public String getMailetInfo() {
        return "Signature Mailet";
    }

    protected String[] getAllowedInitParameters() {
        String[] allowedArray = new String[]{"keyHolderClass", "debug", "keyStoreFileName", "keyStorePassword", "keyStoreType", "keyAlias", "keyAliasPassword", "signerName", "postmasterSigns", "rebuildFrom", "explanationText"};
        return allowedArray;
    }

    public String getExplanationText() {
        String explanationText = super.getExplanationText();
        if (explanationText == null) {
            explanationText = "The message this file is attached to has been signed on the server by\r\n\t\"[signerName]\" <[signerAddress]>\r\nto certify that the sender is known and truly has the following address (reverse-path):\r\n\t[reversePath]\r\nand that the original message has the following message headers:\r\n\r\n[headers]\r\n\r\nThe signature envelopes this attachment too.\r\nPlease check the signature integrity.\r\n\r\n\t\"[signerName]\" <[signerAddress]>";
        }
        return explanationText;
    }

    protected void initPostmasterSigns() {
        this.setPostmasterSigns(this.getInitParameter("postmasterSigns") == null ? true : new Boolean(this.getInitParameter("postmasterSigns")));
    }

    protected void initRebuildFrom() throws MessagingException {
        this.setRebuildFrom(this.getInitParameter("rebuildFrom") == null ? true : new Boolean(this.getInitParameter("rebuildFrom")));
        if (this.isDebug()) {
            if (this.isRebuildFrom()) {
                this.log("Will modify the \"From:\" header.");
            } else {
                this.log("Will leave the \"From:\" header unchanged.");
            }
        }
    }

    protected MimeBodyPart getWrapperBodyPart(Mail mail) throws MessagingException, IOException {
        String explanationText = this.getExplanationText();
        if (explanationText == null) {
            return null;
        }
        MimeMessage originalMessage = mail.getMessage();
        MimeBodyPart messagePart = new MimeBodyPart();
        MimeBodyPart signatureReason = new MimeBodyPart();
        String contentType = originalMessage.getContentType();
        Object content = originalMessage.getContent();
        if (contentType == null || content == null) {
            throw new MessagingException("Either the content type or the content is null");
        }
        messagePart.setContent(content, contentType);
        String headers = this.getMessageHeaders(originalMessage);
        signatureReason.setText(this.getReplacedExplanationText(this.getExplanationText(), this.getSignerName(), this.getKeyHolder().getSignerAddress(), mail.getSender().toString(), headers));
        signatureReason.setFileName("SignatureExplanation.txt");
        MimeMultipart wrapperMultiPart = new MimeMultipart();
        wrapperMultiPart.addBodyPart((BodyPart)messagePart);
        wrapperMultiPart.addBodyPart((BodyPart)signatureReason);
        MimeBodyPart wrapperBodyPart = new MimeBodyPart();
        wrapperBodyPart.setContent((Multipart)wrapperMultiPart);
        return wrapperBodyPart;
    }
}

