/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailet.crypto.mailet;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import org.apache.james.mailet.crypto.SMIMEKeyHolder;
import org.apache.mailet.Mail;
import org.apache.mailet.MailetConfig;
import org.apache.mailet.base.GenericMailet;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.RecipientId;
import org.bouncycastle.cms.RecipientInformation;
import org.bouncycastle.mail.smime.SMIMEEnveloped;
import org.bouncycastle.mail.smime.SMIMEUtil;

public class SMIMEDecrypt
extends GenericMailet {
    private SMIMEKeyHolder keyHolder;
    protected String mailAttribute = "org.apache.james.SMIMEDecrypt";

    public void init() throws MessagingException {
        super.init();
        MailetConfig config = this.getMailetConfig();
        String privateStoreType = config.getInitParameter("keyStoreType");
        String privateStoreFile = config.getInitParameter("keyStoreFileName");
        if (privateStoreFile == null) {
            throw new MessagingException("No keyStoreFileName specified");
        }
        String privateStorePass = config.getInitParameter("keyStorePassword");
        String keyAlias = config.getInitParameter("keyAlias");
        String keyPass = config.getInitParameter("keyAliasPassword");
        String mailAttributeConf = config.getInitParameter("mailAttribute");
        if (mailAttributeConf != null) {
            this.mailAttribute = mailAttributeConf;
        }
        try {
            this.keyHolder = new SMIMEKeyHolder(privateStoreFile, privateStorePass, keyAlias, keyPass, privateStoreType);
        }
        catch (IOException e) {
            throw new MessagingException("Error loading keystore", (Exception)e);
        }
        catch (GeneralSecurityException e) {
            throw new MessagingException("Error loading keystore", (Exception)e);
        }
    }

    public void service(Mail mail) throws MessagingException {
        MimeMessage message = mail.getMessage();
        MimeBodyPart strippedMessage = null;
        this.log("Starting message decryption..");
        if (message.isMimeType("application/x-pkcs7-mime") || message.isMimeType("application/pkcs7-mime")) {
            try {
                SMIMEEnveloped env = new SMIMEEnveloped(message);
                Collection recipients = env.getRecipientInfos().getRecipients();
                Iterator iter = recipients.iterator();
                while (iter.hasNext()) {
                    RecipientInformation info = (RecipientInformation)iter.next();
                    RecipientId id = info.getRID();
                    if (id.match((Certificate)this.keyHolder.getCertificate())) {
                        try {
                            MimeBodyPart part;
                            strippedMessage = part = SMIMEUtil.toMimeBodyPart((byte[])info.getContent((Key)this.keyHolder.getPrivateKey(), "BC"));
                            this.log("Encrypted message decrypted");
                            continue;
                        }
                        catch (Exception e) {
                            throw new MessagingException("Error during the decryption of the message", e);
                        }
                    }
                    this.log("Found an encrypted message but it isn't encrypted for the supplied key");
                }
            }
            catch (CMSException e) {
                throw new MessagingException("Error during the decryption of the message", (Exception)((Object)e));
            }
        }
        if (strippedMessage != null) {
            ArrayList<X509Certificate> list = new ArrayList<X509Certificate>(1);
            list.add(this.keyHolder.getCertificate());
            mail.setAttribute(this.mailAttribute, list);
            try {
                MimeMessage newmex = new MimeMessage(message);
                Object obj = strippedMessage.getContent();
                if (obj instanceof Multipart) {
                    this.log("The message is multipart, content type " + ((Multipart)obj).getContentType());
                    newmex.setContent((Multipart)obj);
                } else {
                    newmex.setContent(obj, strippedMessage.getContentType());
                    newmex.setDisposition(null);
                }
                newmex.saveChanges();
                mail.setMessage(newmex);
            }
            catch (IOException e) {
                this.log("Error during the strip of the encrypted message");
                throw new MessagingException("Error during the stripping of the encrypted message", (Exception)e);
            }
        }
    }
}

