/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailet.crypto.mailet;

import java.io.IOException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Part;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.apache.james.mailet.crypto.KeyStoreHolder;
import org.apache.james.mailet.crypto.SMIMESignerInfo;
import org.apache.mailet.Mail;
import org.apache.mailet.MailetConfig;
import org.apache.mailet.base.GenericMailet;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.mail.smime.SMIMEException;
import org.bouncycastle.mail.smime.SMIMESigned;

public class SMIMECheckSignature
extends GenericMailet {
    protected KeyStoreHolder trustedCertificateStore;
    protected boolean stripSignature = false;
    protected boolean onlyTrusted = true;
    protected String mailAttribute = "org.apache.james.SMIMECheckSignature";

    public void init() throws MessagingException {
        String mailAttributeConf;
        String onlyTrustedConf;
        MailetConfig config = this.getMailetConfig();
        String stripSignatureConf = config.getInitParameter("strip");
        if (stripSignatureConf != null) {
            this.stripSignature = Boolean.valueOf(stripSignatureConf);
        }
        if ((onlyTrustedConf = config.getInitParameter("onlyTrusted")) != null) {
            this.onlyTrusted = Boolean.valueOf(onlyTrustedConf);
        }
        if ((mailAttributeConf = config.getInitParameter("mailAttribute")) != null) {
            this.mailAttribute = mailAttributeConf;
        }
        String type = config.getInitParameter("keyStoreType");
        String file = config.getInitParameter("keyStoreFileName");
        String password = config.getInitParameter("keyStorePassword");
        try {
            if (file != null) {
                this.trustedCertificateStore = new KeyStoreHolder(file, password, type);
            } else {
                this.log("No trusted store path specified, using default store.");
                this.trustedCertificateStore = new KeyStoreHolder(password);
            }
        }
        catch (Exception e) {
            throw new MessagingException("Error loading the trusted certificate store", e);
        }
    }

    public void service(Mail mail) throws MessagingException {
        Object obj;
        MimeMessage message = mail.getMessage();
        MimeBodyPart strippedMessage = null;
        List signers = null;
        try {
            obj = message.getContent();
            Object signed = obj instanceof MimeMultipart ? new SMIMESigned((MimeMultipart)message.getContent()) : (obj instanceof SMIMESigned ? (SMIMESigned)obj : (obj instanceof byte[] ? new SMIMESigned((Part)message) : null));
            if (signed != null) {
                signers = this.trustedCertificateStore.verifySignatures((SMIMESigned)signed);
                strippedMessage = signed.getContent();
            } else {
                this.log("Content not identified as signed");
            }
        }
        catch (CMSException e) {
            this.log("Error during the analysis of the signed message", e);
            signers = null;
        }
        catch (IOException e) {
            this.log("IO error during the analysis of the signed message", e);
            signers = null;
        }
        catch (SMIMEException e) {
            this.log("Error during the analysis of the signed message", e);
            signers = null;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.log("Generic error occured during the analysis of the message", e);
            signers = null;
        }
        if (signers != null) {
            ArrayList<X509Certificate> signerinfolist = new ArrayList<X509Certificate>();
            Iterator iter = signers.iterator();
            while (iter.hasNext()) {
                SMIMESignerInfo info = (SMIMESignerInfo)iter.next();
                if (!info.isSignValid() || this.onlyTrusted && info.getCertPath() == null) continue;
                signerinfolist.add(info.getSignerCertificate());
            }
            if (signerinfolist.size() > 0) {
                mail.setAttribute(this.mailAttribute, signerinfolist);
            } else {
                strippedMessage = null;
            }
        }
        if (this.stripSignature && strippedMessage != null) {
            try {
                obj = strippedMessage.getContent();
                if (obj instanceof Multipart) {
                    message.setContent((Multipart)obj);
                } else {
                    message.setContent(obj, strippedMessage.getContentType());
                }
                message.saveChanges();
                mail.setMessage(message);
            }
            catch (Exception e) {
                throw new MessagingException("Error during the extraction of the signed content from the message.", e);
            }
        }
    }
}

