/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.solr.query;

import java.util.Arrays;
import org.apache.jackrabbit.oak.spi.query.Filter;
import org.apache.solr.common.SolrDocumentList;

class LMSEstimator {
    private double[] weights;
    private final double alpha;

    public LMSEstimator(double alpha, double[] weights) {
        this.alpha = alpha;
        this.weights = weights;
    }

    public LMSEstimator(double[] weights) {
        this.weights = weights;
        this.alpha = 0.03;
    }

    public LMSEstimator() {
        this.weights = new double[5];
        this.alpha = 0.03;
    }

    synchronized void update(Filter filter, SolrDocumentList docs) {
        double[] updatedWeights = new double[this.weights.length];
        for (int i = 0; i < updatedWeights.length; ++i) {
            double errors = (docs.getNumFound() - this.estimate(filter)) * this.getInput(filter, i);
            updatedWeights[i] = this.weights[i] + this.alpha * errors;
        }
        this.weights = Arrays.copyOf(updatedWeights, 5);
    }

    long estimate(Filter filter) {
        long estimatedEntryCount = 0L;
        for (int i = 0; i < 5; ++i) {
            estimatedEntryCount = (long)((double)estimatedEntryCount + this.weights[i] * (double)this.getInput(filter, i));
        }
        return estimatedEntryCount + 1L;
    }

    private long getInput(Filter filter, int i) {
        assert (i < 5);
        if (i == 0) {
            return filter.getPropertyRestrictions() != null ? (long)filter.getPropertyRestrictions().size() : 0L;
        }
        if (i == 1) {
            return filter.containsNativeConstraint() ? 1L : 0L;
        }
        if (i == 2) {
            return filter.getPathRestriction() != null ? (long)filter.getPathRestriction().ordinal() : 0L;
        }
        if (i == 3) {
            return filter.getPathRestriction() != null ? (long)filter.getPathRestriction().toString().split("/").length : 0L;
        }
        if (i == 4) {
            return filter.getFullTextConstraint() != null ? (long)filter.getFullTextConstraint().getPrecedence() : 0L;
        }
        return 0L;
    }
}

