/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.solr.configuration.nodestate;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.plugins.index.solr.configuration.SolrServerConfiguration;
import org.apache.jackrabbit.oak.plugins.index.solr.configuration.nodestate.NodeStateSolrServerConfigurationProvider;
import org.apache.jackrabbit.oak.plugins.index.solr.server.SolrServerProvider;
import org.apache.jackrabbit.oak.plugins.index.solr.server.SolrServerRegistry;
import org.apache.jackrabbit.oak.spi.commit.CommitInfo;
import org.apache.jackrabbit.oak.spi.commit.DiffObserver;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.spi.state.NodeStateDiff;
import org.apache.solr.client.solrj.SolrServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeStateSolrServersObserver
extends DiffObserver {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    protected NodeStateDiff getRootDiff(@Nonnull NodeState before, @Nonnull NodeState after, @Nullable CommitInfo info) {
        return new ChangingSolrServersNodeStateDiff(after);
    }

    private void shutdownRegisteredSolrServers(NodeState nodeState) {
        SolrServer indexingSolrServer;
        this.log.debug("shutting down servers at {}", (Object)nodeState);
        NodeStateSolrServerConfigurationProvider nodeStateSolrServerConfigurationProvider = new NodeStateSolrServerConfigurationProvider(nodeState);
        SolrServerConfiguration<SolrServerProvider> solrServerConfiguration = nodeStateSolrServerConfigurationProvider.getSolrServerConfiguration();
        SolrServer searchingSolrServer = SolrServerRegistry.get(solrServerConfiguration, SolrServerRegistry.Strategy.SEARCHING);
        if (searchingSolrServer != null) {
            searchingSolrServer.shutdown();
            this.log.debug("searching SolrServer shut down");
            SolrServerRegistry.unregister(solrServerConfiguration, SolrServerRegistry.Strategy.SEARCHING);
        }
        if ((indexingSolrServer = SolrServerRegistry.get(solrServerConfiguration, SolrServerRegistry.Strategy.INDEXING)) != null) {
            indexingSolrServer.shutdown();
            this.log.debug("indexing SolrServer shut down");
            SolrServerRegistry.unregister(solrServerConfiguration, SolrServerRegistry.Strategy.INDEXING);
        }
    }

    private class ChangingSolrServersNodeStateDiff
    implements NodeStateDiff {
        private final NodeState nodeState;
        private final String name;

        public ChangingSolrServersNodeStateDiff(NodeState after) {
            this.nodeState = after;
            this.name = "";
        }

        public ChangingSolrServersNodeStateDiff(NodeState nodeState, String name) {
            this.nodeState = nodeState;
            this.name = name;
        }

        public boolean propertyAdded(PropertyState after) {
            if (this.isSolrServerNode(this.name, this.nodeState)) {
                NodeStateSolrServersObserver.this.shutdownRegisteredSolrServers(this.nodeState);
            }
            return true;
        }

        public boolean propertyChanged(PropertyState before, PropertyState after) {
            if (this.isSolrServerNode(this.name, this.nodeState)) {
                NodeStateSolrServersObserver.this.shutdownRegisteredSolrServers(this.nodeState);
            }
            return true;
        }

        public boolean propertyDeleted(PropertyState before) {
            if (this.isSolrServerNode(this.name, this.nodeState)) {
                NodeStateSolrServersObserver.this.shutdownRegisteredSolrServers(this.nodeState);
            }
            return true;
        }

        public boolean childNodeAdded(String name, NodeState after) {
            return true;
        }

        public boolean childNodeChanged(String name, NodeState before, NodeState after) {
            if (this.isSolrServerNode(name, before)) {
                NodeStateSolrServersObserver.this.shutdownRegisteredSolrServers(before);
            }
            return after.compareAgainstBaseState(before, (NodeStateDiff)new ChangingSolrServersNodeStateDiff(after, this.name + "/" + name));
        }

        public boolean childNodeDeleted(String name, NodeState before) {
            if (this.isSolrServerNode(name, before)) {
                NodeStateSolrServersObserver.this.shutdownRegisteredSolrServers(before);
            } else {
                for (String childNodeName : before.getChildNodeNames()) {
                    NodeState childNodeState;
                    if (!this.isSolrServerNode(childNodeName, childNodeState = before.getChildNode(childNodeName))) continue;
                    NodeStateSolrServersObserver.this.shutdownRegisteredSolrServers(childNodeState);
                    break;
                }
            }
            return true;
        }

        private boolean isSolrServerNode(String name, NodeState nodeState) {
            return "server".equals(name) && nodeState.hasProperty("solrServerType");
        }
    }
}

