/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.solr.query;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.plugins.index.aggregate.NodeAggregator;
import org.apache.jackrabbit.oak.plugins.index.solr.configuration.OakSolrConfigurationProvider;
import org.apache.jackrabbit.oak.plugins.index.solr.query.AdvancedSolrQueryIndex;
import org.apache.jackrabbit.oak.plugins.index.solr.server.SolrServerProvider;
import org.apache.jackrabbit.oak.spi.query.QueryIndex;
import org.apache.jackrabbit.oak.spi.query.QueryIndexProvider;
import org.apache.jackrabbit.oak.spi.state.ChildNodeEntry;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.solr.client.solrj.SolrServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolrQueryIndexProvider
implements QueryIndexProvider {
    private final Logger log = LoggerFactory.getLogger(SolrQueryIndexProvider.class);
    private final SolrServerProvider solrServerProvider;
    private final OakSolrConfigurationProvider oakSolrConfigurationProvider;
    private final NodeAggregator aggregator;

    public SolrQueryIndexProvider(SolrServerProvider solrServerProvider, OakSolrConfigurationProvider oakSolrConfigurationProvider, NodeAggregator nodeAggregator) {
        this.oakSolrConfigurationProvider = oakSolrConfigurationProvider;
        this.solrServerProvider = solrServerProvider;
        this.aggregator = nodeAggregator;
    }

    public SolrQueryIndexProvider(SolrServerProvider solrServerProvider, OakSolrConfigurationProvider oakSolrConfigurationProvider) {
        this(solrServerProvider, oakSolrConfigurationProvider, null);
    }

    @Nonnull
    public List<? extends QueryIndex> getQueryIndexes(NodeState nodeState) {
        ArrayList<AdvancedSolrQueryIndex> tempIndexes = new ArrayList<AdvancedSolrQueryIndex>();
        if (this.solrServerProvider == null || this.oakSolrConfigurationProvider == null) {
            return tempIndexes;
        }
        NodeState definitions = nodeState.getChildNode("oak:index");
        for (ChildNodeEntry entry : definitions.getChildNodeEntries()) {
            NodeState definition = entry.getNodeState();
            PropertyState type = definition.getProperty("type");
            if (type == null || !"solr".equals(type.getValue(Type.STRING))) continue;
            try {
                SolrServer solrServer = this.solrServerProvider.getSearchingSolrServer();
                if (solrServer != null && 0 == solrServer.ping().getStatus()) {
                    tempIndexes.add(new AdvancedSolrQueryIndex(entry.getName(), solrServer, this.oakSolrConfigurationProvider.getConfiguration(), this.aggregator));
                    continue;
                }
                if (!this.log.isWarnEnabled()) continue;
                this.log.warn("cannot create Solr query index as SolrServer {}\u00a0is unreachable", (Object)solrServer);
            }
            catch (Exception e) {
                if (!this.log.isErrorEnabled()) continue;
                this.log.error("unable to create Solr query index at " + entry.getName(), (Throwable)e);
            }
        }
        return tempIndexes;
    }
}

