/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.solr.server;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import javax.annotation.CheckForNull;
import org.apache.jackrabbit.oak.commons.IOUtils;
import org.apache.jackrabbit.oak.plugins.index.solr.configuration.EmbeddedSolrServerConfiguration;
import org.apache.jackrabbit.oak.plugins.index.solr.server.SolrServerProvider;
import org.apache.solr.client.solrj.SolrServer;
import org.apache.solr.client.solrj.embedded.EmbeddedSolrServer;
import org.apache.solr.client.solrj.embedded.JettySolrRunner;
import org.apache.solr.client.solrj.impl.HttpSolrServer;
import org.apache.solr.core.CoreContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmbeddedSolrServerProvider
implements SolrServerProvider {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final EmbeddedSolrServerConfiguration solrServerConfiguration;
    private SolrServer solrServer;

    public EmbeddedSolrServerProvider(EmbeddedSolrServerConfiguration solrServerConfiguration) {
        this.solrServerConfiguration = solrServerConfiguration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SolrServer createSolrServer() throws Exception {
        String solrHomePath = this.solrServerConfiguration.getSolrHomePath();
        String coreName = this.solrServerConfiguration.getCoreName();
        String solrConfigPath = this.solrServerConfiguration.getSolrConfigPath();
        EmbeddedSolrServerConfiguration.HttpConfiguration httpConfiguration = this.solrServerConfiguration.getHttpConfiguration();
        if (solrConfigPath != null && solrHomePath != null && coreName != null) {
            this.checkSolrConfiguration(solrHomePath, solrConfigPath, coreName);
            if (httpConfiguration != null) {
                if (this.log.isInfoEnabled()) {
                    this.log.info("starting embedded Solr server with http bindings");
                }
                ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                Thread.currentThread().setContextClassLoader(JettySolrRunner.class.getClassLoader());
                Integer httpPort = httpConfiguration.getHttpPort();
                String context = httpConfiguration.getContext();
                JettySolrRunner jettySolrRunner = null;
                try {
                    jettySolrRunner = new JettySolrRunner(solrHomePath, context, httpPort, "solrconfig.xml", "schema.xml", true);
                    if (this.log.isInfoEnabled()) {
                        this.log.info("Jetty runner instantiated");
                    }
                    jettySolrRunner.start(true);
                    if (this.log.isInfoEnabled()) {
                        this.log.info("Jetty runner started");
                    }
                }
                catch (Exception t) {
                    if (this.log.isErrorEnabled()) {
                        this.log.error("an error has occurred while starting Solr Jetty", (Throwable)t);
                    }
                }
                finally {
                    block25: {
                        if (jettySolrRunner != null && !jettySolrRunner.isRunning()) {
                            try {
                                jettySolrRunner.stop();
                                if (this.log.isInfoEnabled()) {
                                    this.log.info("Jetty runner stopped");
                                }
                            }
                            catch (Exception e) {
                                if (!this.log.isErrorEnabled()) break block25;
                                this.log.error("error while stopping the Jetty runner", (Throwable)e);
                            }
                        }
                    }
                    Thread.currentThread().setContextClassLoader(classLoader);
                }
                if (this.log.isInfoEnabled()) {
                    this.log.info("starting HTTP Solr server");
                }
                return new HttpWithJettySolrServer("http://127.0.0.1:" + httpPort + context + '/' + coreName, jettySolrRunner);
            }
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(CoreContainer.class.getClassLoader());
            CoreContainer coreContainer = new CoreContainer(solrHomePath);
            try {
                coreContainer.load();
            }
            finally {
                Thread.currentThread().setContextClassLoader(classLoader);
            }
            EmbeddedSolrServer server = new EmbeddedSolrServer(coreContainer, coreName);
            if (server.ping().getStatus() == 0) {
                return server;
            }
            throw new IOException("the embedded Solr server is not alive");
        }
        throw new Exception("SolrServer configuration proprties not set");
    }

    private void checkSolrConfiguration(String solrHomePath, String solrConfigPath, String coreName) throws IOException {
        File solrHomePathFile = new File(solrHomePath);
        if (!solrHomePathFile.exists()) {
            if (!solrHomePathFile.mkdirs()) {
                throw new IOException("could not create solrHomePath directory");
            }
            this.copy("/solr/solr.xml", solrHomePath);
            this.copy("/solr/zoo.cfg", solrHomePath);
            if (!new File(solrHomePath + "/" + coreName + "/conf").mkdirs()) {
                throw new IOException("could not create nested core directory in solrHomePath");
            }
            String solrCoreDir = solrHomePath + "/" + coreName;
            this.copy("/solr/oak/core.properties", solrCoreDir);
            String coreConfDir = solrCoreDir + "/conf/";
            this.copy("/solr/oak/conf/currency.xml", coreConfDir);
            this.copy("/solr/oak/conf/schema.xml", coreConfDir);
            this.copy("/solr/oak/conf/solrconfig.xml", coreConfDir);
        } else if (!solrHomePathFile.isDirectory()) {
            throw new IOException("a non directory file with the specified name already exists for the given solrHomePath '" + solrHomePath);
        }
        Object[] files = new File(solrHomePath).list();
        Arrays.sort(files);
        if (Arrays.binarySearch(files, coreName) < 0) {
            throw new IOException("could not find a directory with the coreName '" + coreName + "' in the solrHomePath '" + solrHomePath + "'");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copy(String resource, String dir) throws IOException {
        String fileName = dir + resource.substring(resource.lastIndexOf("/"));
        File outputFile = new File(fileName);
        if (outputFile.createNewFile()) {
            InputStream inputStream = null;
            FileOutputStream outputStream = null;
            try {
                inputStream = this.getClass().getResourceAsStream(resource);
                outputStream = new FileOutputStream(outputFile);
                IOUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
            }
            finally {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (Exception e) {}
                }
                if (outputStream != null) {
                    try {
                        outputStream.close();
                    }
                    catch (Exception e) {}
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @CheckForNull
    public SolrServer getSolrServer() throws Exception {
        EmbeddedSolrServerProvider embeddedSolrServerProvider = this;
        synchronized (embeddedSolrServerProvider) {
            if (this.solrServer == null) {
                this.solrServer = this.createSolrServer();
            }
        }
        return this.solrServer;
    }

    private class HttpWithJettySolrServer
    extends HttpSolrServer {
        private final JettySolrRunner jettySolrRunner;

        public HttpWithJettySolrServer(String s, JettySolrRunner jettySolrRunner) {
            super(s);
            this.jettySolrRunner = jettySolrRunner;
        }

        @Override
        public void shutdown() {
            super.shutdown();
            try {
                if (this.jettySolrRunner != null && this.jettySolrRunner.isRunning()) {
                    this.jettySolrRunner.stop();
                }
            }
            catch (Exception e) {
                EmbeddedSolrServerProvider.this.log.warn("could not stop JettySolrRunner {}", (Object)this.jettySolrRunner);
            }
        }
    }
}

