/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.function.distance;

import com.spatial4j.core.context.SpatialContext;
import com.spatial4j.core.distance.DistanceUtils;
import com.spatial4j.core.distance.GeodesicSphereDistCalc;
import com.spatial4j.core.io.GeohashUtils;
import com.spatial4j.core.shape.Point;
import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.queries.function.FunctionValues;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.queries.function.docvalues.DoubleDocValues;
import org.apache.lucene.search.IndexSearcher;

public class GeohashHaversineFunction
extends ValueSource {
    private final ValueSource geoHash1;
    private final ValueSource geoHash2;
    private final SpatialContext ctx;
    private final double degreesToDist;

    public GeohashHaversineFunction(ValueSource geoHash1, ValueSource geoHash2, double radius) {
        this.geoHash1 = geoHash1;
        this.geoHash2 = geoHash2;
        this.degreesToDist = DistanceUtils.degrees2Dist(1.0, radius);
        this.ctx = SpatialContext.GEO;
        assert (this.ctx.getDistCalc() instanceof GeodesicSphereDistCalc.Haversine);
    }

    protected String name() {
        return "ghhsin";
    }

    @Override
    public FunctionValues getValues(Map context, AtomicReaderContext readerContext) throws IOException {
        final FunctionValues gh1DV = this.geoHash1.getValues(context, readerContext);
        final FunctionValues gh2DV = this.geoHash2.getValues(context, readerContext);
        return new DoubleDocValues(this){

            @Override
            public double doubleVal(int doc) {
                return GeohashHaversineFunction.this.distance(doc, gh1DV, gh2DV);
            }

            @Override
            public String toString(int doc) {
                StringBuilder sb = new StringBuilder();
                sb.append(GeohashHaversineFunction.this.name()).append('(');
                sb.append(gh1DV.toString(doc)).append(',').append(gh2DV.toString(doc));
                sb.append(')');
                return sb.toString();
            }
        };
    }

    protected double distance(int doc, FunctionValues gh1DV, FunctionValues gh2DV) {
        double result = 0.0;
        String h1 = gh1DV.strVal(doc);
        String h2 = gh2DV.strVal(doc);
        if (h1 != null && h2 != null && !h1.equals(h2)) {
            Point p1 = GeohashUtils.decode(h1, this.ctx);
            Point p2 = GeohashUtils.decode(h2, this.ctx);
            result = this.ctx.getDistCalc().distance(p1, p2) * this.degreesToDist;
        } else if (h1 == null || h2 == null) {
            result = Double.MAX_VALUE;
        }
        return result;
    }

    @Override
    public void createWeight(Map context, IndexSearcher searcher) throws IOException {
        this.geoHash1.createWeight(context, searcher);
        this.geoHash2.createWeight(context, searcher);
    }

    @Override
    public boolean equals(Object o) {
        if (this.getClass() != o.getClass()) {
            return false;
        }
        GeohashHaversineFunction other = (GeohashHaversineFunction)o;
        return this.name().equals(other.name()) && this.geoHash1.equals(other.geoHash1) && this.geoHash2.equals(other.geoHash2) && this.degreesToDist == other.degreesToDist;
    }

    @Override
    public int hashCode() {
        int result = this.geoHash1.hashCode();
        result = 31 * result + this.geoHash2.hashCode();
        result = 31 * result + this.name().hashCode();
        long temp = Double.doubleToRawLongBits(this.degreesToDist);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    @Override
    public String description() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.name()).append('(');
        sb.append(this.geoHash1).append(',').append(this.geoHash2);
        sb.append(')');
        return sb.toString();
    }
}

