/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server;

import java.io.File;
import java.io.IOException;
import javax.management.JMException;
import org.apache.zookeeper.jmx.ManagedUtil;
import org.apache.zookeeper.server.ServerCnxnFactory;
import org.apache.zookeeper.server.ServerConfig;
import org.apache.zookeeper.server.ZooKeeperServer;
import org.apache.zookeeper.server.persistence.FileTxnSnapLog;
import org.apache.zookeeper.server.quorum.QuorumPeerConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZooKeeperServerMain {
    private static final Logger LOG = LoggerFactory.getLogger(ZooKeeperServerMain.class);
    private static final String USAGE = "Usage: ZooKeeperServerMain configfile | port datadir [ticktime] [maxcnxns]";
    private ServerCnxnFactory cnxnFactory;

    public static void main(String[] args) {
        ZooKeeperServerMain main = new ZooKeeperServerMain();
        try {
            main.initializeAndRun(args);
        }
        catch (IllegalArgumentException e) {
            LOG.error("Invalid arguments, exiting abnormally", (Throwable)e);
            LOG.info(USAGE);
            System.err.println(USAGE);
            System.exit(2);
        }
        catch (QuorumPeerConfig.ConfigException e) {
            LOG.error("Invalid config, exiting abnormally", (Throwable)e);
            System.err.println("Invalid config, exiting abnormally");
            System.exit(2);
        }
        catch (Exception e) {
            LOG.error("Unexpected exception, exiting abnormally", (Throwable)e);
            System.exit(1);
        }
        LOG.info("Exiting normally");
        System.exit(0);
    }

    protected void initializeAndRun(String[] args) throws QuorumPeerConfig.ConfigException, IOException {
        try {
            ManagedUtil.registerLog4jMBeans();
        }
        catch (JMException e) {
            LOG.warn("Unable to register log4j JMX control", (Throwable)e);
        }
        ServerConfig config = new ServerConfig();
        if (args.length == 1) {
            config.parse(args[0]);
        } else {
            config.parse(args);
        }
        this.runFromConfig(config);
    }

    public void runFromConfig(ServerConfig config) throws IOException {
        LOG.info("Starting server");
        try {
            ZooKeeperServer zkServer = new ZooKeeperServer();
            FileTxnSnapLog ftxn = new FileTxnSnapLog(new File(config.dataLogDir), new File(config.dataDir));
            zkServer.setTxnLogFactory(ftxn);
            zkServer.setTickTime(config.tickTime);
            zkServer.setMinSessionTimeout(config.minSessionTimeout);
            zkServer.setMaxSessionTimeout(config.maxSessionTimeout);
            this.cnxnFactory = ServerCnxnFactory.createFactory();
            this.cnxnFactory.configure(config.getClientPortAddress(), config.getMaxClientCnxns());
            this.cnxnFactory.startup(zkServer);
            this.cnxnFactory.join();
            if (zkServer.isRunning()) {
                zkServer.shutdown();
            }
        }
        catch (InterruptedException e) {
            LOG.warn("Server interrupted", (Throwable)e);
        }
    }

    protected void shutdown() {
        this.cnxnFactory.shutdown();
    }
}

