/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search;

import java.io.IOException;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.Scorer;

public class DelegatingCollector
extends Collector {
    public static int setLastDelegateCount;
    protected Collector delegate;
    protected Scorer scorer;
    protected AtomicReaderContext context;
    protected int docBase;

    public Collector getDelegate() {
        return this.delegate;
    }

    public void setDelegate(Collector delegate) {
        this.delegate = delegate;
    }

    public void setLastDelegate(Collector delegate) {
        DelegatingCollector ptr = this;
        while (ptr.getDelegate() instanceof DelegatingCollector) {
            ptr = (DelegatingCollector)ptr.getDelegate();
        }
        ptr.setDelegate(delegate);
        ++setLastDelegateCount;
    }

    @Override
    public void setScorer(Scorer scorer) throws IOException {
        this.scorer = scorer;
        this.delegate.setScorer(scorer);
    }

    @Override
    public void collect(int doc) throws IOException {
        this.delegate.collect(doc);
    }

    @Override
    public void setNextReader(AtomicReaderContext context) throws IOException {
        this.context = context;
        this.docBase = context.docBase;
        this.delegate.setNextReader(context);
    }

    @Override
    public boolean acceptsDocsOutOfOrder() {
        return this.delegate.acceptsDocsOutOfOrder();
    }

    public void finish() throws IOException {
        if (this.delegate instanceof DelegatingCollector) {
            ((DelegatingCollector)this.delegate).finish();
        }
    }
}

