/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search;

import org.apache.commons.lang.StringUtils;
import org.apache.lucene.search.Query;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.search.QParser;
import org.apache.solr.search.QParserPlugin;
import org.apache.solr.search.SyntaxError;

public class SwitchQParserPlugin
extends QParserPlugin {
    public static final String NAME = "switch";
    public static String SWITCH_CASE = "case";
    public static String SWITCH_DEFAULT = "default";

    @Override
    public void init(NamedList args) {
    }

    @Override
    public QParser createParser(String qstr, SolrParams localParams, SolrParams params, SolrQueryRequest req) {
        return new QParser(qstr, localParams, params, req){
            QParser subParser;

            @Override
            public Query parse() throws SyntaxError {
                String val = this.localParams.get("v");
                String subQ = this.localParams.get(SWITCH_DEFAULT);
                String string = subQ = StringUtils.isBlank(val) ? this.localParams.get(SWITCH_CASE, subQ) : this.localParams.get(SWITCH_CASE + "." + val.trim(), subQ);
                if (null == subQ) {
                    throw new SyntaxError("No " + SWITCH_DEFAULT + ", and no switch case matching specified query string: \"" + val + "\"");
                }
                this.subParser = this.subQuery(subQ, null);
                return this.subParser.getQuery();
            }

            @Override
            public String[] getDefaultHighlightFields() {
                return this.subParser.getDefaultHighlightFields();
            }

            @Override
            public Query getHighlightQuery() throws SyntaxError {
                return this.subParser.getHighlightQuery();
            }

            @Override
            public void addDebugInfo(NamedList<Object> debugInfo) {
                this.subParser.addDebugInfo(debugInfo);
            }
        };
    }
}

