/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import org.apache.lucene.index.AtomicReader;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.search.BitsFilteredDocIdSet;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Filter;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.WAH8DocIdSet;

public class CachingWrapperFilter
extends Filter {
    private final Filter filter;
    private final Map<Object, DocIdSet> cache = Collections.synchronizedMap(new WeakHashMap());
    int hitCount;
    int missCount;
    protected static final DocIdSet EMPTY_DOCIDSET = new DocIdSet(){

        @Override
        public DocIdSetIterator iterator() {
            return DocIdSetIterator.empty();
        }

        @Override
        public boolean isCacheable() {
            return true;
        }

        @Override
        public Bits bits() {
            return null;
        }
    };

    public CachingWrapperFilter(Filter filter) {
        this.filter = filter;
    }

    public Filter getFilter() {
        return this.filter;
    }

    protected DocIdSet docIdSetToCache(DocIdSet docIdSet, AtomicReader reader) throws IOException {
        if (docIdSet == null) {
            return EMPTY_DOCIDSET;
        }
        if (docIdSet.isCacheable()) {
            return docIdSet;
        }
        DocIdSetIterator it = docIdSet.iterator();
        if (it == null) {
            return EMPTY_DOCIDSET;
        }
        return this.cacheImpl(it, reader);
    }

    protected DocIdSet cacheImpl(DocIdSetIterator iterator, AtomicReader reader) throws IOException {
        WAH8DocIdSet.Builder builder = new WAH8DocIdSet.Builder();
        builder.add(iterator);
        return builder.build();
    }

    @Override
    public DocIdSet getDocIdSet(AtomicReaderContext context, Bits acceptDocs) throws IOException {
        AtomicReader reader = context.reader();
        Object key = reader.getCoreCacheKey();
        DocIdSet docIdSet = this.cache.get(key);
        if (docIdSet != null) {
            ++this.hitCount;
        } else {
            ++this.missCount;
            docIdSet = this.docIdSetToCache(this.filter.getDocIdSet(context, null), reader);
            assert (docIdSet.isCacheable());
            this.cache.put(key, docIdSet);
        }
        return docIdSet == EMPTY_DOCIDSET ? null : BitsFilteredDocIdSet.wrap(docIdSet, acceptDocs);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.filter + ")";
    }

    public boolean equals(Object o) {
        if (o == null || !this.getClass().equals(o.getClass())) {
            return false;
        }
        CachingWrapperFilter other = (CachingWrapperFilter)o;
        return this.filter.equals(other.filter);
    }

    public int hashCode() {
        return this.filter.hashCode() ^ this.getClass().hashCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long sizeInBytes() {
        ArrayList<DocIdSet> docIdSets;
        Map<Object, DocIdSet> map = this.cache;
        synchronized (map) {
            docIdSets = new ArrayList<DocIdSet>(this.cache.values());
        }
        long total = 0L;
        for (DocIdSet dis : docIdSets) {
            total += RamUsageEstimator.sizeOf(dis);
        }
        return total;
    }
}

